/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.handlers.constraint.MotionConstraintPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionSelection;
import com.android.tools.idea.uibuilder.handlers.motion.property2.SelectedTargetBuilder;
import com.android.tools.idea.uibuilder.handlers.motion.property2.SubTagAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.AddCustomFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.AddMotionFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.DeleteCustomFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.DeleteMotionFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.SubSectionControlAction;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.idea.uibuilder.property2.inspector.InspectorSection;
import com.android.tools.idea.uibuilder.property2.support.NeleEnumSupportProvider;
import com.android.tools.idea.uibuilder.property2.support.NeleTwoStateBooleanControlTypeProvider;
import com.android.tools.idea.uibuilder.property2.ui.EasingCurvePanel;
import com.android.tools.idea.uibuilder.property2.ui.EmptyTablePanel;
import com.android.tools.idea.uibuilder.property2.ui.TransformsPanel;
import com.android.tools.property.panel.api.EditorProvider;
import com.android.tools.property.panel.api.FilteredPTableModel;
import com.android.tools.property.panel.api.InspectorBuilder;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertiesModel;
import com.android.tools.property.panel.api.PropertiesTable;
import com.android.tools.property.panel.api.PropertiesView;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.panel.api.TableUIProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.XmlElementDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutAttributesView
extends PropertiesView<NelePropertyItem> {
    private static final String MOTION_VIEW_NAME = "Motion";
    private static final List<String> CONSTRAINT_SECTIONS = ImmutableList.of((Object)"Layout", (Object)"Motion", (Object)"PropertySet", (Object)"Transform");

    public MotionLayoutAttributesView(@NotNull MotionLayoutAttributesModel model2) {
        super(MOTION_VIEW_NAME, model2);
        NeleEnumSupportProvider enumSupportProvider2 = new NeleEnumSupportProvider(model2);
        NeleTwoStateBooleanControlTypeProvider controlTypeProvider2 = new NeleTwoStateBooleanControlTypeProvider(enumSupportProvider2);
        EditorProvider<NelePropertyItem> editorProvider = EditorProvider.Companion.create(enumSupportProvider2, controlTypeProvider2);
        TableUIProvider tableUIProvider = TableUIProvider.Companion.create(NelePropertyItem.class, controlTypeProvider2, editorProvider);
        this.getMain().getBuilders().add(new SelectedTargetBuilder());
        this.addTab("").getBuilders().add(new MotionInspectorBuilder(model2, tableUIProvider, enumSupportProvider2));
    }

    private static class MotionInspectorBuilder
    implements InspectorBuilder<NelePropertyItem> {
        private final MotionLayoutAttributesModel myModel;
        private final TableUIProvider myTableUIProvider;
        private final XmlElementDescriptorProvider myDescriptorProvider;
        private final NeleEnumSupportProvider myEnumSupportProvider;

        private MotionInspectorBuilder(@NotNull MotionLayoutAttributesModel model2, @NotNull TableUIProvider tableUIProvider, @NotNull NeleEnumSupportProvider enumSupportProvider2) {
            this.myModel = model2;
            this.myTableUIProvider = tableUIProvider;
            this.myDescriptorProvider = new AndroidDomElementDescriptorProvider();
            this.myEnumSupportProvider = enumSupportProvider2;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<NelePropertyItem> properties2) {
            NelePropertyItem any = properties2.getFirst();
            if (any == null) {
                return;
            }
            MotionSelection selection = (MotionSelection)any.getOptionalValue1();
            if (selection == null) {
                return;
            }
            switch (selection.getType()) {
                case CONSTRAINT: {
                    boolean showConstraintPanel = !this.shouldDisplaySection("Layout", selection);
                    this.addPropertyTable(inspector, selection, "Constraint", this.myModel, true, false, showConstraintPanel);
                    if (((Boolean)StudioFlags.NELE_TRANSFORM_PANEL.get()).booleanValue()) {
                        this.addTransforms(inspector, selection, this.myModel, properties2);
                    }
                    if (((Boolean)StudioFlags.NELE_TRANSITION_PANEL.get()).booleanValue()) {
                        ArrayList<String> attributes = new ArrayList<String>();
                        attributes.add("transitionEasing");
                        attributes.add("pathMotionArc");
                        attributes.add("transitionPathRotate");
                        this.addTransition(inspector, InspectorSection.TRANSITION, selection, this.myModel, "transitionEasing", properties2, attributes);
                    }
                    this.addSubTagSections(inspector, selection, this.myModel);
                    break;
                }
                case TRANSITION: {
                    this.addPropertyTable(inspector, selection, selection.getMotionSceneTagName(), this.myModel, false, false, false);
                    if (((Boolean)StudioFlags.NELE_TRANSITION_PANEL.get()).booleanValue()) {
                        ArrayList<String> attributes = new ArrayList<String>();
                        attributes.add("motionInterpolator");
                        attributes.add("staggered");
                        attributes.add("autoTransition");
                        attributes.add("pathMotionArc");
                        attributes.add("layoutDuringTransition");
                        this.addTransition(inspector, InspectorSection.TRANSITION_MODIFIERS, selection, this.myModel, "motionInterpolator", properties2, attributes);
                    }
                    this.addSubTagSections(inspector, selection, this.myModel);
                    break;
                }
                default: {
                    Map<String, PropertiesTable<NelePropertyItem>> allProperties;
                    this.addPropertyTable(inspector, selection, selection.getMotionSceneTagName(), this.myModel, false, false, false);
                    if (!((Boolean)StudioFlags.NELE_TRANSFORM_PANEL.get()).booleanValue() || !(allProperties = this.myModel.getAllProperties()).containsKey("KeyAttribute")) break;
                    this.addTransforms(inspector, selection, this.myModel, properties2);
                }
            }
            boolean showDefaultValues = selection.getType() == MotionEditorSelector.Type.CONSTRAINT;
            this.addCustomAttributes(inspector, selection, this.myModel, showDefaultValues);
        }

        private void addSubtitle(InspectorPanel inspector, String s, InspectorLineModel titleLine) {
            JLabel component = new JLabel(s);
            component.setBorder(new EmptyBorder(8, 8, 8, 8));
            inspector.addComponent(component, titleLine);
        }

        private void addTransforms(@NotNull InspectorPanel inspector, @NotNull MotionSelection selection, @NotNull MotionLayoutAttributesModel model2, @NotNull PropertiesTable<NelePropertyItem> properties2) {
            NelePropertyItem property2;
            InspectorLineModel titleModel = inspector.addExpandableTitle(InspectorSection.TRANSFORMS.getTitle(), false, Collections.emptyList());
            inspector.addComponent(new TransformsPanel(model2, properties2), titleModel);
            ArrayList<String> rotationAttributes = new ArrayList<String>();
            rotationAttributes.add("rotationX");
            rotationAttributes.add("rotationY");
            rotationAttributes.add("rotation");
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("scaleX");
            attributes.add("scaleY");
            attributes.add("translationX");
            attributes.add("translationY");
            attributes.add("alpha");
            attributes.add("visibility");
            NeleTwoStateBooleanControlTypeProvider controlTypeProvider2 = new NeleTwoStateBooleanControlTypeProvider(this.myEnumSupportProvider);
            EditorProvider<NelePropertyItem> editorProvider = EditorProvider.Companion.create(this.myEnumSupportProvider, controlTypeProvider2);
            for (String attributeName : rotationAttributes) {
                property2 = properties2.getOrNull("http://schemas.android.com/apk/res/android", attributeName);
                if (property2 == null) continue;
                inspector.addEditor(editorProvider.createEditor(property2, false), titleModel);
            }
            inspector.addComponent((JComponent)((Object)new MySeparator()), titleModel);
            this.addSubtitle(inspector, "Other Transforms", titleModel);
            for (String attributeName : attributes) {
                property2 = properties2.getOrNull("http://schemas.android.com/apk/res/android", attributeName);
                if (property2 == null) continue;
                inspector.addEditor(editorProvider.createEditor(property2, false), titleModel);
            }
        }

        private void addTransition(@NotNull InspectorPanel inspector, @NotNull InspectorSection title, @NotNull MotionSelection selection, @NotNull MotionLayoutAttributesModel model2, @NotNull String easingAttributeName, @NotNull PropertiesTable<NelePropertyItem> properties2, @NotNull ArrayList<String> attributes) {
            InspectorLineModel titleModel = inspector.addExpandableTitle(title.getTitle(), false, Collections.emptyList());
            inspector.addComponent(new EasingCurvePanel(model2, easingAttributeName, properties2), titleModel);
            NeleTwoStateBooleanControlTypeProvider controlTypeProvider2 = new NeleTwoStateBooleanControlTypeProvider(this.myEnumSupportProvider);
            EditorProvider<NelePropertyItem> editorProvider = EditorProvider.Companion.create(this.myEnumSupportProvider, controlTypeProvider2);
            for (String attributeName : attributes) {
                NelePropertyItem property2 = properties2.getOrNull("http://schemas.android.com/apk/res-auto", attributeName);
                if (property2 == null) continue;
                inspector.addEditor(editorProvider.createEditor(property2, false), titleModel);
            }
        }

        private void addSubTagSections(@NotNull InspectorPanel inspector, @NotNull MotionSelection selection, @NotNull MotionLayoutAttributesModel model2) {
            XmlElementDescriptor[] subTagDescriptors;
            XmlElementDescriptor elementDescriptor;
            XmlTag xmlTag = selection.getXmlTag(selection.getMotionSceneTag());
            XmlElementDescriptor xmlElementDescriptor = elementDescriptor = xmlTag != null ? this.myDescriptorProvider.getDescriptor(xmlTag) : null;
            if (elementDescriptor == null) {
                return;
            }
            for (XmlElementDescriptor descriptor2 : subTagDescriptors = elementDescriptor.getElementsDescriptors(xmlTag)) {
                String subTagName = descriptor2.getName();
                if (subTagName.equals("CustomAttribute")) continue;
                boolean showConstraintWidget = subTagName.equals("Layout");
                SubTagAttributesModel subModel = new SubTagAttributesModel(model2, subTagName);
                this.addPropertyTable(inspector, selection, subTagName, subModel, true, true, showConstraintWidget);
            }
        }

        private void addCustomAttributes(@NotNull InspectorPanel inspector, @NotNull MotionSelection selection, @NotNull MotionLayoutAttributesModel model2, boolean showDefaultValues) {
            if (!this.shouldDisplaySection("CustomAttribute", selection)) {
                return;
            }
            SubTagAttributesModel customModel = new SubTagAttributesModel(model2, "CustomAttribute");
            Function1 filter2 = item -> item.getNamespace().isEmpty() && (item.getRawValue() != null || showDefaultValues && item.getDefaultValue() != null);
            Function1 deleteOp = item -> null;
            FilteredPTableModel<NelePropertyItem> tableModel2 = FilteredPTableModel.PTableModelFactory.create(customModel, filter2, deleteOp, FilteredPTableModel.PTableModelFactory.getAlphabeticalSortOrder(), Collections.emptyList(), false, true, p -> true);
            AddCustomFieldAction addFieldAction = new AddCustomFieldAction(this.myModel, selection);
            DeleteCustomFieldAction deleteFieldAction = new DeleteCustomFieldAction();
            ImmutableList actions2 = ImmutableList.builder().add((Object)addFieldAction).add((Object)deleteFieldAction).build();
            InspectorLineModel title = inspector.addExpandableTitle("CustomAttributes", true, (List<? extends AnAction>)actions2);
            TableLineModel lineModel = inspector.addTable(tableModel2, true, this.myTableUIProvider, (List<? extends AnAction>)actions2, title);
            inspector.addComponent(new EmptyTablePanel(addFieldAction, lineModel), title);
            addFieldAction.setLineModel(lineModel);
            deleteFieldAction.setLineModel(lineModel);
        }

        private void addPropertyTable(@NotNull InspectorPanel inspector, @NotNull MotionSelection selection, @Nullable String sectionTagName, @NotNull PropertiesModel<NelePropertyItem> model2, boolean showDefaultValues, boolean showSectionControl, boolean showConstraintPanel) {
            if (!this.shouldDisplaySection(sectionTagName, selection)) {
                return;
            }
            NelePropertyItem any = model2.getProperties().getFirst();
            Function1 filter2 = item -> !item.getNamespace().isEmpty() && (item.getRawValue() != null || showDefaultValues && item.getDefaultValue() != null);
            Function1 deleteOp = item -> {
                item.setValue(null);
                return null;
            };
            FilteredPTableModel<NelePropertyItem> tableModel2 = FilteredPTableModel.PTableModelFactory.create(model2, filter2, deleteOp, FilteredPTableModel.PTableModelFactory.getAlphabeticalSortOrder(), Collections.emptyList(), true, true, p -> true);
            SubSectionControlAction controlAction = new SubSectionControlAction(any);
            AddMotionFieldAction addFieldAction = new AddMotionFieldAction(this.myModel, model2.getProperties());
            DeleteMotionFieldAction deleteFieldAction = new DeleteMotionFieldAction();
            ImmutableList.Builder actionsBuilder = ImmutableList.builder();
            if (showSectionControl) {
                actionsBuilder.add((Object)controlAction);
            }
            actionsBuilder.add((Object)addFieldAction);
            actionsBuilder.add((Object)deleteFieldAction);
            ImmutableList actions2 = actionsBuilder.build();
            InspectorLineModel title = inspector.addExpandableTitle(sectionTagName, true, (List<? extends AnAction>)actions2);
            if (showConstraintPanel) {
                MotionInspectorBuilder.addConstraintPanel(inspector, selection, title);
            }
            TableLineModel lineModel = inspector.addTable(tableModel2, true, this.myTableUIProvider, (List<? extends AnAction>)actions2, title);
            inspector.addComponent(new EmptyTablePanel(addFieldAction, lineModel), title);
            if (showSectionControl) {
                controlAction.setLineModel(title);
            }
            addFieldAction.setLineModel(lineModel);
            deleteFieldAction.setLineModel(lineModel);
        }

        private static void addConstraintPanel(@NotNull InspectorPanel inspector, @NotNull MotionSelection selection, @NotNull InspectorLineModel titleLine) {
            NlComponent component = selection.getComponent();
            List<NlComponent> components = component == null ? Collections.emptyList() : Collections.singletonList(component);
            MotionConstraintPanel panel2 = new MotionConstraintPanel(components);
            panel2.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
            inspector.addComponent((JComponent)((Object)panel2), titleLine);
        }

        private boolean shouldDisplaySection(@Nullable String section, @NotNull MotionSelection selection) {
            if (section == null) {
                return false;
            }
            MotionSceneTag tag = selection.getMotionSceneTag();
            switch (section) {
                case "Constraint": {
                    if (selection.getType() != MotionEditorSelector.Type.CONSTRAINT) {
                        return false;
                    }
                    if (tag == null) {
                        return true;
                    }
                    Set<String> attrs = tag.getAttrList().keySet();
                    return !MotionInspectorBuilder.isSectionedConstraint(tag) || attrs.size() > 1 || !attrs.contains("id");
                }
                case "Layout": 
                case "PropertySet": 
                case "Transform": 
                case "Motion": {
                    if (selection.getType() != MotionEditorSelector.Type.CONSTRAINT) {
                        return false;
                    }
                    return tag != null && MotionInspectorBuilder.isSectionedConstraint(tag);
                }
                case "OnClick": 
                case "OnSwipe": {
                    return selection.getType() == MotionEditorSelector.Type.TRANSITION;
                }
                case "CustomAttribute": {
                    if (tag == null && selection.getType() == MotionEditorSelector.Type.CONSTRAINT) {
                        return true;
                    }
                    return tag != null && this.canHaveCustomAttributes(tag);
                }
            }
            return section.equals(selection.getMotionSceneTagName());
        }

        private static boolean isSectionedConstraint(@NotNull MotionSceneTag constraintTag) {
            for (MTag tag : constraintTag.getChildTags()) {
                if (!CONSTRAINT_SECTIONS.contains(tag.getTagName())) continue;
                return true;
            }
            return false;
        }

        private boolean canHaveCustomAttributes(@NotNull MotionSceneTag tag) {
            XmlTag xml = tag.getXmlTag();
            if (xml == null) {
                return false;
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(xml);
            if (elementDescriptor == null) {
                return false;
            }
            for (XmlElementDescriptor childDescriptor : elementDescriptor.getElementsDescriptors(xml)) {
                if (!childDescriptor.getDefaultName().equals("CustomAttribute")) continue;
                return true;
            }
            return false;
        }

        @Override
        public void resetCache() {
        }

        private class MySeparator
        extends AdtSecondaryPanel {
            MySeparator() {
                super((LayoutManager)new BorderLayout());
                this.add(new JSeparator(0), "Center");
            }

            public void updateUI() {
                super.updateUI();
                this.setBorder(JBUI.Borders.empty((int)4));
            }
        }
    }
}

