/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionDesignSurfaceEdits;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property2.CustomAttributeType;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionDefaultPropertyValueProvider;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutPropertyProvider;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionSelection;
import com.android.tools.idea.uibuilder.handlers.motion.property2.Navigation;
import com.android.tools.idea.uibuilder.property2.NelePropertiesModel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.property.panel.api.PropertiesTable;
import com.google.common.base.Predicates;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.jvm.functions.Function0;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutAttributesModel
extends NelePropertiesModel {
    private final MotionLayoutPropertyProvider myMotionLayoutPropertyProvider = (MotionLayoutPropertyProvider)this.getProvider();
    private Map<String, PropertiesTable<NelePropertyItem>> myAllProperties;

    public MotionLayoutAttributesModel(@NotNull Disposable parentDisposable, @NotNull AndroidFacet facet2, @NotNull MergingUpdateQueue updateQueue) {
        super(parentDisposable, new MotionLayoutPropertyProvider(facet2), facet2, updateQueue, false);
        this.setDefaultValueProvider(new MotionDefaultPropertyValueProvider());
    }

    public Map<String, PropertiesTable<NelePropertyItem>> getAllProperties() {
        return this.myAllProperties;
    }

    @Override
    protected boolean loadProperties(@Nullable Object accessoryType, @Nullable Object accessory, @NotNull List<? extends NlComponent> components, @NotNull Function0<Boolean> wantUpdate2) {
        if (accessoryType == null || accessory == null || !((Boolean)wantUpdate2.invoke()).booleanValue()) {
            return false;
        }
        MotionEditorSelector.Type type = (MotionEditorSelector.Type)((Object)accessoryType);
        MTag[] tags2 = (MTag[])accessory;
        MotionSelection selection = new MotionSelection(type, tags2, components);
        MotionSelection sameOldSelection = this.findSameOldSelection(selection);
        if (sameOldSelection != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (((Boolean)wantUpdate2.invoke()).booleanValue()) {
                    sameOldSelection.update(selection);
                    this.firePropertyValueChanged();
                }
            });
            return true;
        }
        Map<String, PropertiesTable<NelePropertyItem>> newProperties = this.myMotionLayoutPropertyProvider.getAllProperties(this, selection);
        this.setLastUpdateCompleted(false);
        UIUtil.invokeLaterIfNeeded(() -> {
            try {
                if (((Boolean)wantUpdate2.invoke()).booleanValue()) {
                    this.updateLiveListeners(components);
                    PropertiesTable first = newProperties.isEmpty() ? PropertiesTable.Companion.emptyTable() : (PropertiesTable)newProperties.values().iterator().next();
                    this.myAllProperties = newProperties;
                    this.setProperties(first);
                    this.firePropertiesGenerated();
                }
            }
            finally {
                this.setLastUpdateCompleted(true);
            }
        });
        return true;
    }

    @Nullable
    private MotionSelection findSameOldSelection(@NotNull MotionSelection selection) {
        if (this.myAllProperties == null) {
            return null;
        }
        PropertiesTable nonEmptyTable = this.myAllProperties.values().stream().filter(table2 -> !table2.isEmpty()).findFirst().orElse(null);
        if (nonEmptyTable == null) {
            return null;
        }
        NelePropertyItem property2 = (NelePropertyItem)nonEmptyTable.getFirst();
        if (property2 == null) {
            Logger.getInstance(MotionLayoutAttributesModel.class).info("This table should not be empty!");
            return null;
        }
        MotionSelection oldSelection = MotionLayoutAttributesModel.getMotionSelection(property2);
        return oldSelection != null && oldSelection.sameSelection(selection) ? oldSelection : null;
    }

    @Override
    @Nullable
    public String getPropertyValue(@NotNull NelePropertyItem property2) {
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(property2);
        String subTag = MotionLayoutAttributesModel.getSubTag(property2);
        if (selection == null) {
            return null;
        }
        MotionSceneTag motionTag = selection.getMotionSceneTag();
        if (motionTag == null) {
            if (property2.getNamespace().equals("http://schemas.android.com/apk/res/android") && property2.getName().equals("id")) {
                return selection.getComponentId();
            }
            return null;
        }
        if (subTag != null && subTag.equals("CustomAttribute")) {
            MTag customTag = MotionLayoutAttributesModel.findCustomTag(motionTag, property2.getName());
            return customTag != null ? customTag.getAttributeValue(MotionLayoutPropertyProvider.mapToCustomType(property2.getType())) : null;
        }
        if (subTag == null) {
            return motionTag.getAttributeValue(property2.getName());
        }
        MotionSceneTag sectionTag = MotionLayoutAttributesModel.getSubTag(motionTag, subTag);
        if (sectionTag == null) {
            return null;
        }
        return sectionTag.getAttributeValue(property2.getName());
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.myAllProperties = Collections.emptyMap();
    }

    @Override
    @Nullable
    public XmlTag getPropertyTag(@NotNull NelePropertyItem property2) {
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(property2);
        if (selection == null) {
            return null;
        }
        MotionSceneTag motionTag = selection.getMotionSceneTag();
        if (motionTag == null) {
            return null;
        }
        return selection.getXmlTag(motionTag);
    }

    @Override
    public void setPropertyValue(@NotNull NelePropertyItem property2, @Nullable String newValue) {
        String attributeName = property2.getName();
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(property2);
        String subTagName = MotionLayoutAttributesModel.getSubTag(property2);
        MTag.TagWriter tagWriter = null;
        if (selection == null) {
            return;
        }
        MotionSceneTag motionTag = selection.getMotionSceneTag();
        if (motionTag == null) {
            tagWriter = MotionLayoutAttributesModel.createConstraintTag(selection);
        } else if (subTagName != null && subTagName.equals("CustomAttribute")) {
            MTag customTag = MotionLayoutAttributesModel.findCustomTag(motionTag, property2.getName());
            if (customTag != null) {
                tagWriter = MotionSceneUtils.getTagWriter(customTag);
                attributeName = MotionLayoutPropertyProvider.mapToCustomType(property2.getType());
            }
        } else if (subTagName == null) {
            tagWriter = MotionSceneUtils.getTagWriter(motionTag);
        } else if (selection.getType() == MotionEditorSelector.Type.CONSTRAINT || selection.getType() == MotionEditorSelector.Type.TRANSITION) {
            MotionSceneTag sectionTag = MotionLayoutAttributesModel.getSubTag(motionTag, subTagName);
            if (sectionTag != null) {
                tagWriter = MotionSceneUtils.getTagWriter(sectionTag);
            } else if (newValue != null) {
                tagWriter = MotionLayoutAttributesModel.createSubTag(selection, motionTag, subTagName);
            }
        }
        if (tagWriter != null) {
            tagWriter.setAttribute(property2.getNamespace(), attributeName, newValue);
            tagWriter.commit(String.format("Set %1$s.%2$s to %3$s", tagWriter.getTagName(), property2.getName(), newValue));
        }
    }

    @Override
    public void browseToValue(@NotNull NelePropertyItem property2) {
        Navigation.INSTANCE.browseToValue(property2);
    }

    public static MTag.TagWriter createSubTag(@NotNull MotionSelection selection, @NotNull MotionSceneTag constraintTag, @NotNull String section) {
        MTag.TagWriter tagWriter = MotionSceneUtils.getChildTagWriter(constraintTag, section);
        MotionAttributes attrs = selection.getMotionAttributes();
        if (attrs != null) {
            Predicate<MotionAttributes.DefinedAttribute> isApplicable = MotionLayoutAttributesModel.findIncludePredicate(section);
            for (MotionAttributes.DefinedAttribute attr : attrs.getAttrMap().values()) {
                if (!isApplicable.test(attr)) continue;
                tagWriter.setAttribute(attr.getNamespace(), attr.getName(), attr.getValue());
            }
        }
        return tagWriter;
    }

    private static Predicate<MotionAttributes.DefinedAttribute> findIncludePredicate(@NotNull String sectionName) {
        switch (sectionName) {
            case "Layout": {
                return attr -> attr.isLayoutAttribute();
            }
            case "PropertySet": {
                return attr -> attr.isPropertySetAttribute();
            }
            case "Transform": {
                return attr -> attr.isTransformAttribute();
            }
            case "Motion": {
                return attr -> attr.isMotionAttribute();
            }
        }
        return Predicates.alwaysFalse();
    }

    public void createCustomXmlTag(@NotNull MotionSelection selection, @NotNull String attrName, @NotNull String value2, @NotNull CustomAttributeType type, @NotNull Consumer<MotionSceneTag> operation) {
        String valueAttrName = type.getTagName();
        String newValue = StringUtil.isNotEmpty((String)value2) ? value2 : type.getDefaultValue();
        String commandName = String.format("Set %1$s.%2$s to %3$s", "CustomAttribute", attrName, newValue);
        MTag.TagWriter tagWriter = null;
        MTag oldCustomTag = null;
        MotionSceneTag motionTag = selection.getMotionSceneTag();
        if (motionTag == null) {
            tagWriter = MotionLayoutAttributesModel.createConstraintTag(selection);
            if (tagWriter == null) {
                return;
            }
        } else {
            oldCustomTag = MotionLayoutAttributesModel.findCustomTag(motionTag, attrName);
        }
        MTag.TagWriter constraintWriter = tagWriter;
        tagWriter = tagWriter != null ? tagWriter.getChildTagWriter("CustomAttribute") : (oldCustomTag != null ? oldCustomTag.getTagWriter() : motionTag.getChildTagWriter("CustomAttribute"));
        tagWriter.setAttribute("http://schemas.android.com/apk/res-auto", "attributeName", attrName);
        tagWriter.setAttribute("http://schemas.android.com/apk/res-auto", valueAttrName, newValue);
        if (oldCustomTag != null) {
            for (String attr : MotionSceneAttrs.ourCustomAttribute) {
                if (attr == valueAttrName) continue;
                tagWriter.setAttribute("http://schemas.android.com/apk/res-auto", attr, null);
            }
        }
        MTag.TagWriter committer = constraintWriter != null ? constraintWriter : tagWriter;
        Runnable transaction = () -> {
            MTag createdCustomTag = committer.commit(commandName);
            if (!createdCustomTag.getTagName().equals("CustomAttribute")) {
                createdCustomTag = createdCustomTag.getChildTags("CustomAttribute")[0];
            }
            operation.accept((MotionSceneTag)createdCustomTag);
        };
        ApplicationManager.getApplication().assertIsDispatchThread();
        WriteCommandAction.runWriteCommandAction((Project)this.getFacet().getModule().getProject(), (String)commandName, null, (Runnable)transaction, (PsiFile[])new PsiFile[]{selection.getSceneFile()});
    }

    private static MTag.TagWriter createConstraintTag(@NotNull MotionSelection selection) {
        if (selection.getType() != MotionEditorSelector.Type.CONSTRAINT) {
            return null;
        }
        MotionAttributes attrs = selection.getMotionAttributes();
        if (attrs == null) {
            return null;
        }
        MTag constraintSetTag = attrs.getConstraintSet();
        if (constraintSetTag == null) {
            return null;
        }
        MTag.TagWriter tagWriter = constraintSetTag.getChildTagWriter("Constraint");
        if (tagWriter == null) {
            return null;
        }
        tagWriter.setAttribute("http://schemas.android.com/apk/res/android", "id", selection.getComponentId());
        for (MotionAttributes.DefinedAttribute attr : attrs.getAttrMap().values()) {
            tagWriter.setAttribute(attr.getNamespace(), attr.getName(), attr.getValue());
        }
        return tagWriter;
    }

    @Override
    protected boolean wantSelectionUpdate(@Nullable DesignSurface surface2, @Nullable DesignSurface activeSurface, @Nullable AccessoryPanelInterface panel2, @Nullable AccessoryPanelInterface activePanel, @Nullable Object selectedAccessoryType, @Nullable Object selectedAccessory) {
        return surface2 != null && surface2 == activeSurface && panel2 instanceof MotionDesignSurfaceEdits && panel2 == activePanel && selectedAccessoryType != null && selectedAccessory != null;
    }

    @Nullable
    public static MotionSelection getMotionSelection(@NotNull NelePropertyItem property2) {
        return (MotionSelection)property2.getOptionalValue1();
    }

    @Nullable
    public static String getSubTag(@NotNull NelePropertyItem property2) {
        return (String)property2.getOptionalValue2();
    }

    @Nullable
    public static MTag findCustomTag(MotionSceneTag motionTag, @Nullable String attrName) {
        if (attrName == null) {
            return null;
        }
        return Arrays.stream(motionTag.getChildTags("CustomAttribute")).filter(child -> attrName.equals(child.getAttributeValue("attributeName"))).findFirst().orElse(null);
    }

    @Nullable
    public static MotionSceneTag getSubTag(@NotNull MotionSceneTag constraint, @NotNull String sectionTagName) {
        MTag[] tags2 = constraint.getChildTags(sectionTagName);
        if (tags2.length == 0 || !(tags2[0] instanceof MotionSceneTag)) {
            return null;
        }
        return (MotionSceneTag)tags2[0];
    }
}

