/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEScenePicker;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.StringMTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MTagActionListener;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Drawing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JPanel;

class OverviewPanel
extends JPanel {
    public static final boolean DEBUG = false;
    private static final int ROUND_SIZE = 5;
    static Font ourBaseFont = new Font("SansSerif", 1, 12);
    MEScenePicker picker = new MEScenePicker();
    MTag mMotionScene;
    MTag[] mConstraintSet;
    MTag[] mTransitions;
    int[] mTransitionStart;
    int[] mTransitionEnd;
    int[] mOnActionSize;
    String[] mConstraintSetNames;
    int mTransitionSelected = -1;
    int mConstraintSetSelected = -1;
    private MTag mLayout;
    MTagActionListener mListener;
    private Stroke mThickStroke = new BasicStroke(2.0f);
    private Stroke mDashStroke = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{5.0f, 5.0f}, 0.0f);
    GeneralPath mPath = new GeneralPath();
    int mRectPathLen = 4;
    int[] mRectPathX = new int[this.mRectPathLen];
    int[] mRectPathY = new int[this.mRectPathLen];
    private boolean mComputedDerivedLines = false;
    private static int MIN_CS_WIDTH = MEUI.scale(50);
    private static int MAX_CS_WIDTH = MEUI.scale(80);
    boolean mHighlightStart = false;
    boolean mHighlightEnd = false;
    private static final String MAIN_TOOL_TIP = null;
    private static int CS_GAP = MEUI.scale(20);
    private static int ARROW_HEIGHT = 10;
    private int arrow_spacing;
    private MTag mMouseOverObject;
    private static final Stroke ourFatStroke = new BasicStroke(5.0f);
    private static final Stroke ourSelectedStroke = new BasicStroke(2.0f);
    private MTag mMouseOverDerived;
    private float mTransitionProgress = Float.NaN;
    private boolean mControlDown = false;
    DerivedSetLine[] mDerivedLines = new DerivedSetLine[10];
    int mTotalDerivedLines;
    int cs_width;
    int cs_height;

    public void setTransitionProgress(float pos) {
        this.mTransitionProgress = pos;
        this.repaint();
    }

    public void setActionListener(MTagActionListener l) {
        this.mListener = l;
    }

    public OverviewPanel() {
        for (int i2 = 0; i2 < this.mDerivedLines.length; ++i2) {
            this.mDerivedLines[i2] = new DerivedSetLine();
        }
        this.mTotalDerivedLines = 0;
        this.setBackground(MEUI.ourPrimaryPanelBackground);
        this.setToolTipText("OverViewPanel showing ConstraintSets and Transitions");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                OverviewPanel.this.requestFocusInWindow();
                OverviewPanel.this.updateFromMouse(e.getX(), e.getY(), false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                OverviewPanel.this.mControlDown = e.isControlDown();
                OverviewPanel.this.updateFromMouse(e.getX(), e.getY(), true);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                OverviewPanel.this.updateFromMouse(e.getX(), e.getY(), false);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                OverviewPanel.this.updateFromMouse(e.getX(), e.getY(), false);
            }
        });
        this.picker.setSelectListener(new MEScenePicker.HitElementListener(){

            @Override
            public void over(Object over, double dist) {
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int flag;
                OverviewPanel.this.mControlDown = e.isControlDown();
                int n = flag = OverviewPanel.this.mControlDown ? 1 : 0;
                if (OverviewPanel.this.mTransitionSelected >= 0) {
                    switch (e.getExtendedKeyCode()) {
                        case 8: 
                        case 127: {
                            OverviewPanel.this.mListener.delete(new MTag[]{OverviewPanel.this.mTransitions[OverviewPanel.this.mTransitionSelected]}, 0);
                            return;
                        }
                        case 38: {
                            OverviewPanel.this.setTransitionSetIndex((OverviewPanel.this.mTransitionSelected - 1 + OverviewPanel.this.mTransitions.length) % OverviewPanel.this.mTransitions.length);
                            break;
                        }
                        case 40: {
                            OverviewPanel.this.setConstraintSetIndex(0);
                            if (OverviewPanel.this.mListener == null) break;
                            OverviewPanel.this.mListener.select(OverviewPanel.this.mConstraintSet[0], flag);
                            break;
                        }
                        case 37: {
                            OverviewPanel.this.setTransitionSetIndex((OverviewPanel.this.mTransitionSelected - 1 + OverviewPanel.this.mTransitions.length) % OverviewPanel.this.mTransitions.length);
                            break;
                        }
                        case 39: {
                            OverviewPanel.this.setTransitionSetIndex((OverviewPanel.this.mTransitionSelected + 1) % OverviewPanel.this.mTransitions.length);
                        }
                    }
                    if (OverviewPanel.this.mTransitionSelected >= 0 && OverviewPanel.this.mListener != null) {
                        OverviewPanel.this.mListener.select(OverviewPanel.this.mTransitions[OverviewPanel.this.mTransitionSelected], flag);
                    }
                } else if (OverviewPanel.this.mConstraintSetSelected >= 0) {
                    switch (e.getKeyCode()) {
                        case 67: {
                            if (!e.isControlDown() && !e.isMetaDown()) break;
                            MEUI.copy(OverviewPanel.this.mConstraintSet[OverviewPanel.this.mConstraintSetSelected - 1]);
                            break;
                        }
                        case 86: {
                            if (!e.isControlDown() && !e.isMetaDown()) break;
                            OverviewPanel.this.paste();
                            break;
                        }
                        case 8: 
                        case 127: {
                            if (OverviewPanel.this.mConstraintSetSelected > 0 && OverviewPanel.this.mConstraintSetSelected - 1 < OverviewPanel.this.mConstraintSet.length) {
                                OverviewPanel.this.mListener.delete(new MTag[]{OverviewPanel.this.mConstraintSet[OverviewPanel.this.mConstraintSetSelected - 1]}, 0);
                            }
                            return;
                        }
                        case 38: {
                            if (OverviewPanel.this.mTransitions.length <= 0) break;
                            OverviewPanel.this.setTransitionSetIndex(0);
                            if (OverviewPanel.this.mListener == null) break;
                            OverviewPanel.this.mListener.select(OverviewPanel.this.mTransitions[0], flag);
                            break;
                        }
                        case 40: {
                            OverviewPanel.this.setConstraintSetIndex((OverviewPanel.this.mConstraintSetSelected + 1) % (OverviewPanel.this.mConstraintSet.length + 1));
                            break;
                        }
                        case 37: {
                            OverviewPanel.this.setConstraintSetIndex((OverviewPanel.this.mConstraintSetSelected - 1 + 1 + OverviewPanel.this.mConstraintSet.length) % (OverviewPanel.this.mConstraintSet.length + 1));
                            break;
                        }
                        case 39: {
                            OverviewPanel.this.setConstraintSetIndex((OverviewPanel.this.mConstraintSetSelected + 1) % (OverviewPanel.this.mConstraintSet.length + 1));
                        }
                    }
                    if (OverviewPanel.this.mListener != null) {
                        if (OverviewPanel.this.mConstraintSetSelected == 0) {
                            OverviewPanel.this.mListener.select(OverviewPanel.this.mLayout, flag);
                        } else if (OverviewPanel.this.mConstraintSetSelected > 0 && OverviewPanel.this.mConstraintSet.length > OverviewPanel.this.mConstraintSetSelected - 1) {
                            OverviewPanel.this.mListener.select(OverviewPanel.this.mConstraintSet[OverviewPanel.this.mConstraintSetSelected - 1], flag);
                        }
                    }
                }
            }
        });
    }

    private void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String buff = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            StringMTag pastedTag = StringMTag.parse(buff);
            HashMap<String, MTag.Attribute> attr = pastedTag.getAttrList();
            if ("ConstraintSet".equals(pastedTag.getTagName())) {
                MTag.TagWriter writer = this.mMotionScene.getChildTagWriter("ConstraintSet");
                if (writer == null) {
                    return;
                }
                for (String s : attr.keySet()) {
                    MTag.Attribute a = attr.get(s);
                    if (a == null || a.mAttribute.equals("id")) {
                        String value2 = a.mValue;
                        if (value2.matches(".*_c[0123456789]+")) {
                            int n = value2.lastIndexOf("_c");
                            int end = Integer.parseInt(value2.substring(n + 2));
                            String start2 = value2.substring(0, n);
                            value2 = start2 + "_c" + (end + 1);
                        } else {
                            value2 = value2.matches(".*_c") ? value2 + "1" : value2 + "_c";
                        }
                        writer.setAttribute(a.mNamespace, a.mAttribute, value2);
                        continue;
                    }
                    writer.setAttribute(a.mNamespace, a.mAttribute, a.mValue);
                }
                this.addRecursive(pastedTag.getChildTags(), writer);
                writer.commit("paste");
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addRecursive(StringMTag[] children, MTag.TagWriter writer) {
        if (children == null || children.length == 0) {
            return;
        }
        for (StringMTag child : children) {
            MTag.TagWriter childWriter = writer.getChildTagWriter(child.getTagName());
            HashMap<String, MTag.Attribute> attr = child.getAttrList();
            for (String s : attr.keySet()) {
                MTag.Attribute a = attr.get(s);
                childWriter.setAttribute(a.mNamespace, a.mAttribute, a.mValue);
                this.addRecursive(child.getChildTags(), childWriter);
            }
        }
    }

    private void updateFromMouse(int x, int y, boolean select2) {
        final MTag[] objects = new MTag[1];
        final DerivedSetLine[] line2 = new DerivedSetLine[1];
        this.picker.setSelectListener(new MEScenePicker.HitElementListener(){

            @Override
            public void over(Object over, double dist) {
                if (over instanceof MTag) {
                    objects[0] = (MTag)over;
                } else {
                    line2[0] = (DerivedSetLine)over;
                }
            }
        });
        this.picker.find(x, y);
        if (line2[0] != null && this.mMouseOverDerived != line2[0].mConstraintSet) {
            this.mMouseOverDerived = line2[0].mConstraintSet;
            String id = Utils.stripID(line2[0].mConstraintSet.getAttributeValue("id"));
            this.setToolTipText(id + " derives from " + line2[0].mDerivedFrom);
            this.mMouseOverObject = null;
            this.repaint();
            return;
        }
        if (line2[0] == null && this.mMouseOverDerived != null) {
            this.mMouseOverDerived = null;
            this.setToolTipText(MAIN_TOOL_TIP);
            this.repaint();
        }
        if (objects[0] == null) {
            if (this.mMouseOverObject != null) {
                this.mMouseOverObject = null;
                this.setToolTipText(MAIN_TOOL_TIP);
                this.repaint();
            }
            return;
        }
        MTag found = objects[0];
        if (select2 && this.mListener != null) {
            this.mListener.select(found, this.mControlDown ? 1 : 0);
        } else if (this.mMouseOverObject != found) {
            this.mMouseOverObject = found;
            switch (found.getTagName()) {
                case "Transition": {
                    this.setToolTipText("Transition " + Utils.formatTransition(found));
                    break;
                }
                case "ConstraintSet": {
                    this.setToolTipText("ConstraintSet " + Utils.stripID(found.getAttributeValue("id")));
                    break;
                }
                default: {
                    this.setToolTipText("Original MotionLayout");
                }
            }
            this.repaint();
        }
    }

    void debugSize(String str) {
        int w = this.getWidth();
        int h = this.getHeight();
        System.out.println(str + " act w,h = " + w + "," + h);
        Dimension d = this.getPreferredSize();
        System.out.println(str + " prf w,h = " + d.width + "," + d.height);
        d = this.getMinimumSize();
        System.out.println(str + " min w,h = " + d.width + "," + d.height);
        d = this.getMaximumSize();
        System.out.println(str + " max w,h = " + d.width + "," + d.height);
    }

    private void calcDimensions() {
        boolean has_strings = false;
        for (int i2 = 0; i2 < this.mTransitions.length; ++i2) {
            if (null == this.mTransitions[i2].getAttributeValue("id")) continue;
            has_strings = true;
            break;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int spaces = CS_GAP * this.mConstraintSet.length + 3;
        int noc = this.mConstraintSet.length + 1;
        this.cs_width = (w - CS_GAP * 2 - 2) / noc - CS_GAP;
        if (this.cs_width > MAX_CS_WIDTH) {
            this.cs_width = MAX_CS_WIDTH;
        } else if (this.cs_width < MIN_CS_WIDTH) {
            this.cs_width = MIN_CS_WIDTH;
        }
        int p_width = (this.cs_width + CS_GAP) * noc + 2 + CS_GAP;
        this.cs_height = this.cs_width * 3 / 2;
        int str_space = 0;
        if (has_strings) {
            int font_height = this.getFontMetrics(this.getFont()).getHeight();
            str_space = font_height / 2;
        }
        this.arrow_spacing = str_space + CS_GAP + ARROW_HEIGHT;
        int transition_height = CS_GAP + this.arrow_spacing + this.mTransitions.length * this.arrow_spacing;
        int derive_height = 46;
        int p_height = derive_height + transition_height + this.cs_height + CS_GAP;
        this.setPreferredSize(new Dimension(p_width, p_height));
    }

    private int getmConstraintSetX(int number) {
        if (number > 0) {
            return (this.cs_width + CS_GAP) * number + CS_GAP * 2 + 2;
        }
        return (this.cs_width + CS_GAP) * number + CS_GAP;
    }

    @Override
    public void paint(Graphics g) {
        int lineSrcX;
        int toRectX;
        int fromRectX;
        int j;
        int i2;
        int y;
        int x2;
        int x1;
        int end;
        int start2;
        int clicks;
        int swipes;
        int i3;
        if (this.mMotionScene == null) {
            return;
        }
        Graphics2D g2g = (Graphics2D)g;
        this.picker.reset();
        int w = this.getWidth();
        int h = this.getHeight();
        this.calcDimensions();
        int noc = this.mConstraintSet.length + 1;
        int space = 10;
        if (space * (noc + 1) * 2 > w) {
            space = 1;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        if (noc == 0) {
            return;
        }
        boolean focus = this.hasFocus();
        Color colorNormalLine = MEUI.Overview.ourCS_Border;
        Color colorHoverLine = MEUI.Overview.ourCS_HoverBorder;
        Color colorSelectedLine = focus ? MEUI.Overview.ourCS_SelectedFocusBorder : MEUI.Overview.ourCS_SelectedBorder;
        int csWidth = this.cs_width;
        Stroke stroke = g2g.getStroke();
        g2g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int yGap = 24;
        int selectedStart = -1;
        int selectedEnd = -1;
        int constraintSetY = CS_GAP + this.arrow_spacing + this.mTransitions.length * this.arrow_spacing;
        int yoffset = CS_GAP + this.arrow_spacing - ARROW_HEIGHT / 2;
        Arrays.fill(this.mOnActionSize, 0);
        for (i3 = 0; i3 < this.mTransitions.length; ++i3) {
            swipes = 0;
            clicks = 0;
            for (MTag tag : this.mTransitions[i3].getChildren()) {
                String tagName = tag.getTagName();
                if ("OnSwipe".equals(tagName)) {
                    ++swipes;
                }
                if (!"OnClick".equals(tagName)) continue;
                ++clicks;
            }
            start2 = this.mTransitionStart[i3];
            end = this.mTransitionEnd[i3];
            x1 = this.getmConstraintSetX(start2 + 1) + csWidth / 2;
            x2 = this.getmConstraintSetX(end + 1) + csWidth / 2;
            y = yoffset + i3 * this.arrow_spacing;
            g.setColor(this.mTransitionSelected == i3 ? colorSelectedLine : colorNormalLine);
            if (this.mTransitionSelected == i3) {
                selectedStart = start2;
                selectedEnd = end;
                g.setColor(colorSelectedLine);
            } else {
                g.setColor(colorNormalLine);
            }
            boolean hoverHighlight = this.mMouseOverObject != null & this.mTransitions[i3] == this.mMouseOverObject;
            this.drawTransition((Graphics2D)g, hoverHighlight, x1, x2, y, constraintSetY, this.mTransitions[i3], Float.NaN, 0.0f);
            if (clicks <= 0 && swipes <= 0) continue;
            this.mOnActionSize[i3] = this.drawActions(g, swipes, clicks, x1, x2, y);
        }
        ((Graphics2D)g).setStroke(ourSelectedStroke);
        for (i3 = 0; i3 < this.mTransitions.length; ++i3) {
            String str;
            swipes = 0;
            clicks = 0;
            for (MTag tag : this.mTransitions[i3].getChildren()) {
                String tagName = tag.getTagName();
                if ("OnSwipe".equals(tagName)) {
                    ++swipes;
                }
                if (!"OnClick".equals(tagName)) continue;
                ++clicks;
            }
            start2 = this.mTransitionStart[i3];
            end = this.mTransitionEnd[i3];
            x1 = this.getmConstraintSetX(start2 + 1) + csWidth / 2;
            x2 = this.getmConstraintSetX(end + 1) + csWidth / 2;
            y = yoffset + i3 * this.arrow_spacing;
            g.setColor(this.mTransitionSelected == i3 ? colorSelectedLine : colorNormalLine);
            if (this.mTransitionSelected != i3) continue;
            selectedStart = start2;
            selectedEnd = end;
            g.setColor(colorSelectedLine);
            float stagger = 0.0f;
            if (this.mTransitionSelected == i3 && !Float.isNaN(this.mTransitionProgress) && (str = this.mTransitions[i3].getAttributeValue("staggered")) != null) {
                stagger = Float.parseFloat(str);
            }
            boolean hoverHighlight = this.mMouseOverObject != null & this.mTransitions[i3] == this.mMouseOverObject;
            this.drawTransition((Graphics2D)g, hoverHighlight, x1, x2, y, constraintSetY, this.mTransitions[i3], this.mTransitionProgress, stagger);
            if (clicks <= 0 && swipes <= 0) continue;
            this.drawActions(g, swipes, clicks, x1, x2, y);
        }
        for (i3 = 0; i3 < this.mTransitions.length; ++i3) {
            int start3 = this.mTransitionStart[i3];
            int end2 = this.mTransitionEnd[i3];
            int x12 = this.getmConstraintSetX(start3 + 1) + csWidth / 2;
            int x22 = this.getmConstraintSetX(end2 + 1) + csWidth / 2;
            int y2 = yoffset + i3 * this.arrow_spacing;
            g.setColor(this.mTransitionSelected == i3 ? colorSelectedLine : colorNormalLine);
            if (this.mTransitionSelected == i3) {
                selectedStart = start3;
                selectedEnd = end2;
                g.setColor(colorSelectedLine);
            } else {
                g.setColor(colorNormalLine);
            }
            this.picker.addLine(this.mTransitions[i3], 3, x12, y2, x22, y2, 2);
            String str = this.mTransitions[i3].getAttributeValue("id");
            if (str == null) continue;
            g.setFont(ourBaseFont);
            str = Utils.stripID(str);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds2 = fm.getStringBounds(str, g);
            int strX = x12 > x22 ? x12 - (int)bounds2.getWidth() - 20 : x12 + 4;
            Color tmp = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(strX += this.mOnActionSize[i3], y2 - fm.getHeight(), (int)bounds2.getWidth(), (int)bounds2.getHeight());
            g.setColor(tmp);
            g.drawString(str, strX, y2 - 5);
        }
        int csHeight = this.cs_height;
        g2g.setStroke(this.mThickStroke);
        g.setFont(ourBaseFont);
        FontMetrics fm = g.getFontMetrics();
        String maxString = "Layout";
        int maxStringWidth = maxString.length();
        for (int i4 = 0; i4 < this.mConstraintSetNames.length; ++i4) {
            int width = this.mConstraintSetNames[i4].length();
            if (width <= maxStringWidth) continue;
            maxStringWidth = width;
            maxString = this.mConstraintSetNames[i4];
        }
        maxStringWidth = fm.stringWidth(maxString);
        int margin = MEUI.scale(1);
        g.setFont(ourBaseFont);
        while (csWidth < maxStringWidth + margin) {
            float f = (float)g.getFont().getSize() / 1.4f;
            g.setFont(g.getFont().deriveFont(f));
            fm = g.getFontMetrics();
            maxStringWidth = fm.stringWidth(maxString);
        }
        int line_x = this.getmConstraintSetX(1) - CS_GAP - 1;
        int line_y = constraintSetY;
        g.setColor(colorNormalLine);
        g.drawLine(line_x, line_y, line_x, line_y + this.cs_height);
        if (this.mTransitions.length == 0 && this.mConstraintSet.length == 0) {
            Image constraintSetImage = MEIcons.getUnscaledIconImage(MEIcons.CREATE_CONSTRAINTSET);
            Image transitionImage = MEIcons.getUnscaledIconImage(MEIcons.CREATE_TRANSITION);
            ((Graphics2D)g).drawImage(constraintSetImage, line_x + 72, line_y - 30 + this.cs_height / 2, constraintSetImage.getWidth(null), constraintSetImage.getHeight(null), null);
            ((Graphics2D)g).drawImage(transitionImage, line_x + 62, line_y + 4 + this.cs_height / 2, transitionImage.getWidth(null), transitionImage.getHeight(null), null);
            ((Graphics2D)g).drawString("      Use       to create a new", line_x + 20, line_y - 16 + this.cs_height / 2);
            ((Graphics2D)g).drawString("     constraint set, and use to", line_x + 20, line_y + this.cs_height / 2);
            ((Graphics2D)g).drawString("create       a transition between", line_x + 20, line_y + 16 + this.cs_height / 2);
            ((Graphics2D)g).drawString("        two constraint sets", line_x + 20, line_y + 32 + this.cs_height / 2);
        }
        for (int i5 = 0; i5 <= this.mConstraintSet.length; ++i5) {
            int stringWidth;
            boolean transitionHighlightEnd;
            boolean selected;
            int setIndex = i5 - 1;
            if (i5 == 0) {
                setIndex = this.mConstraintSet.length;
            }
            int x = this.getmConstraintSetX(i5);
            int y3 = constraintSetY;
            boolean hover = false;
            boolean drawLayout = i5 == 0;
            boolean bl = selected = this.mConstraintSetSelected == i5;
            if (selectedEnd == setIndex || selectedStart == setIndex) {
                selected = true;
            }
            boolean transitionHighlightStart = this.mHighlightStart && selectedStart == setIndex;
            boolean bl2 = transitionHighlightEnd = this.mHighlightEnd && selectedEnd == setIndex;
            if (this.mMouseOverObject != null) {
                boolean bl3 = hover = (drawLayout ? this.mLayout : this.mConstraintSet[setIndex]) == this.mMouseOverObject;
            }
            if (!drawLayout) {
                this.picker.addRect(this.mConstraintSet[setIndex], 3, x, y3, x + csWidth, y3 + csHeight);
            } else {
                this.picker.addRect(this.mLayout, 3, x, y3, x + csWidth, y3 + csHeight);
            }
            String name = drawLayout ? "Layout" : this.mConstraintSetNames[setIndex];
            Color colorBackground = MEUI.Overview.ourCS_Background;
            Color textColor = MEUI.Overview.ourCS_TextColor;
            if (this.mConstraintSetSelected == i5) {
                if (focus) {
                    colorBackground = MEUI.Overview.ourCS_SelectedFocusBackground;
                    textColor = MEUI.Overview.ourCS_FocusTextColor;
                } else {
                    colorBackground = MEUI.Overview.ourCS_SelectedBackground;
                }
            }
            g.setColor(colorBackground);
            g.fillRoundRect(x, y3, csWidth, csHeight, space, space);
            Color color = colorNormalLine;
            if (hover) {
                color = colorHoverLine;
            }
            if (selected) {
                color = colorSelectedLine;
            }
            if (transitionHighlightStart || transitionHighlightEnd) {
                color = MEUI.Overview.ourPositionColor;
            }
            g.setColor(color);
            g.drawRoundRect(x, y3, csWidth, csHeight, space, space);
            if (i5 == 0) {
                g.setColor(colorBackground);
                g.fillRoundRect(x, y3, csWidth, csHeight, space, space);
                g.setColor(MEUI.Overview.ourML_BarColor);
                g.fillRoundRect(x, y3, csWidth, csHeight / 4 + 1, space, space);
                g.setColor(color);
                g.drawRoundRect(x, y3, csWidth, csHeight, space, space);
                g.fillRect(x, y3 + csHeight / 4, csWidth, 2);
            }
            g.setColor(textColor);
            if (drawLayout) {
                stringWidth = fm.stringWidth("Motion");
                int mx = x + (csWidth - stringWidth) / 2;
                int my = y3 + csHeight / 2 - fm.getHeight() + fm.getAscent();
                g.drawString("Motion", mx, my);
                stringWidth = fm.stringWidth("Layout");
                int lx = x + (csWidth - stringWidth) / 2;
                int ly = y3 + csHeight / 2 + fm.getAscent();
                g.drawString("Layout", lx, ly);
                continue;
            }
            stringWidth = fm.stringWidth(name);
            g.drawString(name, x += (csWidth - stringWidth) / 2, y3 += (csHeight - fm.getHeight()) / 2 + fm.getAscent());
        }
        int rectY = constraintSetY;
        int lineY = rectY + csHeight;
        if (!this.mComputedDerivedLines) {
            this.mTotalDerivedLines = 0;
            if (this.mDerivedLines.length < this.mConstraintSet.length) {
                this.mDerivedLines = new DerivedSetLine[this.mConstraintSet.length + 1];
                for (i2 = 0; i2 < this.mDerivedLines.length; ++i2) {
                    this.mDerivedLines[i2] = new DerivedSetLine();
                }
            }
            for (i2 = 0; i2 < this.mConstraintSet.length; ++i2) {
                String derived = Utils.stripID(this.mConstraintSet[i2].getAttributeValue("deriveConstraintsFrom"));
                if (derived == null) continue;
                for (j = 0; j < this.mConstraintSet.length; ++j) {
                    int lineDstX;
                    String id = Utils.stripID(this.mConstraintSet[j].getAttributeValue("id"));
                    if (!id.equals(derived)) continue;
                    fromRectX = this.getmConstraintSetX(i2 + 1);
                    toRectX = this.getmConstraintSetX(j + 1);
                    lineSrcX = fromRectX + csWidth / 2;
                    this.mDerivedLines[this.mTotalDerivedLines].mDstX = lineDstX = toRectX + csWidth / 2;
                    this.mDerivedLines[this.mTotalDerivedLines].mSrcX = lineSrcX;
                    this.mDerivedLines[this.mTotalDerivedLines].mPathYOffset = 10 * (this.mDerivedLines.length - this.mTotalDerivedLines);
                    ++this.mTotalDerivedLines;
                }
            }
            this.optimizeLines(this.mDerivedLines, this.mTotalDerivedLines);
            this.mComputedDerivedLines = true;
        } else {
            this.mTotalDerivedLines = 0;
            if (this.mDerivedLines.length < this.mConstraintSet.length) {
                this.mDerivedLines = new DerivedSetLine[this.mConstraintSet.length + 1];
                for (i2 = 0; i2 < this.mDerivedLines.length; ++i2) {
                    this.mDerivedLines[i2] = new DerivedSetLine();
                }
            }
            for (i2 = 0; i2 < this.mConstraintSet.length; ++i2) {
                String derived = Utils.stripID(this.mConstraintSet[i2].getAttributeValue("deriveConstraintsFrom"));
                if (derived == null) continue;
                for (j = 0; j < this.mConstraintSet.length; ++j) {
                    int lineDstX;
                    String id = Utils.stripID(this.mConstraintSet[j].getAttributeValue("id"));
                    if (!id.equals(derived)) continue;
                    fromRectX = this.getmConstraintSetX(i2 + 1);
                    toRectX = this.getmConstraintSetX(j + 1);
                    lineSrcX = fromRectX + csWidth / 2;
                    this.mDerivedLines[this.mTotalDerivedLines].mDstX = lineDstX = toRectX + csWidth / 2;
                    this.mDerivedLines[this.mTotalDerivedLines].mSrcX = lineSrcX;
                    this.mDerivedLines[this.mTotalDerivedLines].mConstraintSet = this.mConstraintSet[i2];
                    this.mDerivedLines[this.mTotalDerivedLines].mDerivedFrom = derived;
                    ++this.mTotalDerivedLines;
                }
            }
        }
        int GAP = 10;
        for (int i6 = 0; i6 < this.mTotalDerivedLines; ++i6) {
            g2g.setStroke(this.mDashStroke);
            g.setColor(Color.LIGHT_GRAY);
            this.mPath.reset();
            this.mRectPathX[0] = this.mDerivedLines[i6].mSrcX - 5;
            this.mRectPathY[0] = lineY;
            this.mRectPathX[1] = this.mRectPathX[0];
            this.mRectPathY[1] = lineY + this.mDerivedLines[i6].mPathYOffset;
            this.mRectPathX[2] = this.mDerivedLines[i6].mDstX + 5;
            this.mRectPathY[2] = this.mRectPathY[1];
            this.mRectPathX[3] = this.mRectPathX[2];
            this.mRectPathY[3] = lineY + 5;
            this.mPath.moveTo(this.mRectPathX[0], this.mRectPathY[0]);
            Drawing.drawRound(this.mPath, this.mRectPathX, this.mRectPathY, this.mRectPathLen, 20);
            Drawing.drawPick(this.picker, this.mDerivedLines[i6], this.mRectPathX, this.mRectPathY, this.mRectPathLen, 20);
            g2g.draw(this.mPath);
            this.mPath.reset();
            this.mPath.moveTo(this.mRectPathX[3], this.mRectPathY[3]);
            this.mPath.lineTo(this.mRectPathX[3] - 5, this.mRectPathY[3]);
            this.mPath.lineTo(this.mRectPathX[3], this.mRectPathY[3] - 5);
            this.mPath.lineTo(this.mRectPathX[3] + 5, this.mRectPathY[3]);
            this.mPath.lineTo(this.mRectPathX[3], this.mRectPathY[3]);
            g2g.setStroke(stroke);
            g2g.draw(this.mPath);
        }
    }

    private int drawActions(Graphics g, int swipes, int clicks, int x1, int x2, int y) {
        int dir;
        int onSize = 4;
        boolean backward = x2 < x1;
        int offset2 = MEUI.scale(6);
        int gap = MEUI.scale(2);
        int markx = x1 - MEUI.scale(2) - 1;
        int totalSpace = 0;
        int n = dir = backward ? -1 : 1;
        if (clicks > 0) {
            g.fillRoundRect(markx + (backward ? -offset2 - onSize : offset2), y - onSize - 2, onSize, onSize, onSize, onSize);
            totalSpace = dir * (onSize + gap);
            markx += totalSpace;
        }
        if (swipes > 0) {
            int longpill = onSize * 3;
            g.fillRoundRect(markx + (backward ? -offset2 - longpill : offset2), y - onSize - 2, longpill, onSize, onSize, onSize);
            totalSpace += dir * (longpill + gap);
        }
        return totalSpace;
    }

    private void drawTransition(Graphics2D g, boolean hoverHighlight, int x1, int x2, int y, int constraintSetY, Object tag, float progress, float stagger) {
        int tri_delta_y = 5;
        int tri_delta_x = 5;
        this.mPath.reset();
        this.mRectPathX[0] = x1 - 5;
        this.mRectPathY[0] = constraintSetY - 4;
        this.mRectPathX[1] = this.mRectPathX[0];
        this.mRectPathY[1] = y;
        this.mRectPathX[2] = x2 + 5;
        this.mRectPathY[2] = this.mRectPathY[1];
        this.mRectPathX[3] = this.mRectPathX[2];
        this.mRectPathY[3] = constraintSetY - 8;
        this.mPath.moveTo(this.mRectPathX[0], this.mRectPathY[0]);
        Drawing.drawRound(this.mPath, this.mRectPathX, this.mRectPathY, this.mRectPathLen, 5);
        Drawing.drawPick(this.picker, tag, this.mRectPathX, this.mRectPathY, this.mRectPathLen, 5);
        this.mPath.lineTo(this.mRectPathX[3] - tri_delta_x, this.mRectPathY[3]);
        this.mPath.lineTo(this.mRectPathX[3], this.mRectPathY[3] + tri_delta_y);
        this.mPath.lineTo(this.mRectPathX[3] + tri_delta_x, this.mRectPathY[3]);
        this.mPath.lineTo(this.mRectPathX[3], this.mRectPathY[3]);
        if (hoverHighlight) {
            Stroke originalStroke = g.getStroke();
            Color originalColor = g.getColor();
            g.setStroke(ourFatStroke);
            g.setColor(MEUI.Overview.ourCS_HoverBorder);
            g.draw(this.mPath);
            g.setColor(originalColor);
            g.setStroke(originalStroke);
        } else {
            g.draw(this.mPath);
        }
        this.mHighlightStart = false;
        this.mHighlightEnd = false;
        if (!Float.isNaN(progress)) {
            if (progress > 1.0f) {
                progress = 1.0f;
            }
            if (progress < 0.0f) {
                progress = 0.0f;
            }
            stagger = Math.abs(stagger);
            float scale = 1.0f / (1.0f - stagger);
            float startProgress = progress * scale;
            float endProgress = (progress - stagger) * scale;
            float startx = (float)this.mRectPathX[0] + startProgress * (float)(this.mRectPathX[3] - this.mRectPathX[0]) - 4.0f;
            float endx = (float)this.mRectPathX[0] + endProgress * (float)(this.mRectPathX[3] - this.mRectPathX[0]) + 4.0f;
            int clipy = this.mRectPathY[3] + ((double)progress < 0.3 ? 3 : 0);
            Rectangle rect = g.getClipBounds();
            g.clipRect(0, 0, this.getWidth(), clipy);
            Color originalColor = g.getColor();
            g.setPaint(new LinearGradientPaint(startx, 0.0f, endx, 0.0f, new float[]{0.0f, 0.01f, 0.99f, 1.0f}, new Color[]{originalColor, MEUI.Overview.ourPositionColor, MEUI.Overview.ourPositionColor, originalColor}));
            g.draw(this.mPath);
            g.setClip(rect);
            g.setColor(originalColor);
            if (Math.abs(startx + 4.0f - (float)this.mRectPathX[0]) < 2.0f) {
                this.mHighlightStart = true;
            }
            if (Math.abs(endx - 4.0f - (float)this.mRectPathX[3]) < 2.0f) {
                this.mHighlightEnd = true;
            }
        }
        Color originalColor = g.getColor();
        if (this.mHighlightStart) {
            g.setColor(MEUI.Overview.ourPositionColor);
        }
        g.drawLine(this.mRectPathX[0] - tri_delta_x, this.mRectPathY[0], this.mRectPathX[0] + tri_delta_x, this.mRectPathY[0]);
        if (this.mHighlightEnd) {
            g.setColor(MEUI.Overview.ourPositionColor);
        } else {
            g.setColor(originalColor);
        }
        this.mRectPathX[0] = this.mRectPathX[3] - tri_delta_x;
        this.mRectPathY[0] = this.mRectPathY[3];
        this.mRectPathX[1] = this.mRectPathX[3];
        this.mRectPathY[1] = this.mRectPathY[3] + tri_delta_y;
        this.mRectPathX[2] = this.mRectPathX[3] + tri_delta_x;
        this.mRectPathY[2] = this.mRectPathY[3];
        g.fillPolygon(this.mRectPathX, this.mRectPathY, 4);
        g.drawPolygon(this.mRectPathX, this.mRectPathY, 4);
        g.setColor(originalColor);
    }

    private void drawTransition_orig(Graphics2D g, boolean hoverHighlight, int x1, int x2, int y, int constraintSetY, Object tag) {
        int delta;
        this.picker.addLine(tag, 3, x1, y, x2, y, 2);
        int n = delta = x2 > x1 ? -5 : 5;
        if (hoverHighlight) {
            Stroke originalStroke = g.getStroke();
            Color originalColor = g.getColor();
            g.setStroke(ourFatStroke);
            g.setColor(MEUI.Overview.ourCS_HoverBorder);
            g.drawLine(x1, y, x2, y);
            g.drawLine(x1, y - delta, x1, y + delta);
            g.drawLine(x2, y, x2 + delta, y + delta);
            g.drawLine(x2, y, x2 + delta, y - delta);
            g.setColor(originalColor);
            g.setStroke(originalStroke);
        }
        g.drawLine(x1, y, x2, y);
        g.drawLine(x1, y - delta, x1, y + delta);
        g.drawLine(x2, y, x2 + delta, y + delta);
        g.drawLine(x2, y, x2 + delta, y - delta);
    }

    private void optimizeLines(DerivedSetLine[] lines2, int lineCount) {
        int maxLevels = 3;
        int total = this.intPower(maxLevels, lineCount);
        double minCost = Double.MAX_VALUE;
        int minPattern = -1;
        for (int i2 = 0; i2 < total; ++i2) {
            int level = i2;
            for (int j = 0; j < lineCount; ++j) {
                lines2[j].mPathYOffset = level % maxLevels;
                level /= maxLevels;
            }
            double cost = this.lineCost(lines2, lineCount, maxLevels);
            if (!(cost < minCost)) continue;
            minCost = cost;
            minPattern = i2;
        }
        int level = minPattern;
        for (int j = 0; j < lineCount; ++j) {
            int value2 = level % maxLevels;
            level /= maxLevels;
            lines2[j].mPathYOffset = value2 * 12 + 20;
        }
    }

    private double lineCost(DerivedSetLine[] lines2, int lineCount, int maxLevels) {
        int i2;
        double ret2 = 0.0;
        for (i2 = 0; i2 < lineCount; ++i2) {
            ret2 += (double)lines2[i2].mPathYOffset;
        }
        for (i2 = 0; i2 < lineCount; ++i2) {
            DerivedSetLine l1 = lines2[i2];
            for (int j = i2 + 1; j < lineCount; ++j) {
                boolean l1Inside;
                DerivedSetLine l2 = lines2[j];
                if (Math.max(Math.min(l1.mSrcX, l1.mDstX), Math.min(l2.mSrcX, l2.mDstX)) < Math.min(Math.max(l1.mSrcX, l1.mDstX), Math.max(l2.mSrcX, l2.mDstX)) && l1.mPathYOffset == l2.mPathYOffset) {
                    ret2 += 5.0;
                    continue;
                }
                boolean bl = l1Inside = (l1.mSrcX - l2.mSrcX) * (l1.mSrcX - l2.mDstX) <= 0 && (l1.mDstX - l2.mSrcX) * (l1.mDstX - l2.mDstX) <= 0;
                if (!l1Inside || l1.mPathYOffset <= l2.mPathYOffset) continue;
                ret2 += 5.0;
            }
        }
        return ret2;
    }

    int intPower(int a, int b) {
        int ret2 = a;
        for (int i2 = 1; i2 < b; ++i2) {
            ret2 *= a;
        }
        return ret2;
    }

    void setConstraintSetIndex(int index2) {
        this.mTransitionSelected = -1;
        this.mConstraintSetSelected = index2;
        this.repaint();
    }

    void setTransitionSetIndex(int index2) {
        this.mConstraintSetSelected = -1;
        this.mTransitionSelected = index2;
        this.repaint();
    }

    void setSelected(MTag tag) {
        int i2;
        this.mTransitionSelected = -1;
        this.mConstraintSetSelected = -1;
        for (i2 = 0; i2 < this.mConstraintSet.length; ++i2) {
            if (tag != this.mConstraintSet[i2]) continue;
            this.mConstraintSetSelected = i2;
            return;
        }
        for (i2 = 0; i2 < this.mTransitions.length; ++i2) {
            if (tag != this.mTransitions[i2]) continue;
            this.mTransitionSelected = i2;
            return;
        }
    }

    public void setMTag(MTag motionScene, MTag layout2) {
        this.mComputedDerivedLines = false;
        this.mMotionScene = motionScene;
        this.mLayout = layout2;
        this.mConstraintSet = motionScene.getChildTags("ConstraintSet");
        this.mTransitions = motionScene.getChildTags("Transition");
        this.mTransitionStart = new int[this.mTransitions.length];
        this.mTransitionEnd = new int[this.mTransitions.length];
        this.mOnActionSize = new int[this.mTransitions.length];
        this.mConstraintSetNames = new String[this.mConstraintSet.length];
        for (int j = 0; j < this.mConstraintSet.length; ++j) {
            this.mConstraintSetNames[j] = Utils.stripID(this.mConstraintSet[j].getAttributeValue("id"));
        }
        for (int i2 = 0; i2 < this.mTransitions.length; ++i2) {
            String start2 = Utils.stripID(this.mTransitions[i2].getAttributeValue("constraintSetStart"));
            String end = Utils.stripID(this.mTransitions[i2].getAttributeValue("constraintSetEnd"));
            for (int j = 0; j < this.mConstraintSetNames.length; ++j) {
                if (start2.equals(this.mConstraintSetNames[j])) {
                    this.mTransitionStart[i2] = j;
                }
                if (!end.equals(this.mConstraintSetNames[j])) continue;
                this.mTransitionEnd[i2] = j;
            }
        }
        this.calcDimensions();
        this.revalidate();
        this.repaint();
    }

    static class DerivedSetLine {
        public MTag mConstraintSet;
        public String mDerivedFrom;
        int mSrcX;
        int mDstX;
        int mPathYOffset = 10;

        DerivedSetLine() {
        }
    }
}

