/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionUtils {
    private static final HashMap<String, Pair<String, String>> ourFilteredAttributes = new HashMap();

    public static boolean isInBaseState(MotionLayoutComponentHelper motionLayout) {
        String state = motionLayout.getState();
        return state == null || state.equals("motion_base");
    }

    public static void fillComponentModification(ComponentModification modification) {
        NlComponent component = modification.getComponent();
        NlComponent motionLayoutComponent = MotionUtils.getMotionLayoutAncestor(component);
        if (motionLayoutComponent == null) {
            modification.directCommit();
            return;
        }
        MotionLayoutComponentHelper motionLayout = MotionLayoutComponentHelper.create(motionLayoutComponent);
        if (motionLayout.isInTransition()) {
            return;
        }
        if (MotionUtils.isInBaseState(motionLayout)) {
            component.startAttributeTransaction();
            for (Pair<String, String> attribute : ConstraintComponentUtilities.ourLayoutAttributes) {
                String attributeName;
                String namespace = (String)attribute.getFirst();
                String definedAttribute = component.getLiveAttribute(namespace, attributeName = (String)attribute.getSecond());
                if (definedAttribute == null) continue;
                modification.setAttribute(namespace, attributeName, definedAttribute);
            }
            return;
        }
        Object properties2 = component.getClientProperty("motionLayoutProperties");
        if (properties2 == null || !(properties2 instanceof MotionAttributes)) {
            return;
        }
        modification.getAttributes().clear();
        MotionAttributes attrs = (MotionAttributes)properties2;
        HashMap<String, MotionAttributes.DefinedAttribute> definedAttributes = attrs.getAttrMap();
        for (Pair<String, String> attribute : ConstraintComponentUtilities.ourLayoutAttributes) {
            String namespace = (String)attribute.getFirst();
            String attributeName = (String)attribute.getSecond();
            MotionAttributes.DefinedAttribute definedAttribute = definedAttributes.get(attributeName);
            if (definedAttribute == null) continue;
            namespace = MotionUtils.getFilteredNamespace(namespace, attributeName, false);
            modification.setAttribute(namespace, attributeName, definedAttribute.getValue());
        }
    }

    public static void commit(ComponentModification modification) {
        NlComponent component = modification.getComponent();
        NlComponent motionLayoutComponent = MotionUtils.getMotionLayoutAncestor(component);
        if (motionLayoutComponent == null) {
            modification.commit();
            return;
        }
        MotionLayoutComponentHelper motionLayout = MotionLayoutComponentHelper.create(motionLayoutComponent);
        if (motionLayout.isInTransition()) {
            return;
        }
        ConstraintComponentUtilities.cleanup(modification, component);
        if (MotionUtils.isInBaseState(motionLayout)) {
            AttributesTransaction transaction = MotionUtils.fillTransaction(modification);
            NlWriteCommandActionUtil.run(component, modification.getLabel(), transaction::commit);
            return;
        }
        MotionSceneTag motionScene = MotionUtils.getMotionScene(motionLayoutComponent);
        if (motionScene == null) {
            modification.directCommit();
            return;
        }
        boolean found = false;
        String state = motionLayout.getState();
        boolean addToConstraintSetIfMissing = true;
        MTag[] cSet = motionScene.getChildTags("ConstraintSet");
        for (int i2 = 0; i2 < cSet.length; ++i2) {
            MTag set = cSet[i2];
            String id = set.getAttributeValue("id");
            if (!(id = Utils.stripID(id)).equalsIgnoreCase(state)) continue;
            MTag[] constraints = set.getChildTags("Constraint");
            for (int j = 0; j < constraints.length; ++j) {
                MTag constraint = constraints[j];
                String constraintId = constraint.getAttributeValue("id");
                if (!(constraintId = Utils.stripID(constraintId)).equalsIgnoreCase(Utils.stripID(component.getId()))) continue;
                MTag.TagWriter writer = constraint.getTagWriter();
                MotionUtils.applyComponentModification(modification, writer);
                writer.commit(modification.getLabel());
                found = true;
            }
            if (found) break;
            MTag.TagWriter constraint = set.getChildTagWriter("Constraint");
            String constraintId = "@+id/" + component.ensureId();
            MotionUtils.applyComponentModification(modification, constraint);
            constraint.setAttribute("http://schemas.android.com/apk/res-auto", "id", constraintId);
            constraint.commit(modification.getLabel());
            found = true;
            break;
        }
        if (!found) {
            // empty if block
        }
        NlModel nlModel = component.getModel();
        nlModel.notifyModified(NlModel.ChangeType.EDIT);
    }

    public static void apply(ComponentModification modification) {
        NlComponent component = modification.getComponent();
        NlComponent motionLayoutComponent = MotionUtils.getMotionLayoutAncestor(component);
        if (motionLayoutComponent == null) {
            modification.directApply();
            return;
        }
        MotionLayoutComponentHelper motionLayout = MotionLayoutComponentHelper.create(motionLayoutComponent);
        if (motionLayout.isInTransition()) {
            return;
        }
        if (MotionUtils.isInBaseState(motionLayout)) {
            AttributesTransaction transaction = MotionUtils.fillTransaction(modification);
            transaction.apply();
            motionLayout.updateLiveAttributes(component, modification, motionLayout.getState());
            return;
        }
        motionLayout.updateLiveAttributes(component, modification, motionLayout.getState());
    }

    private static AttributesTransaction fillTransaction(ComponentModification modification) {
        NlComponent component = modification.getComponent();
        AttributesTransaction transaction = component.startAttributeTransaction();
        for (Pair<String, String> key : modification.getAttributes().keySet()) {
            String value2 = modification.getAttributes().get(key);
            String namespace = (String)key.getFirst();
            String attribute = (String)key.getSecond();
            namespace = MotionUtils.getFilteredNamespace(namespace, attribute, true);
            transaction.setAttribute(namespace, attribute, value2);
        }
        return transaction;
    }

    private static String getFilteredNamespace(String namespace, String attribute, boolean isInBaseState) {
        Pair<String, String> namespaces = ourFilteredAttributes.get(attribute);
        if (namespaces == null) {
            return namespace;
        }
        return isInBaseState ? (String)namespaces.getFirst() : (String)namespaces.getSecond();
    }

    static void applyComponentModification(ComponentModification modification, MTag.TagWriter writer) {
        HashMap<Pair<String, String>, String> attributes = modification.getAttributes();
        for (Pair<String, String> key : attributes.keySet()) {
            String value2 = attributes.get(key);
            writer.setAttribute((String)key.getFirst(), (String)key.getSecond(), value2);
        }
    }

    @Nullable
    public static NlComponent getMotionLayoutAncestor(@NotNull NlComponent component) {
        NlComponent motionLayout = component;
        while (!NlComponentHelperKt.isOrHasSuperclass(motionLayout, SdkConstants.MOTION_LAYOUT)) {
            ViewHandler handler2 = NlComponentHelperKt.getViewHandler(motionLayout);
            if (handler2 instanceof MotionLayoutHandler) {
                return motionLayout;
            }
            if ((motionLayout = motionLayout.getParent()) != null) continue;
            return null;
        }
        return motionLayout;
    }

    public static MotionSceneTag getMotionScene(NlComponent component) {
        NlComponent motionLayout = MotionUtils.getMotionLayoutAncestor(component);
        if (motionLayout == null) {
            return null;
        }
        String ref = motionLayout.getAttribute("http://schemas.android.com/apk/res-auto", "layoutDescription");
        ResourceUrl url = ref != null ? ResourceUrl.parse((String)ref) : null;
        String fileName = null;
        if (url != null) {
            fileName = url.name;
        }
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        Project project = motionLayout.getModel().getProject();
        AndroidFacet facet2 = motionLayout.getModel().getFacet();
        List<VirtualFile> resourcesXML = IdeResourcesUtil.getResourceSubdirs(ResourceFolderType.XML, ResourceRepositoryManager.getModuleResources(facet2).getResourceDirs());
        if (resourcesXML.isEmpty()) {
            return null;
        }
        VirtualFile directory = resourcesXML.get(0);
        VirtualFile virtualFile = directory.findFileByRelativePath(fileName + ".xml");
        XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)virtualFile);
        MotionSceneTag.Root motionSceneModel = MotionSceneTag.parse(motionLayout, project, virtualFile, xmlFile);
        return motionSceneModel;
    }

    public static boolean isAnchorConnected(AnchorTarget.Type type, NlAttributesHolder component, boolean useRtlAttributes, boolean isRtl) {
        if (type == AnchorTarget.Type.BASELINE) {
            return component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
        }
        boolean isConnected = false;
        Pair<String, String> pair = ConstraintComponentUtilities.ourPotentialAttributes.get((Object)type);
        if (pair != null) {
            isConnected |= component.getAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
            isConnected |= component.getAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
        }
        if (useRtlAttributes) {
            if (isRtl) {
                pair = ConstraintComponentUtilities.ourPotentialRTLAttributes.get((Object)type);
                if (pair != null) {
                    isConnected |= component.getAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
                    isConnected |= component.getAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
                }
            } else {
                pair = ConstraintComponentUtilities.ourPotentialLTRAttributes.get((Object)type);
                if (pair != null) {
                    isConnected |= component.getAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
                    isConnected |= component.getAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
                }
            }
        }
        return isConnected;
    }

    public static int getTreeSelectionModel(NlModel model2) {
        ImmutableList<NlComponent> list = model2.getComponents();
        if (!list.isEmpty() && MotionUtils.getMotionLayoutAncestor((NlComponent)list.get(0)) != null) {
            return 1;
        }
        return 4;
    }

    static {
        ourFilteredAttributes.put("id", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_width", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_height", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_marginStart", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_marginEnd", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_marginLeft", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_marginRight", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_marginTop", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_marginBottom", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_editor_absoluteX", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/tools", (Object)"http://schemas.android.com/apk/res-auto"));
        ourFilteredAttributes.put("layout_editor_absoluteY", (Pair<String, String>)Pair.of((Object)"http://schemas.android.com/tools", (Object)"http://schemas.android.com/apk/res-auto"));
    }
}

