/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearSeparatorTarget;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearDragTarget
extends DragBaseTarget {
    private final LinearLayoutHandler myHandler;
    private final boolean myIsDragFromPalette;
    private LinearSeparatorTarget myClosest;

    public LinearDragTarget(@NotNull LinearLayoutHandler handler2) {
        this(handler2, false);
    }

    public LinearDragTarget(@NotNull LinearLayoutHandler handler2, boolean fromPalette) {
        this.myHandler = handler2;
        this.myIsDragFromPalette = fromPalette;
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
    }

    @Override
    public void mouseDown(int x, int y) {
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        this.myHandler.setDragging(this.myComponent, true);
        ((LayoutlibSceneManager)parent.getScene().getSceneManager()).updateTargets();
        super.mouseDown(x, y);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext ignored) {
        Target closestTarget;
        SceneComponent sceneParent = this.myComponent.getParent();
        assert (sceneParent != null);
        this.myComponent.setDragging(true);
        TargetSnapper snapper = this.getTargetNotchSnapper();
        x -= this.myOffsetX;
        y -= this.myOffsetY;
        if (this.myHandler.isVertical(sceneParent.getNlComponent())) {
            int middle = this.myComponent.getDrawHeight() / 2;
            int parentHeight = sceneParent.getDrawHeight();
            int nx = this.myIsDragFromPalette ? x : this.myComponent.getDrawX();
            int ny = Math.min(Math.max(y, -middle), parentHeight + middle);
            ny = snapper.trySnapVertical(ny).orElse(ny);
            this.myComponent.setPosition(nx, ny);
            closestTarget = snapper.getSnappedVerticalTarget();
        } else {
            int middle = this.myComponent.getDrawWidth() / 2;
            int parentWidth = sceneParent.getDrawWidth();
            int nx = Math.min(Math.max(x, -middle), parentWidth + middle);
            nx = snapper.trySnapHorizontal(nx).orElse(nx);
            int ny = this.myIsDragFromPalette ? y : this.myComponent.getDrawY();
            this.myComponent.setPosition(nx, ny);
            closestTarget = snapper.getSnappedHorizontalTarget();
        }
        if (this.myClosest != closestTarget) {
            if (this.myClosest != null) {
                this.myClosest.setHighlight(false);
            }
            if (closestTarget instanceof LinearSeparatorTarget) {
                this.myClosest = (LinearSeparatorTarget)closestTarget;
                this.myClosest.setHighlight(true, this.myComponent.getDrawWidth(), this.myComponent.getDrawHeight());
            } else {
                this.myClosest = null;
            }
        }
        this.myComponent.getScene().repaint();
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTarget) {
        super.mouseRelease(x, y, closestTarget);
        this.myHandler.setDragging(this.myComponent, false);
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        parent.updateTargets();
        if (this.myClosest != null) {
            this.myClosest.setHighlight(false);
            if (!LinearLayoutHandler.insertComponentAtTarget(this.myComponent, this.myClosest)) {
                this.myComponent.getScene().markNeedsLayout(2);
            }
        } else {
            this.myComponent.getScene().markNeedsLayout(2);
        }
    }

    @Override
    public void mouseCancel() {
        this.myHandler.setDragging(this.myComponent, false);
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null) {
            parent.updateTargets();
        }
        if (this.myClosest != null) {
            this.myClosest.setHighlight(false);
        }
        super.mouseCancel();
    }

    @Nullable
    public LinearSeparatorTarget getClosest() {
        return this.myClosest;
    }
}

