/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.grid.ChildInfo;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Dimension;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

final class GridInfo {
    private static final int NEW_CELL_SIZE = 32;
    private int[] verticalLineLocations;
    private int[] horizontalLineLocations;
    private NlComponent[][] children;
    private final int rowCount;
    private final int columnCount;
    private final NlComponent layout;
    private final Dimension size;

    GridInfo(NlComponent layout2) {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(layout2);
        if (viewInfo == null) {
            throw new IllegalArgumentException();
        }
        this.layout = layout2;
        this.size = this.getSize();
        try {
            this.initVerticalLineLocations();
            this.initHorizontalLineLocations();
            Object viewObject = viewInfo.getViewObject();
            Class<?> c = viewObject.getClass();
            this.rowCount = (Integer)c.getDeclaredMethod("getRowCount", new Class[0]).invoke(viewObject, new Object[0]);
            this.columnCount = (Integer)c.getDeclaredMethod("getColumnCount", new Class[0]).invoke(viewObject, new Object[0]);
            this.initChildren();
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private Dimension getSize() {
        Dimension size = new Dimension();
        List<NlComponent> children = this.layout.getChildren();
        if (!children.isEmpty()) {
            Insets padding = NlComponentHelperKt.getPadding(this.layout);
            for (NlComponent child : children) {
                size.width = Math.max(NlComponentHelperKt.getX(child) - NlComponentHelperKt.getX(this.layout) - padding.left + NlComponentHelperKt.getW(child), size.width);
                size.height = Math.max(NlComponentHelperKt.getY(child) - NlComponentHelperKt.getY(this.layout) - padding.top + NlComponentHelperKt.getH(child), size.height);
            }
        }
        return size;
    }

    private void initVerticalLineLocations() throws NoSuchFieldException, IllegalAccessException {
        Insets padding = NlComponentHelperKt.getPadding(this.layout);
        int[] horizontalAxisLocations = this.getAxisLocations("mHorizontalAxis", "horizontalAxis");
        this.verticalLineLocations = GridInfo.initLineLocations(NlComponentHelperKt.getW(this.layout) - padding.width(), this.size.width, horizontalAxisLocations);
        GridInfo.translate(this.verticalLineLocations, NlComponentHelperKt.getX(this.layout) + padding.left);
    }

    private void initHorizontalLineLocations() throws NoSuchFieldException, IllegalAccessException {
        Insets padding = NlComponentHelperKt.getPadding(this.layout);
        int[] verticalAxisLocations = this.getAxisLocations("mVerticalAxis", "verticalAxis");
        this.horizontalLineLocations = GridInfo.initLineLocations(NlComponentHelperKt.getH(this.layout) - padding.height(), this.size.height, verticalAxisLocations);
        GridInfo.translate(this.horizontalLineLocations, NlComponentHelperKt.getY(this.layout) + padding.top);
    }

    private int[] getAxisLocations(String name1, String name2) throws NoSuchFieldException, IllegalAccessException {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(this.layout);
        assert (viewInfo != null);
        Object viewObject = viewInfo.getViewObject();
        Field axisField = GridInfo.getDeclaredField(viewObject.getClass(), name1, name2);
        axisField.setAccessible(true);
        Object axis = axisField.get(viewObject);
        Field locationsField = axis.getClass().getDeclaredField("locations");
        locationsField.setAccessible(true);
        return (int[])locationsField.get(axis);
    }

    private static Field getDeclaredField(Class<?> c, String name1, String name2) throws NoSuchFieldException {
        try {
            return c.getDeclaredField(name1);
        }
        catch (NoSuchFieldException exception) {
            return c.getDeclaredField(name2);
        }
    }

    static int[] initLineLocations(int layoutSize, int gridInfoSize, int[] axisLocations) {
        int startIndex;
        int difference = layoutSize - gridInfoSize;
        int lineLocationsLength = difference > 0 ? axisLocations.length + difference / 32 : axisLocations.length;
        int[] lineLocations = Arrays.copyOf(axisLocations, lineLocationsLength);
        if (axisLocations.length == 0) {
            startIndex = 1;
        } else {
            lineLocations[axisLocations.length - 1] = gridInfoSize;
            startIndex = axisLocations.length;
        }
        for (int i2 = startIndex; i2 < lineLocationsLength; ++i2) {
            lineLocations[i2] = lineLocations[i2 - 1] + 32;
        }
        if (lineLocations[lineLocations.length - 1] != layoutSize) {
            lineLocations = Arrays.copyOf(lineLocations, lineLocations.length + 1);
        }
        lineLocations[lineLocations.length - 1] = layoutSize - 1;
        return lineLocations;
    }

    private static void translate(int[] locations, int distance) {
        int i2 = 0;
        while (i2 < locations.length) {
            int n = i2++;
            locations[n] = locations[n] + distance;
        }
    }

    private void initChildren() throws NoSuchFieldException, IllegalAccessException {
        this.children = new NlComponent[this.rowCount][this.columnCount];
        List<NlComponent> children = this.layout.getChildren();
        for (NlComponent child : children) {
            ChildInfo info2 = GridInfo.getInfo(child);
            int endRow = Math.min(info2.getRow2(), this.rowCount);
            int endColumn = Math.min(info2.getColumn2(), this.columnCount);
            for (int row = info2.getRow1(); row < endRow; ++row) {
                for (int column = info2.getColumn1(); column < endColumn; ++column) {
                    this.children[row][column] = child;
                }
            }
        }
    }

    private static ChildInfo getInfo(NlComponent child) throws NoSuchFieldException, IllegalAccessException {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(child);
        assert (viewInfo != null);
        Object params = viewInfo.getLayoutParamsObject();
        Class<?> paramsClass = params.getClass();
        Object rowSpec = paramsClass.getDeclaredField("rowSpec").get(params);
        Object columnSpec = paramsClass.getDeclaredField("columnSpec").get(params);
        Field span = rowSpec.getClass().getDeclaredField("span");
        span.setAccessible(true);
        return new ChildInfo(span.get(rowSpec), span.get(columnSpec));
    }

    int getRow(int y) {
        return GridInfo.getIndex(this.horizontalLineLocations, y, false);
    }

    int getRowSkippingEqualLineLocations(int y) {
        return GridInfo.getIndex(this.horizontalLineLocations, y, true);
    }

    int getColumn(int x) {
        return GridInfo.getIndex(this.verticalLineLocations, x, false);
    }

    int getColumnSkippingEqualLineLocations(int x) {
        return GridInfo.getIndex(this.verticalLineLocations, x, true);
    }

    static int getIndex(int[] lineLocations, int location, boolean skipEqualLineLocations) {
        if (lineLocations.length < 2) {
            throw new IllegalArgumentException(Arrays.toString(lineLocations));
        }
        if (location < lineLocations[0] || location > lineLocations[lineLocations.length - 1]) {
            return -1;
        }
        int j = 0;
        for (int i2 = 0; i2 < lineLocations.length - 1; ++i2) {
            if (skipEqualLineLocations && lineLocations[i2] == lineLocations[i2 + 1]) continue;
            if (lineLocations[i2] <= location && location < lineLocations[i2 + 1]) {
                return j;
            }
            ++j;
        }
        throw new AssertionError();
    }

    int[] getVerticalLineLocations() {
        return this.verticalLineLocations;
    }

    int[] getHorizontalLineLocations() {
        return this.horizontalLineLocations;
    }

    boolean cellHasChild(int row, int column) {
        return 0 <= row && row < this.rowCount && 0 <= column && column < this.columnCount && this.children[row][column] != null;
    }

    NlComponent[][] getChildren() {
        return this.children;
    }

    int getRowCount() {
        return this.rowCount;
    }

    int getColumnCount() {
        return this.columnCount;
    }
}

