/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.TextViewHandler;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditTextHandler
extends TextViewHandler {
    private static final Icon DEFAULT_ICON = StudioIcons.LayoutEditor.Palette.EDIT_TEXT;

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"inputType", (Object)"hint", (Object)"style", (Object)"singleLine", (Object)"selectAllOnFocus");
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        if (!component.getTagName().equals("EditText")) {
            return super.getTitleAttributes(component);
        }
        String title = super.getTitleAttributes(component);
        if (StringUtil.isEmpty((String)title)) {
            EditTextInputType inputType = EditTextInputType.getInputType(component);
            title = inputType != null ? String.format("(%s)", inputType.title) : "";
        }
        return title;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        if (!component.getTagName().equals("EditText")) {
            return super.getIcon(component);
        }
        EditTextInputType inputType = EditTextInputType.getInputType(component);
        return inputType != null ? inputType.icon : DEFAULT_ICON;
    }

    @Override
    @NotNull
    public String generateBaseId(@NotNull NlComponent component) {
        String inputType = component.getAndroidAttribute("inputType");
        return "EditText" + (inputType == null ? "" : StringUtil.capitalize((String)inputType));
    }

    private static enum EditTextInputType {
        PLAIN_TEXT("textPersonName", "Plain Text", StudioIcons.LayoutEditor.Palette.TEXTFIELD),
        PASSWORD("textPassword", "Password", StudioIcons.LayoutEditor.Palette.PASSWORD_TEXTFIELD),
        PASSWORD_NUMERIC("numberPassword", "Password (Numeric)", StudioIcons.LayoutEditor.Palette.PASSWORD_NUMERIC_TEXTFIELD),
        EMAIL("textEmailAddress", "E-mail", StudioIcons.LayoutEditor.Palette.EMAIL_TEXTFIELD),
        PHONE("phone", "Phone", StudioIcons.LayoutEditor.Palette.PHONE_TEXTFIELD),
        POSTAL_ADDRESS("textPostalAddress", "Postal Address", StudioIcons.LayoutEditor.Palette.POSTAL_ADDRESS_TEXTFIELD),
        MULTILINE_TEXT("textMultiLine", "Multiline Text", StudioIcons.LayoutEditor.Palette.TEXTFIELD_MULTILINE),
        TIME("time", "Time", StudioIcons.LayoutEditor.Palette.TIME_TEXTFIELD),
        DATE("date", "Date", StudioIcons.LayoutEditor.Palette.DATE_TEXTFIELD),
        NUMBER("number", "Number", StudioIcons.LayoutEditor.Palette.NUMBER_TEXTFIELD),
        NUMBER_SIGNED("numberSigned", "Number (Signed)", StudioIcons.LayoutEditor.Palette.NUMBER_SIGNED_TEXTFIELD),
        NUMBER_DECIMAL("numberDecimal", "Number (Decimal)", StudioIcons.LayoutEditor.Palette.NUMBER_DECIMAL_TEXTFIELD);

        @NotNull
        String typeString;
        @NotNull
        String title;
        @NotNull
        Icon icon;

        private EditTextInputType(@NotNull String typeString, String title, Icon icon2) {
            this.typeString = typeString;
            this.title = title;
            this.icon = icon2;
        }

        @Nullable
        private static EditTextInputType getInputType(@NotNull NlComponent component) {
            String inputTypeString = component.getAttribute("http://schemas.android.com/apk/res/android", "inputType");
            return Arrays.stream(EditTextInputType.values()).filter(inputType -> inputType.typeString.equals(inputTypeString)).findAny().orElse(null);
        }
    }
}

