/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.SdkConstants;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.AttributeBrowser;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.EnumSet;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BaseFragmentHandler
extends ViewHandler {
    BaseFragmentHandler() {
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"name", (Object)"layout", (Object)"class", (Object)"navGraph");
    }

    @Override
    @Nullable
    public AttributeBrowser getBrowser(@NotNull String attributeName) {
        if (attributeName.equals("name")) {
            return BaseFragmentHandler::browseClasses;
        }
        if (attributeName.equals("navGraph")) {
            return BaseFragmentHandler::browseNavs;
        }
        return null;
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        String name = component.getAttribute("http://schemas.android.com/apk/res/android", "name");
        return StringUtil.isEmpty((String)name) ? "" : name;
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        return super.getXml(tagName, xmlType);
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor2, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType != InsertType.CREATE) {
            return true;
        }
        String className2 = newChild.getAttribute("http://schemas.android.com/apk/res/android", "name");
        if (className2 != null) {
            if (!"androidx.navigation.fragment.NavHostFragment".equals(className2)) {
                return true;
            }
            String src = BaseFragmentHandler.browseNavs(editor2, null);
            if (src == null) {
                return false;
            }
            return (Boolean)NlWriteCommandActionUtil.compute(newChild, "Create Fragment", () -> {
                newChild.setAttribute("http://schemas.android.com/apk/res-auto", "navGraph", src);
                newChild.setAttribute("http://schemas.android.com/apk/res-auto", "defaultNavHost", "true");
                return true;
            });
        }
        String src = BaseFragmentHandler.browseClasses(editor2, null);
        if (src == null) {
            return false;
        }
        return (Boolean)NlWriteCommandActionUtil.compute(newChild, "Create Fragment", () -> {
            newChild.setAttribute("http://schemas.android.com/apk/res/android", "name", src);
            return true;
        });
    }

    @Nullable
    static String browseClasses(@NotNull ViewEditor editor2, @Nullable String existingValue) {
        return editor2.displayClassInput("Fragments", Sets.newHashSet((Object[])new String[]{"android.app.Fragment", SdkConstants.CLASS_V4_FRAGMENT.oldName(), SdkConstants.CLASS_V4_FRAGMENT.newName()}), null, existingValue);
    }

    @Nullable
    static String browseNavs(@NotNull ViewEditor editor2, @Nullable String existingValue) {
        return editor2.displayResourceInput("Navigation Graphs", EnumSet.of(ResourceType.NAVIGATION));
    }

    @Override
    public void onActivateInDesignSurface(@NotNull NlComponent component, ViewEditor editor2, int x, int y) {
        String graph = component.getAttribute("http://schemas.android.com/apk/res-auto", "navGraph");
        if (graph != null) {
            editor2.openResourceFile(graph);
        }
    }
}

