/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.common.editor.DesignerEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LayoutNavigationManager
implements Disposable {
    private static final Map<VirtualFile, VirtualFile> ourNavigationCache = ContainerUtil.createWeakMap();
    private final Project myProject;

    public VirtualFile get(VirtualFile file2) {
        return ourNavigationCache.get(file2);
    }

    private LayoutNavigationManager(@NotNull Project project) {
        this.myProject = project;
    }

    public static LayoutNavigationManager getInstance(@NotNull Project project) {
        return (LayoutNavigationManager)project.getService(LayoutNavigationManager.class);
    }

    public boolean pushFile(@NotNull VirtualFile source, @NotNull VirtualFile destination) {
        boolean isInDesignerMode;
        ourNavigationCache.put(destination, source);
        FileEditorManager manager = FileEditorManager.getInstance((Project)this.myProject);
        FileEditor sourceEditor = manager.getSelectedEditor(source);
        FileEditor destinationEditor = manager.getSelectedEditor(destination);
        if (destinationEditor == null) {
            FileEditor[] editors = manager.openFile(destination, true);
            if (editors.length == 0) {
                return false;
            }
        } else {
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.myProject, destination);
            List editors = manager.openEditor(openFileDescriptor, true);
            if (!editors.contains(destinationEditor)) {
                Logger.getInstance(LayoutNavigationManager.class).error("The editor was supposed to be already open");
                return false;
            }
        }
        manager.setSelectedEditor(destination, (isInDesignerMode = sourceEditor instanceof DesignerEditor) ? ((DesignerEditor)sourceEditor).getEditorId() : TextEditorProvider.getInstance().getEditorTypeId());
        return true;
    }

    public void popFile(@NotNull VirtualFile fileToPop, @NotNull VirtualFile parentFile) {
        FileEditorManager manager = FileEditorManager.getInstance((Project)this.myProject);
        OpenFileDescriptor previousOpenFileDescriptor = new OpenFileDescriptor(this.myProject, parentFile);
        manager.openEditor(previousOpenFileDescriptor, true);
        ourNavigationCache.remove(fileToPop);
    }

    public void dispose() {
        ourNavigationCache.clear();
    }
}

