/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ChainChecker;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001,B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J \u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018H\u0002J \u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018H\u0007J6\u0010\"\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0%2\u0006\u0010&\u001a\u00020'H\u0016J>\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0%2\u0006\u0010+\u001a\u00020'H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction;", "Lcom/android/tools/idea/uibuilder/api/actions/DirectViewAction;", "icon", "Ljavax/swing/Icon;", "style", "", "chainDirection", "Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction$ChainDirection;", "label", "(Ljavax/swing/Icon;Ljava/lang/String;Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction$ChainDirection;Ljava/lang/String;)V", "getChainDirection", "()Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction$ChainDirection;", "getStyle", "()Ljava/lang/String;", "chooseChainStyle", "", "chainHeadComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "orientationStyle", "component", "chainStyle", "getHorizontalHead", "primary", "nonPrimaryComponents", "", "getNonPrimaryComponent", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "primaryNlComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "selectedChildren", "getVerticalHead", "isApplicable", "", "perform", "handler", "Lcom/android/tools/idea/uibuilder/api/ViewHandler;", "", "modifiers", "", "updatePresentation", "presentation", "Lcom/android/tools/idea/uibuilder/api/actions/ViewActionPresentation;", "modifiersEx", "ChainDirection", "intellij.android.designer"})
public final class ChainStyleViewAction
extends DirectViewAction {
    @NotNull
    private final String style;
    @NotNull
    private final ChainDirection chainDirection;

    @Override
    public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiers) {
        if (selectedChildren.isEmpty()) {
            return;
        }
        NlComponent primaryNlComponent = selectedChildren.get(0);
        SceneComponent sceneComponent = editor2.getScene().getSceneComponent(primaryNlComponent);
        if (sceneComponent == null) {
            return;
        }
        SceneComponent primary = sceneComponent;
        List<SceneComponent> nonPrimaryComponents = this.getNonPrimaryComponent(editor2, primaryNlComponent, selectedChildren);
        if (this.chainDirection == ChainDirection.HORIZONTAL) {
            SceneComponent sceneComponent2 = this.getHorizontalHead(primary, nonPrimaryComponents);
            if (sceneComponent2 == null) {
                return;
            }
            SceneComponent horizontalHead = sceneComponent2;
            this.chooseChainStyle(horizontalHead, "layout_constraintHorizontal_chainStyle", primary, this.style);
        } else if (this.chainDirection == ChainDirection.VERTICAL) {
            SceneComponent sceneComponent3 = this.getVerticalHead(primary, nonPrimaryComponents);
            if (sceneComponent3 == null) {
                return;
            }
            SceneComponent verticalHead = sceneComponent3;
            this.chooseChainStyle(verticalHead, "layout_constraintVertical_chainStyle", primary, this.style);
        }
    }

    private final void chooseChainStyle(SceneComponent chainHeadComponent, String orientationStyle, SceneComponent component, String chainStyle) {
        NlComponent chainHead = chainHeadComponent.getAuthoritativeNlComponent();
        ComponentModification modification = new ComponentModification(chainHead, "Cycle Chain Style");
        modification.setAttribute("http://schemas.android.com/apk/res-auto", orientationStyle, chainStyle);
        modification.commit();
        component.getScene().needsRebuildList();
    }

    private final SceneComponent getHorizontalHead(SceneComponent primary, List<? extends SceneComponent> nonPrimaryComponents) {
        ChainChecker checker2 = new ChainChecker();
        if (!checker2.checkIsInChain(primary) || !checker2.isInHorizontalChain()) {
            return null;
        }
        SceneComponent head2 = checker2.getHorizontalChainHead();
        Iterable $this$forEach$iv = nonPrimaryComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneComponent it = (SceneComponent)element$iv;
            boolean bl = false;
            ChainChecker componentChecker = new ChainChecker();
            componentChecker.checkIsInChain(it);
            if (componentChecker.isInHorizontalChain() && componentChecker.getHorizontalChainHead() == head2) continue;
            return null;
        }
        return head2;
    }

    private final SceneComponent getVerticalHead(SceneComponent primary, List<? extends SceneComponent> nonPrimaryComponents) {
        ChainChecker checker2 = new ChainChecker();
        if (!checker2.checkIsInChain(primary) || !checker2.isInVerticalChain()) {
            return null;
        }
        SceneComponent head2 = checker2.getVerticalChainHead();
        Iterable $this$forEach$iv = nonPrimaryComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneComponent it = (SceneComponent)element$iv;
            boolean bl = false;
            ChainChecker componentChecker = new ChainChecker();
            componentChecker.checkIsInChain(it);
            if (componentChecker.isInVerticalChain() && componentChecker.getVerticalChainHead() == head2) continue;
            return null;
        }
        return head2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SceneComponent> getNonPrimaryComponent(ViewEditor editor2, NlComponent primaryNlComponent, List<? extends NlComponent> selectedChildren) {
        void $this$mapTo$iv$iv;
        NlComponent it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = selectedChildren;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NlComponent)element$iv$iv;
            boolean bl = false;
            if (!(it != primaryNlComponent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (NlComponent)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            SceneComponent sceneComponent = editor2.getScene().getSceneComponent(it);
            collection2.add(sceneComponent);
        }
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.toList((Iterable)((List)destination$iv$iv)));
    }

    @Override
    public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiersEx) {
        super.updatePresentation(presentation, editor2, handler2, component, selectedChildren, modifiersEx);
        presentation.setVisible(this.isApplicable(editor2, selectedChildren));
    }

    @VisibleForTesting
    public final boolean isApplicable(@NotNull ViewEditor editor2, @NotNull List<? extends NlComponent> selectedChildren) {
        if (selectedChildren.isEmpty()) {
            return false;
        }
        NlComponent primaryNlComponent = selectedChildren.get(0);
        SceneComponent sceneComponent = editor2.getScene().getSceneComponent(primaryNlComponent);
        if (sceneComponent == null) {
            return false;
        }
        SceneComponent primary = sceneComponent;
        List<SceneComponent> nonPrimaryComponents = this.getNonPrimaryComponent(editor2, primaryNlComponent, selectedChildren);
        if (this.chainDirection == ChainDirection.HORIZONTAL) {
            return this.getHorizontalHead(primary, nonPrimaryComponents) != null;
            {
            }
        }
        if (this.chainDirection == ChainDirection.VERTICAL) {
            return this.getVerticalHead(primary, nonPrimaryComponents) != null;
            {
            }
        }
        return false;
    }

    @NotNull
    public final String getStyle() {
        return this.style;
    }

    @NotNull
    public final ChainDirection getChainDirection() {
        return this.chainDirection;
    }

    public ChainStyleViewAction(@Nullable Icon icon2, @NotNull String style, @NotNull ChainDirection chainDirection, @NotNull String label) {
        super(icon2, label);
        this.style = style;
        this.chainDirection = chainDirection;
    }

    public /* synthetic */ ChainStyleViewAction(Icon icon2, String string, ChainDirection chainDirection, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = string;
        }
        this(icon2, string, chainDirection, string2);
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction$ChainDirection;", "", "(Ljava/lang/String;I)V", "HORIZONTAL", "VERTICAL", "intellij.android.designer"})
    public static final class ChainDirection
    extends Enum<ChainDirection> {
        public static final /* enum */ ChainDirection HORIZONTAL;
        public static final /* enum */ ChainDirection VERTICAL;
        private static final /* synthetic */ ChainDirection[] $VALUES;

        static {
            ChainDirection[] chainDirectionArray = new ChainDirection[2];
            ChainDirection[] chainDirectionArray2 = chainDirectionArray;
            chainDirectionArray[0] = HORIZONTAL = new ChainDirection();
            chainDirectionArray[1] = VERTICAL = new ChainDirection();
            $VALUES = chainDirectionArray;
        }

        public static ChainDirection[] values() {
            return (ChainDirection[])$VALUES.clone();
        }

        public static ChainDirection valueOf(String string) {
            return Enum.valueOf(ChainDirection.class, string);
        }
    }
}

