/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.wizard.template.Category;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WizardUtils {
    public static final String COMPOSE_MIN_AGP_VERSION = "4.0.0-alpha02";
    private static final int PACKAGE_LENGTH_LIMIT = 100;

    @NotNull
    public static File getProjectLocationParent() {
        String parent = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent != null) {
            return new File(PathUtil.toSystemDependentName((String)parent));
        }
        String defaultProjectLocation = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (defaultProjectLocation != null && !defaultProjectLocation.isEmpty()) {
            return new File(defaultProjectLocation);
        }
        String child = ApplicationNamesInfo.getInstance().getFullProductName().replace(" ", "") + "Projects";
        return new File(SystemProperties.getUserHome(), child);
    }

    @Nullable
    public static String validatePackageName(@Nullable String packageName) {
        String string = packageName = packageName == null ? "" : packageName;
        if (packageName.length() >= 100) {
            return AndroidBundle.message("android.wizard.module.package.too.long", new Object[0]);
        }
        return AndroidUtils.validateAndroidPackageName(packageName);
    }

    @NotNull
    public static String toHtmlString(@NotNull String text2) {
        if (!StringUtil.isEmpty((String)text2) && !text2.startsWith("<html>")) {
            text2 = text2.trim().replaceAll("\n", "<br>");
            return String.format("<html>%1$s</html>", text2);
        }
        return text2;
    }

    @NotNull
    public static URL toUrl(@NotNull String urlAsString) {
        URL url;
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    @NotNull
    public static JBScrollPane wrapWithVScroll(@NotNull JPanel innerPanel) {
        return WizardUtils.wrapWithVScroll(innerPanel, WIZARD_BORDER.LARGE);
    }

    @NotNull
    public static JBScrollPane wrapWithVScroll(@NotNull JPanel innerPanel, WIZARD_BORDER wizardBorder) {
        JBScrollPane sp = new JBScrollPane((Component)innerPanel, 20, 31);
        sp.setBorder(WIZARD_BORDER.EMPTY.border);
        innerPanel.setBorder(wizardBorder.border);
        return sp;
    }

    public static String getUniqueName(String initialValue, Validator<? super String> validator) {
        String uniqueName = initialValue;
        for (int i2 = 2; i2 <= 100 && validator.validate((Object)uniqueName).getSeverity() == Validator.Severity.ERROR; ++i2) {
            uniqueName = initialValue + i2;
        }
        return uniqueName;
    }

    public static boolean hasComposeMinAgpVersion(@Nullable Project project, Category category) {
        if (project == null || !Category.Compose.equals((Object)category)) {
            return true;
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromModel(project);
        if (androidPluginInfo == null) {
            return true;
        }
        GradleVersion agpVersion = androidPluginInfo.getPluginVersion();
        if (agpVersion == null) {
            return true;
        }
        return agpVersion.compareTo(COMPOSE_MIN_AGP_VERSION) >= 0;
    }

    public static enum WIZARD_BORDER {
        EMPTY((Border)JBUI.Borders.empty()),
        SMALL(JBUI.Borders.empty((int)16)),
        LARGE((Border)JBUI.Borders.empty((int)0, (int)72));

        public final Border border;

        private WIZARD_BORDER(Border border) {
            this.border = border;
        }
    }
}

