/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.ui;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.SketchLibrary;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignSymbol;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedSymbol;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayerable;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.meta.SketchMeta;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchArtboard;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPage;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolMaster;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SketchFile {
    private SketchDocument myDocument;
    private SketchMeta myMeta;
    private List<SketchPage> myPages = new ArrayList<SketchPage>();
    private SketchLibrary myLibrary = new SketchLibrary();

    public void addPage(@NotNull SketchPage page) {
        this.myPages.add(page);
        this.myLibrary.addSymbols(SketchFile.getAllSymbolMasters(page));
    }

    @NotNull
    private static ImmutableList<SketchStyle> getAllStyles(@NotNull SketchDocument document) {
        SketchSharedStyle[] sharedStyles;
        ImmutableList.Builder styles2 = new ImmutableList.Builder();
        SketchForeignStyle[] foreignStyles = document.getForeignLayerStyles();
        if (foreignStyles != null) {
            for (SketchForeignStyle sketchForeignStyle : foreignStyles) {
            }
        }
        if ((sharedStyles = document.getLayerStyles()) != null) {
            for (SketchSharedStyle sharedStyle : sharedStyles) {
                styles2.add((Object)sharedStyle.getValue());
            }
        }
        return styles2.build();
    }

    @NotNull
    private static ImmutableList<SketchSymbolMaster> getAllSymbolMasters(@NotNull SketchDocument document) {
        SketchSharedSymbol[] sharedSymbols;
        ImmutableList.Builder masters = new ImmutableList.Builder();
        SketchForeignSymbol[] foreignSymbols = document.getForeignSymbols();
        if (foreignSymbols != null) {
            for (SketchForeignSymbol foreignSymbol : foreignSymbols) {
                masters.add((Object)foreignSymbol.getSymbolMaster());
            }
        }
        if ((sharedSymbols = document.getLayerSymbols()) != null) {
            for (SketchSharedSymbol sketchSharedSymbol : sharedSymbols) {
            }
        }
        return masters.build();
    }

    @NotNull
    public static ImmutableList<SketchArtboard> getArtboards(@NotNull SketchPage page) {
        ImmutableList.Builder artboards = new ImmutableList.Builder();
        for (SketchLayer layer : page.getLayers()) {
            if (!layer.getClassType().equals("artboard")) continue;
            artboards.add((Object)((SketchArtboard)layer));
        }
        return artboards.build();
    }

    @NotNull
    public static ImmutableList<SketchSymbolMaster> getAllSymbolMasters(@NotNull SketchPage page) {
        ImmutableList.Builder masters = new ImmutableList.Builder();
        for (SketchLayer layer : page.getLayers()) {
            masters.addAll(SketchFile.getSymbolMasters(layer));
        }
        return masters.build();
    }

    @NotNull
    private static ImmutableList<SketchSymbolMaster> getSymbolMasters(@NotNull SketchLayer layer) {
        ImmutableList.Builder masters = new ImmutableList.Builder();
        if (layer instanceof SketchLayerable) {
            if (layer instanceof SketchSymbolMaster) {
                masters.add((Object)((SketchSymbolMaster)layer));
            }
            for (SketchLayer subLayer : ((SketchLayerable)((Object)layer)).getLayers()) {
                masters.addAll(SketchFile.getSymbolMasters(subLayer));
            }
        }
        return masters.build();
    }

    @NotNull
    public List<SketchPage> getPages() {
        return this.myPages;
    }

    @NotNull
    public SketchDocument getDocument() {
        return this.myDocument;
    }

    public void setDocument(@NotNull SketchDocument document) {
        this.myDocument = document;
        this.myLibrary.addSymbols(SketchFile.getAllSymbolMasters(document));
        this.myLibrary.addStyles(SketchFile.getAllStyles(document));
    }

    @NotNull
    public SketchMeta getMeta() {
        return this.myMeta;
    }

    public void setMeta(@NotNull SketchMeta meta) {
        this.myMeta = meta;
    }

    @NotNull
    public SketchLibrary getLibrary() {
        return this.myLibrary;
    }
}

