/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.ServiceProxy;
import com.android.tools.idea.transport.TransportBytesPreprocessor;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.NotNull;

public class TransportProxy {
    private Server myProxyServer;
    @NotNull
    private final List<ServiceProxy> myProxyServices;
    @NotNull
    private IDevice myDevice;
    @NotNull
    private ManagedChannel myTransportChannel;
    @NotNull
    private final TransportServiceProxy myProxyService;
    @NotNull
    private final LinkedBlockingDeque<Common.Event> myProxyEventQueue = new LinkedBlockingDeque();
    @NotNull
    private final Map<String, ByteString> myProxyBytesCache = Collections.synchronizedMap(new HashMap());

    public TransportProxy(@NotNull IDevice ddmlibDevice, @NotNull Common.Device transportDevice, @NotNull ManagedChannel transportChannel) {
        this.myDevice = ddmlibDevice;
        this.myTransportChannel = transportChannel;
        this.myProxyServices = new LinkedList<ServiceProxy>();
        this.myProxyService = new TransportServiceProxy(ddmlibDevice, transportDevice, transportChannel, this.myProxyEventQueue, this.myProxyBytesCache);
    }

    @NotNull
    public BlockingDeque<Common.Event> getEventQueue() {
        return this.myProxyEventQueue;
    }

    @NotNull
    public Map<String, ByteString> getBytesCache() {
        return this.myProxyBytesCache;
    }

    public void registerProxyService(ServiceProxy proxyService) {
        this.myProxyServices.add(proxyService);
    }

    public void registerProxyCommandHandler(Commands.Command.CommandType commandType, ProxyCommandHandler handler2) {
        this.myProxyService.registerCommandHandler(commandType, handler2);
    }

    public void registerEventPreprocessor(TransportEventPreprocessor eventPreprocessor) {
        this.myProxyService.registerEventPreprocessor(eventPreprocessor);
    }

    public void registerDataPreprocessor(TransportBytesPreprocessor dataPreprocessor) {
        this.myProxyService.registerDataPreprocessor(dataPreprocessor);
    }

    public void initializeProxyServer(String channelName) {
        InProcessServerBuilder builder2 = InProcessServerBuilder.forName((String)channelName);
        this.myProxyServices.add(this.myProxyService);
        this.myProxyServices.forEach(arg_0 -> TransportProxy.lambda$initializeProxyServer$0((ServerBuilder)builder2, arg_0));
        this.myProxyServer = builder2.build();
    }

    public void connect() throws IOException {
        if (this.myProxyServer == null) {
            throw new IllegalStateException("Proxy server has not been built");
        }
        this.myProxyServer.start();
    }

    public void disconnect() {
        if (this.myProxyServer == null) {
            throw new IllegalStateException("Proxy server has not been built");
        }
        this.myProxyServices.forEach(ServiceProxy::disconnect);
        this.myProxyServer.shutdown();
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }

    @NotNull
    public ManagedChannel getTransportChannel() {
        return this.myTransportChannel;
    }

    private static /* synthetic */ void lambda$initializeProxyServer$0(ServerBuilder builder2, ServiceProxy service) {
        builder2.addService(service.getServiceDefinition());
    }

    public static interface ProxyCommandHandler {
        public Transport.ExecuteResponse execute(Commands.Command var1);

        default public boolean shouldHandle(Commands.Command command) {
            return true;
        }
    }
}

