/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRootSearchScope
extends GlobalSearchScope {
    @NotNull
    private final TObjectIntHashMap<File> myDirRootPaths = new TObjectIntHashMap();
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;

    public FileRootSearchScope(@NotNull Project project, @NotNull Collection<File> rootDirPaths) {
        super(project);
        int i2 = 1;
        for (File root2 : rootDirPaths) {
            this.myDirRootPaths.put((Object)root2, i2++);
        }
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public boolean accept(@NotNull File file2) {
        while (!file2.exists()) {
            if (this.myDirRootPaths.containsKey((Object)file2)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)true);
        if (virtualFile != null) {
            return this.accept(virtualFile);
        }
        return false;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        VirtualFile sourceRootForFile;
        File path2 = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
        if (this.myDirRootPaths.contains((Object)path2)) {
            return true;
        }
        if (this.myProjectFileIndex.isInContent(file2) && (sourceRootForFile = this.myProjectFileIndex.getSourceRootForFile(file2)) != null) {
            path2 = VfsUtilCore.virtualToIoFile((VirtualFile)sourceRootForFile);
            return this.myDirRootPaths.contains((Object)path2);
        }
        VirtualFile classRootForFile = this.myProjectFileIndex.getClassRootForFile(file2);
        if (classRootForFile != null) {
            path2 = VfsUtilCore.virtualToIoFile((VirtualFile)classRootForFile);
            return this.myDirRootPaths.contains((Object)path2);
        }
        return false;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r2;
        VirtualFile r1 = this.getFileRoot(file1);
        if (Objects.equals(r1, r2 = this.getFileRoot(file2))) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        int i1 = this.myDirRootPaths.get((Object)VfsUtilCore.virtualToIoFile((VirtualFile)r1));
        int i2 = this.myDirRootPaths.get((Object)VfsUtilCore.virtualToIoFile((VirtualFile)r2));
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return true;
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (this.myProjectFileIndex.isInContent(file2)) {
            return this.myProjectFileIndex.getSourceRootForFile(file2);
        }
        return this.myProjectFileIndex.getClassRootForFile(file2);
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope2) {
        if (scope2 instanceof FileRootSearchScope) {
            return this.add((FileRootSearchScope)scope2);
        }
        return super.uniteWith(scope2);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    protected FileRootSearchScope add(@NotNull FileRootSearchScope scope2) {
        return this.calculate(scope2, true);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    protected FileRootSearchScope subtract(@NotNull FileRootSearchScope scope2) {
        return this.calculate(scope2, false);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    private FileRootSearchScope calculate(@NotNull FileRootSearchScope scope2, boolean add2) {
        HashSet roots = Sets.newHashSet();
        this.myDirRootPaths.forEach(file2 -> {
            roots.add(file2);
            return true;
        });
        scope2.myDirRootPaths.forEach(file2 -> {
            if (add2) {
                roots.add(file2);
            } else {
                roots.remove(file2);
            }
            return true;
        });
        Project project = this.getProject();
        assert (project != null);
        return new FileRootSearchScope(project, roots);
    }
}

