/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJUnitConfigurations {
    public static boolean shouldUseAndroidJUnitConfigurations(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Module module2;
        RunConfiguration androidConfiguration = self.getConfiguration();
        RunConfiguration otherConfiguration = other.getConfiguration();
        return androidConfiguration instanceof ModuleBasedConfiguration && otherConfiguration instanceof JUnitConfiguration && !(otherConfiguration instanceof AndroidJUnitConfiguration) && (module2 = ((ModuleBasedConfiguration)androidConfiguration).getConfigurationModule().getModule()) != null && GradleProjects.isIdeaAndroidModule(module2);
    }

    public static boolean isFromContext(@NotNull JUnitConfiguration junitConfiguration, @NotNull ConfigurationContext context, @NotNull ConfigurationFactory configurationFactory) {
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        if (contextLocation == null) {
            return false;
        }
        PsiElement leaf = contextLocation.getPsiElement();
        Location<PsiMethod> methodLocation = AndroidJUnitConfigurations.getTestMethodLocation(leaf);
        PsiClass testClass = AndroidJUnitConfigurations.getTestClass(leaf);
        TestObject testObject = junitConfiguration.getTestObject();
        if (!testObject.isConfiguredByElement(junitConfiguration, testClass, methodLocation == null ? null : (PsiMethod)methodLocation.getPsiElement(), null, null)) {
            return false;
        }
        return AndroidJUnitConfigurations.settingsMatchTemplate(junitConfiguration, context, configurationFactory);
    }

    private static boolean settingsMatchTemplate(@NotNull JUnitConfiguration junitConfiguration, @NotNull ConfigurationContext configurationContext, @NotNull ConfigurationFactory configurationFactory) {
        String vmParameters;
        RunConfiguration predefinedConfiguration = configurationContext.getOriginalConfiguration((ConfigurationType)AndroidJUnitConfigurationType.getInstance());
        if (predefinedConfiguration != null && predefinedConfiguration instanceof CommonJavaRunConfigurationParameters && (vmParameters = ((CommonJavaRunConfigurationParameters)predefinedConfiguration).getVMParameters()) != null && !junitConfiguration.getVMParameters().equals(vmParameters)) {
            return false;
        }
        RunnerAndConfigurationSettings template = RunManager.getInstance((Project)junitConfiguration.getProject()).getConfigurationTemplate(configurationFactory);
        Module predefinedModule = ((ModuleBasedConfiguration)template.getConfiguration()).getConfigurationModule().getModule();
        Module configurationModule = ((JavaRunConfigurationModule)junitConfiguration.getConfigurationModule()).getModule();
        Module contextModule = configurationContext.getLocation() == null ? null : configurationContext.getLocation().getModule();
        return configurationModule == contextModule || configurationModule == predefinedModule;
    }

    @Nullable
    private static PsiClass getTestClass(@NotNull PsiElement leaf) {
        PsiClass psiClass = (PsiClass)AndroidPsiUtils.getPsiParentOfType((PsiElement)leaf, PsiClass.class, (boolean)false);
        if (psiClass != null && JUnitUtil.isTestClass((PsiClass)psiClass)) {
            return psiClass;
        }
        return null;
    }

    @Nullable
    private static Location<PsiMethod> getTestMethodLocation(@NotNull PsiElement leaf) {
        Location methodLocation;
        PsiMethod method2 = (PsiMethod)AndroidPsiUtils.getPsiParentOfType((PsiElement)leaf, PsiMethod.class, (boolean)false);
        if (method2 != null && (methodLocation = PsiLocation.fromPsiElement((PsiElement)method2)) != null && JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) {
            return methodLocation;
        }
        return null;
    }
}

