/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.ddmlib.IDevice;
import com.android.ide.common.util.DeviceUtils;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.HostData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.AndroidStudioUsageTracker$WhenMappings;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.CompletionStats;
import com.android.tools.idea.stats.SatisfactionDialog;
import com.android.tools.idea.stats.ToolWindowTrackerService;
import com.android.tools.idea.stats.TypingLatencyTracker;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ComposeSampleEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.DisplayDetails;
import com.google.wireless.android.sdk.stats.IdePlugin;
import com.google.wireless.android.sdk.stats.IdePluginInfo;
import com.google.wireless.android.sdk.stats.MachineDetails;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.google.wireless.android.sdk.stats.StudioProjectChange;
import com.google.wireless.android.sdk.stats.UserSentiment;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.sun.management.OperatingSystemMXBean;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0006\u0010#\u001a\u00020!J\b\u0010$\u001a\u00020!H\u0002J\b\u0010%\u001a\u00020!H\u0002J\b\u0010&\u001a\u00020!H\u0002J\b\u0010'\u001a\u00020!H\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0007J\b\u0010+\u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/stats/AndroidStudioUsageTracker;", "", "()V", "IDLE_TIME_BEFORE_SHOWING_DIALOG", "", "STUDIO_EXPERIMENTS_OVERRIDE", "", "displayDetails", "", "Lcom/google/wireless/android/sdk/stats/DisplayDetails;", "getDisplayDetails", "()Ljava/lang/Iterable;", "productDetails", "Lcom/google/wireless/android/sdk/stats/ProductDetails;", "getProductDetails$annotations", "getProductDetails", "()Lcom/google/wireless/android/sdk/stats/ProductDetails;", "buildActiveExperimentList", "", "currentIdeTheme", "Lcom/google/wireless/android/sdk/stats/ProductDetails$IdeTheme;", "deviceToDeviceInfo", "Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "device", "Lcom/android/ddmlib/IDevice;", "deviceToDeviceInfoApilLevelOnly", "getMachineDetails", "Lcom/google/wireless/android/sdk/stats/MachineDetails;", "homePath", "Ljava/io/File;", "lifecycleChannelFromUpdateSettings", "Lcom/google/wireless/android/sdk/stats/ProductDetails$SoftwareLifeCycleChannel;", "processUserSentiment", "", "reportEnabledPlugins", "requestUserSentiment", "runDailyReports", "runHourlyReports", "runShutdownReports", "runStartupReports", "setup", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "subscribeToEvents", "ProjectLifecycleTracker", "intellij.android.core"})
public final class AndroidStudioUsageTracker {
    private static final int IDLE_TIME_BEFORE_SHOWING_DIALOG = 180000;
    @NotNull
    public static final String STUDIO_EXPERIMENTS_OVERRIDE = "studio.experiments.override";
    public static final AndroidStudioUsageTracker INSTANCE;

    @JvmStatic
    public static /* synthetic */ void getProductDetails$annotations() {
    }

    @NotNull
    public static final ProductDetails getProductDetails() {
        ApplicationInfo application = ApplicationInfo.getInstance();
        ProductDetails.ProductKind productKind = IdeInfo.isGameTool() ? ProductDetails.ProductKind.GAME_TOOLS : ProductDetails.ProductKind.STUDIO;
        ProductDetails.Builder builder2 = ProductDetails.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        ProductDetails.Builder $this$apply = builder2;
        boolean bl3 = false;
        $this$apply.setProduct(productKind);
        $this$apply.setBuild(application.getBuild().asString());
        $this$apply.setVersion(application.getStrictVersion());
        $this$apply.setOsArchitecture(CommonMetricsData.getOsArchitecture());
        $this$apply.setChannel(INSTANCE.lifecycleChannelFromUpdateSettings());
        $this$apply.setTheme(INSTANCE.currentIdeTheme());
        $this$apply.addAllExperimentId((Iterable)AndroidStudioUsageTracker.buildActiveExperimentList());
        return builder2.build();
    }

    @JvmStatic
    @NotNull
    public static final Collection<String> buildActiveExperimentList() {
        String experimentOverrides = System.getProperty(STUDIO_EXPERIMENTS_OVERRIDE);
        CharSequence charSequence = experimentOverrides;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            boolean bl3 = false;
            return CollectionsKt.emptyList();
        }
        return StringsKt.split$default((CharSequence)experimentOverrides, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
    }

    private final Iterable<DisplayDetails> getDisplayDetails() {
        GraphicsEnvironment graphics;
        ArrayList<DisplayDetails> displays = new ArrayList<DisplayDetails>();
        GraphicsEnvironment graphicsEnvironment = HostData.getGraphicsEnvironment();
        if (graphicsEnvironment == null) {
            Intrinsics.throwNpe();
        }
        if (!(graphics = graphicsEnvironment).isHeadlessInstance()) {
            for (GraphicsDevice device : graphics.getScreenDevices()) {
                GraphicsConfiguration defaultConfiguration = device.getDefaultConfiguration();
                Rectangle bounds2 = defaultConfiguration.getBounds();
                displays.add(DisplayDetails.newBuilder().setHeight((long)bounds2.height).setWidth((long)bounds2.width).setSystemScale(JBUIScale.sysScale((GraphicsConfiguration)defaultConfiguration)).build());
            }
        }
        return displays;
    }

    @JvmStatic
    @NotNull
    public static final MachineDetails getMachineDetails(@NotNull File homePath) {
        OperatingSystemMXBean operatingSystemMXBean = HostData.getOsBean();
        if (operatingSystemMXBean == null) {
            Intrinsics.throwNpe();
        }
        OperatingSystemMXBean osBean = operatingSystemMXBean;
        return MachineDetails.newBuilder().setAvailableProcessors(osBean.getAvailableProcessors()).setTotalRam(osBean.getTotalPhysicalMemorySize()).setTotalDisk(homePath.getTotalSpace()).addAllDisplay(INSTANCE.getDisplayDetails()).build();
    }

    @JvmStatic
    public static final void setup(@NotNull ScheduledExecutorService scheduler) {
        scheduler.submit(setup.1.INSTANCE);
        scheduler.scheduleWithFixedDelay(setup.2.INSTANCE, 0L, 1L, TimeUnit.DAYS);
        scheduler.scheduleWithFixedDelay(setup.3.INSTANCE, 0L, 1L, TimeUnit.HOURS);
        INSTANCE.subscribeToEvents();
    }

    private final void subscribeToEvents() {
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect();
        connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleTracker());
        connection.subscribe(LatencyListener.TOPIC, (Object)TypingLatencyTracker.INSTANCE);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                AndroidStudioUsageTracker.access$runShutdownReports(AndroidStudioUsageTracker.INSTANCE);
            }
        });
    }

    private final void runStartupReports() {
        this.reportEnabledPlugins();
    }

    private final void runShutdownReports() {
        TypingLatencyTracker.INSTANCE.reportTypingLatency();
        CompletionStats.INSTANCE.reportCompletionStats();
    }

    private final void reportEnabledPlugins() {
        List plugins = PluginManagerCore.getLoadedPlugins();
        IdePluginInfo.Builder pluginInfoProto = IdePluginInfo.newBuilder();
        for (IdeaPluginDescriptor plugin : plugins) {
            if (!plugin.isEnabled()) continue;
            Object object = plugin.getPluginId();
            if (object == null || (object = object.getIdString()) == null) {
                continue;
            }
            Object id = object;
            IdePlugin.Builder pluginProto = IdePlugin.newBuilder();
            pluginProto.setId(StringsKt.take((String)id, (int)256));
            String string = plugin.getVersion();
            if (string != null && (string = StringsKt.take((String)string, (int)256)) != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                pluginProto.setVersion(it);
            }
            pluginProto.setBundled(plugin.isBundled());
            pluginInfoProto.addPlugins(pluginProto);
        }
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.IDE_PLUGIN_INFO).setIdePluginInfo(pluginInfoProto));
    }

    private final void runDailyReports() {
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioEvent.EventKind.STUDIO_PING).setProductDetails(AndroidStudioUsageTracker.getProductDetails()).setMachineDetails(AndroidStudioUsageTracker.getMachineDetails(new File(PathManager.getHomePath()))).setJvmDetails(CommonMetricsData.getJvmDetails()));
        this.processUserSentiment();
    }

    private final void processUserSentiment() {
        if (!AnalyticsSettings.INSTANCE.shouldRequestUserSentiment()) {
            return;
        }
        this.requestUserSentiment();
    }

    /*
     * WARNING - void declaration
     */
    public final void requestUserSentiment() {
        void runner;
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Object object = runner.element = (Runnable)new Runnable(eventQueue, (Ref.ObjectRef)runner){
            final /* synthetic */ IdeEventQueue $eventQueue;
            final /* synthetic */ Ref.ObjectRef $runner;

            public final void run() {
                Object object = this.$runner.element;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"runner");
                }
                this.$eventQueue.removeIdleListener((Runnable)object);
                Date now = AnalyticsSettings.getDateProvider().now();
                SatisfactionDialog dialog2 = new SatisfactionDialog();
                dialog2.showAndGetOk().doWhenDone(new Runnable(dialog2, now){
                    final /* synthetic */ SatisfactionDialog $dialog;
                    final /* synthetic */ Date $now;

                    /*
                     * WARNING - void declaration
                     */
                    public final void run() {
                        void $this$apply;
                        UserSentiment.SatisfactionLevel result2 = this.$dialog.getSelectedSentiment();
                        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder();
                        boolean bl = false;
                        boolean bl2 = false;
                        AndroidStudioEvent.Builder $this$apply2 = builder2;
                        boolean bl3 = false;
                        $this$apply2.setKind(AndroidStudioEvent.EventKind.USER_SENTIMENT);
                        UserSentiment.Builder builder3 = UserSentiment.newBuilder();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        UserSentiment.Builder builder4 = builder3;
                        AndroidStudioEvent.Builder builder5 = $this$apply2;
                        boolean bl6 = false;
                        $this$apply.setState(UserSentiment.SentimentState.POPUP_QUESTION);
                        $this$apply.setLevel(result2);
                        Unit unit = Unit.INSTANCE;
                        builder5.setUserSentiment(builder3.build());
                        UsageTracker.log((AndroidStudioEvent.Builder)builder2);
                        AnalyticsSettings.setLastSentimentQuestionDate((Date)this.$now);
                        AnalyticsSettings.setLastSentimentAnswerDate((Date)this.$now);
                        AnalyticsSettings.saveSettings();
                    }
                    {
                        this.$dialog = satisfactionDialog;
                        this.$now = date;
                    }
                });
            }
            {
                this.$eventQueue = ideEventQueue;
                this.$runner = objectRef;
            }
        };
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runner");
        }
        eventQueue.addIdleListener((Runnable)object, 180000);
    }

    private final void runHourlyReports() {
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SYSTEM).setKind(AndroidStudioEvent.EventKind.STUDIO_PROCESS_STATS).setJavaProcessStats(CommonMetricsData.getJavaProcessStats()));
        TypingLatencyTracker.INSTANCE.reportTypingLatency();
        CompletionStats.INSTANCE.reportCompletionStats();
    }

    @JvmStatic
    @NotNull
    public static final DeviceInfo deviceToDeviceInfo(@NotNull IDevice device) {
        return DeviceInfo.newBuilder().setAnonymizedSerialNumber(AnonymizerUtil.anonymizeUtf8((String)device.getSerialNumber())).setBuildTags(Strings.nullToEmpty((String)device.getProperty("ro.build.tags"))).setBuildType(Strings.nullToEmpty((String)device.getProperty("ro.build.type"))).setBuildVersionRelease(Strings.nullToEmpty((String)device.getProperty("ro.build.version.release"))).setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)device.getProperty("ro.product.cpu.abi"))).setManufacturer(Strings.nullToEmpty((String)device.getProperty("ro.product.manufacturer"))).setDeviceType(device.isEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).setMdnsConnectionType(DeviceUtils.isMdnsAutoConnectUnencrypted((IDevice)device) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_UNENCRYPTED : (DeviceUtils.isMdnsAutoConnectTls((IDevice)device) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_TLS : DeviceInfo.MdnsConnectionType.MDNS_NONE)).setModel(Strings.nullToEmpty((String)device.getProperty("ro.product.model"))).build();
    }

    /*
     * Unable to fully structure code
     */
    private final ProductDetails.IdeTheme currentIdeTheme() {
        block9: {
            block7: {
                block8: {
                    if (!UIUtil.isUnderDarcula()) break block7;
                    v0 = LafManager.getInstance().getCurrentLookAndFeel();
                    if (v0 != null && (v0 = v0.getName()) != null) {
                        var1_1 = v0;
                        var2_2 = Locale.US;
                        var3_3 = false;
                        var4_4 = var1_1;
                        var5_5 = false;
                        v1 = var4_4;
                        if (v1 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        v2 = v1.toLowerCase(var2_2);
                        v3 = v2;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.String).toLowerCase(locale)");
                    } else {
                        v3 = null;
                    }
                    if (v3 == null) break block8;
                    var1_1 = v3;
                    switch (var1_1.hashCode()) {
                        case -1716237376: {
                            if (!var1_1.equals("high contrast")) ** break;
                            break;
                        }
                        case 1441429116: {
                            if (!var1_1.equals("darcula")) ** break;
                            v4 = ProductDetails.IdeTheme.DARCULA;
                            break block9;
                        }
                    }
                    v4 = ProductDetails.IdeTheme.HIGH_CONTRAST;
                    break block9;
                }
                v4 = ProductDetails.IdeTheme.CUSTOM;
                break block9;
            }
            v4 = UIUtil.isUnderIntelliJLaF() ? (UIUtil.isUnderWin10LookAndFeel() ? ProductDetails.IdeTheme.LIGHT_WIN_NATIVE : (UIUtil.isUnderDefaultMacTheme() ? ProductDetails.IdeTheme.LIGHT_MAC_NATIVE : ProductDetails.IdeTheme.LIGHT)) : ProductDetails.IdeTheme.UNKNOWN_THEME;
        }
        return v4;
    }

    @JvmStatic
    @NotNull
    public static final DeviceInfo deviceToDeviceInfoApilLevelOnly(@NotNull IDevice device) {
        return DeviceInfo.newBuilder().setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).build();
    }

    private final ProductDetails.SoftwareLifeCycleChannel lifecycleChannelFromUpdateSettings() {
        ProductDetails.SoftwareLifeCycleChannel softwareLifeCycleChannel;
        switch (AndroidStudioUsageTracker$WhenMappings.$EnumSwitchMapping$0[UpdateSettings.getInstance().getSelectedChannelStatus().ordinal()]) {
            case 1: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.CANARY;
                break;
            }
            case 2: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.DEV;
                break;
            }
            case 3: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.BETA;
                break;
            }
            case 4: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.STABLE;
                break;
            }
            default: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.UNKNOWN_LIFE_CYCLE_CHANNEL;
            }
        }
        return softwareLifeCycleChannel;
    }

    private AndroidStudioUsageTracker() {
    }

    static {
        AndroidStudioUsageTracker androidStudioUsageTracker;
        INSTANCE = androidStudioUsageTracker = new AndroidStudioUsageTracker();
    }

    public static final /* synthetic */ void access$runStartupReports(AndroidStudioUsageTracker $this) {
        $this.runStartupReports();
    }

    public static final /* synthetic */ void access$runDailyReports(AndroidStudioUsageTracker $this) {
        $this.runDailyReports();
    }

    public static final /* synthetic */ void access$runHourlyReports(AndroidStudioUsageTracker $this) {
        $this.runHourlyReports();
    }

    public static final /* synthetic */ void access$runShutdownReports(AndroidStudioUsageTracker $this) {
        $this.runShutdownReports();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/stats/AndroidStudioUsageTracker$ProjectLifecycleTracker;", "Lcom/intellij/openapi/project/impl/ProjectLifecycleListener;", "()V", "afterProjectClosed", "", "project", "Lcom/intellij/openapi/project/Project;", "beforeProjectLoaded", "projectComponentsInitialized", "intellij.android.core"})
    private static final class ProjectLifecycleTracker
    implements ProjectLifecycleListener {
        public void beforeProjectLoaded(@NotNull Project project) {
            int projectsOpen = ProjectManager.getInstance().getOpenProjects().length;
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_OPENED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen)));
        }

        public void afterProjectClosed(@NotNull Project project) {
            int projectsOpen = ProjectManager.getInstance().getOpenProjects().length;
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_CLOSED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen)));
        }

        public void projectComponentsInitialized(@NotNull Project project) {
            block0: {
                ToolWindowTrackerService service = ToolWindowTrackerService.Companion.getInstance(project);
                project.getMessageBus().connect((Disposable)project).subscribe(ToolWindowManagerListener.TOPIC, (Object)service);
                StartupManager startupManager = StartupManager.getInstance((Project)project);
                if (startupManager == null) break block0;
                startupManager.registerPostStartupActivity(new Runnable(project){
                    final /* synthetic */ Project $project;

                    public final void run() {
                        boolean match2;
                        block3: {
                            boolean bl;
                            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project);
                            if (moduleManager == null) {
                                return;
                            }
                            ModuleManager moduleManager2 = moduleManager;
                            Sequence $this$any$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])moduleManager2.getModules()), (Function1)projectComponentsInitialized.match.1.INSTANCE), (Function1)projectComponentsInitialized.match.2.INSTANCE), (Function1)projectComponentsInitialized.match.3.INSTANCE);
                            boolean $i$f$any = false;
                            for (E element$iv : $this$any$iv) {
                                KFunction packageName = (KFunction)element$iv;
                                boolean bl2 = false;
                                if (!Objects.equals(packageName, "com.example.jetnews")) continue;
                                bl = true;
                                break block3;
                            }
                            bl = match2 = false;
                        }
                        if (!match2) {
                            return;
                        }
                        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.COMPOSE_SAMPLE_EVENT).setComposeSampleEvent(ComposeSampleEvent.newBuilder().setType(ComposeSampleEvent.ComposeSampleEventType.OPEN)));
                    }
                    {
                        this.$project = project;
                    }
                });
            }
        }
    }
}

