/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.actions.AndroidActionGroupRemover;
import com.android.tools.idea.actions.AndroidImportModuleAction;
import com.android.tools.idea.actions.AndroidNewModuleAction;
import com.android.tools.idea.actions.AndroidNewModuleInGroupAction;
import com.android.tools.idea.actions.AndroidNewProjectAction;
import com.android.tools.idea.actions.AndroidOpenFileAction;
import com.android.tools.idea.actions.CreateLibraryFromFilesAction;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectStructureAction;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.startup.AndroidSdkInitializer;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.android.utils.Pair;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.projectView.actions.MarkRootGroup;
import com.intellij.ide.projectView.impl.MoveModuleToGroupTopLevel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayDeque;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSpecificInitializer
implements ActionConfigurationCustomizer {
    private static final Logger LOG = Logger.getInstance(GradleSpecificInitializer.class);

    public void customize(@NotNull ActionManager actionManager) {
        GradleSpecificInitializer.setUpNewProjectActions(actionManager);
        GradleSpecificInitializer.setUpWelcomeScreenActions(actionManager);
        GradleSpecificInitializer.replaceProjectPopupActions(actionManager);
        Actions.hideAction(actionManager, "Groovy.CheckResources.Rebuild");
        Actions.hideAction(actionManager, "Groovy.CheckResources.Make");
        GradleSpecificInitializer.setUpGradleViewToolbarActions(actionManager);
        GradleSpecificInitializer.checkInstallPath();
        AnAction pluginAction = actionManager.getAction("StartupWizard");
        if (pluginAction != null) {
            pluginAction.getTemplatePresentation().setVisible(false);
        }
        if (AndroidSdkUtils.isAndroidSdkManagerEnabled()) {
            try {
                GradleSpecificInitializer.setupSdks();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
            }
            GradleSpecificInitializer.checkAndSetAndroidSdkSources();
        }
        if (ConfigImportHelper.isConfigImported()) {
            GradleSpecificInitializer.cleanProjectJdkTable();
        }
    }

    private static void checkInstallPath() {
        if (PathManager.getHomePath().contains("!")) {
            final Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                public void appStarting(Project project) {
                    app.invokeLater(() -> {
                        String message2 = String.format("%1$s must not be installed in a path containing '!' or Gradle sync will fail!", ApplicationNamesInfo.getInstance().getProductName());
                        Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification(message2, NotificationType.ERROR);
                        notification.setImportant(true);
                        Notifications.Bus.notify((Notification)notification);
                    });
                }
            });
        }
    }

    private static void setUpGradleViewToolbarActions(ActionManager actionManager) {
        Actions.hideAction(actionManager, "ExternalSystem.RefreshAllProjects");
        Actions.hideAction(actionManager, "ExternalSystem.SelectProjectDataToImport");
        Actions.hideAction(actionManager, "ExternalSystem.ToggleAutoReload");
        Actions.hideAction(actionManager, "ExternalSystem.DetachProject");
        Actions.hideAction(actionManager, "ExternalSystem.AttachProject");
    }

    private static void setUpNewProjectActions(ActionManager actionManager) {
        Actions.replaceAction(actionManager, "OpenFile", (AnAction)new AndroidOpenFileAction());
        Actions.replaceAction(actionManager, "NewProject", new AndroidNewProjectAction());
        Actions.replaceAction(actionManager, "NewModule", new AndroidNewModuleAction());
        Actions.replaceAction(actionManager, "NewModuleInGroup", new AndroidNewModuleInGroupAction());
        Actions.replaceAction(actionManager, "CreateLibraryFromFile", new CreateLibraryFromFilesAction());
        Actions.replaceAction(actionManager, "ImportModule", new AndroidImportModuleAction());
        Actions.hideAction(actionManager, "AddFrameworkSupport");
        Actions.hideAction(actionManager, "BuildArtifact");
        Actions.hideAction(actionManager, "RunTargetAction");
    }

    private static void setUpWelcomeScreenActions(ActionManager actionManager) {
        Actions.replaceAction(actionManager, "WelcomeScreen.OpenProject", (AnAction)new AndroidOpenFileAction("Open an Existing Project"));
        Actions.replaceAction(actionManager, "WelcomeScreen.CreateNewProject", new AndroidNewProjectAction("Create New Project"));
        Actions.replaceAction(actionManager, "WelcomeScreen.Configure.ProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
        Actions.replaceAction(actionManager, "TemplateProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
        Actions.moveAction(actionManager, "WelcomeScreen.ImportProject", "WelcomeScreen.QuickStart.IDEA", "WelcomeScreen.QuickStart", new Constraints(Anchor.AFTER, "Vcs.VcsClone"));
        AnAction getFromVcsAction = actionManager.getAction("Vcs.VcsClone");
        if (getFromVcsAction != null) {
            getFromVcsAction.getTemplatePresentation().setText("Get project from Version Control");
        }
    }

    private static void replaceProjectPopupActions(ActionManager actionManager) {
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        stack.add(Pair.of(null, (Object)actionManager.getAction("ProjectViewPopupMenu")));
        while (!stack.isEmpty()) {
            Pair entry = (Pair)stack.pop();
            DefaultActionGroup parent = (DefaultActionGroup)entry.getFirst();
            AnAction action2 = (AnAction)entry.getSecond();
            if (action2 instanceof DefaultActionGroup) {
                DefaultActionGroup actionGroup = (DefaultActionGroup)action2;
                for (AnAction child : actionGroup.getChildActionsOrStubs()) {
                    stack.push(Pair.of((Object)actionGroup, (Object)child));
                }
            }
            if (action2 instanceof MoveModuleToGroupTopLevel) {
                parent.remove(action2, actionManager);
                parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action2, "Move Module to Group"), new Constraints(Anchor.AFTER, "OpenModuleSettings"), actionManager);
                continue;
            }
            if (!(action2 instanceof MarkRootGroup)) continue;
            parent.remove(action2, actionManager);
            parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action2, "Mark Directory As"), new Constraints(Anchor.AFTER, "OpenModuleSettings"), actionManager);
        }
    }

    private static void notifyInvalidSdk() {
        String key = "android.invalid.sdk.message";
        String message2 = AndroidBundle.message(key, new Object[0]);
        NotificationListener.Adapter listener2 = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                SdkQuickfixUtils.showAndroidSdkManager();
                notification.expire();
            }
        };
        GradleSpecificInitializer.addStartupWarning(message2, (NotificationListener)listener2);
    }

    private static void addStartupWarning(final @NotNull String message2, final @Nullable NotificationListener listener2) {
        final Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appStarting(Project project) {
                app.invokeLater(() -> {
                    Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification("SDK Validation", message2, NotificationType.WARNING, listener2);
                    notification.setImportant(true);
                    Notifications.Bus.notify((Notification)notification);
                });
            }
        });
    }

    private static NotificationGroup getNotificationGroup() {
        NotificationGroup group2 = NotificationGroup.findRegisteredGroup((String)"System Health");
        if (group2 == null) {
            group2 = new NotificationGroup("Gradle Initializer", NotificationDisplayType.STICKY_BALLOON, true, null, null, null, PluginId.getId((String)"org.jetbrains.android"));
        }
        return group2;
    }

    private static void setupSdks() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        File androidHome = ideSdks.getAndroidSdkPath();
        if (androidHome != null) {
            Validator.Result result2 = PathValidator.forAndroidSdkLocation().validate(androidHome);
            Validator.Severity severity = result2.getSeverity();
            if (severity == Validator.Severity.ERROR) {
                GradleSpecificInitializer.notifyInvalidSdk();
            }
            return;
        }
        Sdk sdk = GradleSpecificInitializer.findFirstAndroidSdk();
        if (sdk != null) {
            String sdkHomePath = sdk.getHomePath();
            assert (sdkHomePath != null);
            ideSdks.createAndroidSdkPerAndroidTarget(FilePaths.toSystemDependentPath((String)sdkHomePath));
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            File androidSdkPath = GradleSpecificInitializer.getAndroidSdkPath();
            if (androidSdkPath == null) {
                return;
            }
            FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
            boolean promptSdkSelection = wizardMode == null;
            Sdk sdk1 = AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.getPath(), promptSdkSelection);
            if (sdk1 != null) {
                String sdkNamePrefix = "Android ";
                if (sdk1.getName().startsWith(sdkNamePrefix)) {
                    Sdk jdk;
                    SdkModificator sdkModificator = sdk1.getSdkModificator();
                    sdkModificator.setName(sdkNamePrefix + sdk1.getName().substring(sdkNamePrefix.length()));
                    sdkModificator.commitChanges();
                    AndroidSdkAdditionalData additionalData = AndroidSdks.getInstance().getAndroidSdkAdditionalData(sdk1);
                    if (additionalData != null && (jdk = additionalData.getJavaSdk()) != null) {
                        sdkModificator = jdk.getSdkModificator();
                        sdkModificator.setName("JDK");
                        sdkModificator.commitChanges();
                    }
                    ideSdks.createAndroidSdkPerAndroidTarget(androidSdkPath);
                }
            }
        });
    }

    @Nullable
    private static Sdk findFirstAndroidSdk() {
        List<Sdk> sdks = AndroidSdks.getInstance().getAllAndroidSdks();
        if (!sdks.isEmpty()) {
            return sdks.get(0);
        }
        return null;
    }

    @Nullable
    private static File getAndroidSdkPath() {
        return AndroidSdkInitializer.findOrGetAndroidSdkPath();
    }

    private static void checkAndSetAndroidSdkSources() {
        for (Sdk sdk : AndroidSdks.getInstance().getAllAndroidSdks()) {
            GradleSpecificInitializer.checkAndSetSources(sdk);
        }
    }

    private static void checkAndSetSources(@NotNull Sdk sdk) {
        VirtualFile[] storedSources = sdk.getRootProvider().getFiles(OrderRootType.SOURCES);
        if (storedSources.length > 0) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform != null) {
            if (ApplicationManager.getApplication().isWriteThread()) {
                GradleSpecificInitializer.setSources(sdk, platform);
            } else {
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> GradleSpecificInitializer.setSources(sdk, platform));
            }
        }
    }

    private static void setSources(@NotNull Sdk sdk, @NotNull AndroidPlatform platform) {
        SdkModificator sdkModificator = sdk.getSdkModificator();
        IAndroidTarget target = platform.getTarget();
        AndroidSdks.getInstance().findAndSetPlatformSources(target, sdkModificator);
        sdkModificator.commitChanges();
    }

    private static void cleanProjectJdkTable() {
        Runnable cleanJdkTableAction = () -> {
            ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
            JavaSdk javaSdk = JavaSdk.getInstance();
            for (Sdk jdk : jdkTable.getSdksOfType((SdkTypeId)javaSdk)) {
                String jdkPath = jdk.getHomePath();
                if (jdkPath == null) continue;
                Sdk newJdk = javaSdk.createJdk(jdk.getName(), jdkPath);
                jdkTable.updateJdk(jdk, newJdk);
            }
        };
        ApplicationManager.getApplication().invokeLaterOnWriteThread(cleanJdkTableAction);
    }
}

