/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.live;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorMessenger;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/live/LiveSqliteResultSet;", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "messenger", "Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;", "connectionId", "", "taskExecutor", "Ljava/util/concurrent/Executor;", "(Lcom/android/tools/idea/sqlite/model/SqliteStatement;Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;ILjava/util/concurrent/Executor;)V", "dispose", "", "sendQueryCommand", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Response;", "intellij.android.debuggers"})
public abstract class LiveSqliteResultSet
implements SqliteResultSet {
    private final SqliteStatement sqliteStatement;
    private final DatabaseInspectorMessenger messenger;
    private final int connectionId;
    private final Executor taskExecutor;

    @NotNull
    protected final ListenableFuture<SqliteInspectorProtocol.Response> sendQueryCommand(@NotNull SqliteStatement sqliteStatement) {
        SqliteInspectorProtocol.Command queryCommand = UtilsKt.buildQueryCommand(sqliteStatement, this.connectionId);
        return FutureUtils.cancelOnDispose(this.messenger.sendCommandAsync(queryCommand), (Disposable)this);
    }

    public void dispose() {
    }

    public LiveSqliteResultSet(@NotNull SqliteStatement sqliteStatement, @NotNull DatabaseInspectorMessenger messenger, int connectionId, @NotNull Executor taskExecutor2) {
        this.sqliteStatement = sqliteStatement;
        this.messenger = messenger;
        this.connectionId = connectionId;
        this.taskExecutor = taskExecutor2;
    }

    @Override
    @NotNull
    public SqliteStatement toRowCountStatement(@NotNull SqliteStatement $this$toRowCountStatement) {
        return SqliteResultSet.DefaultImpls.toRowCountStatement(this, $this$toRowCountStatement);
    }

    @Override
    @NotNull
    public SqliteStatement toSelectLimitOffset(@NotNull SqliteStatement $this$toSelectLimitOffset, int rowOffset, int rowBatchSize) {
        return SqliteResultSet.DefaultImpls.toSelectLimitOffset(this, $this$toSelectLimitOffset, rowOffset, rowBatchSize);
    }
}

