/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractUninstaller;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchUninstaller
extends AbstractUninstaller
implements PatchOperation {
    private LocalPackage myPatcher = PatchInstallerUtil.getLatestPatcher(this.getRepoManager());
    private File myEmptyDir = FileOpUtils.getNewTempDir((String)"PatchUninstaller", (FileOp)this.mFop);
    private File myGeneratedPatch;

    public PatchUninstaller(@NotNull LocalPackage p, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        super(p, mgr, fop);
        this.registerStateChangeListener((op, progress) -> {
            if (this.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE) {
                this.mFop.deleteFileOrFolder(this.getLocation(progress));
            }
        });
    }

    @Override
    @NotNull
    public LocalPackage getPatcher(@NotNull ProgressIndicator progressIndicator) {
        return this.myPatcher;
    }

    @Override
    @NotNull
    public File getNewFilesRoot() {
        return this.myEmptyDir;
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        return "<None>";
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.getPackage();
    }

    protected boolean doPrepare(@Nullable File installTemp, ProgressIndicator progress) {
        if (this.myPatcher == null) {
            return false;
        }
        this.myGeneratedPatch = PatchInstallerUtil.generatePatch(this, installTemp, this.mFop, progress);
        return this.myGeneratedPatch != null;
    }

    protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
        return PatchInstallerUtil.installPatch(this, this.myGeneratedPatch, this.mFop, progress);
    }
}

