/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchInstaller
extends AbstractInstaller
implements PatchOperation {
    private static final String PATCH_JAR_FN = "patch.jar";
    private LocalPackage myExisting;
    private File myPatchFile;

    public PatchInstaller(@Nullable LocalPackage existing2, @NotNull RemotePackage p, @NotNull Downloader downloader, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        super(p, mgr, downloader, fop);
        this.myExisting = existing2;
    }

    protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
        if (this.myPatchFile == null) {
            this.myPatchFile = new File(installTemp, PATCH_JAR_FN);
        }
        return PatchInstallerUtil.installPatch(this, this.myPatchFile, this.mFop, progress);
    }

    protected boolean doPrepare(@NotNull File tempDir, @NotNull ProgressIndicator progress) {
        LocalPackage local = (LocalPackage)this.getRepoManager().getPackages().getLocalPackages().get(this.getPackage().getPath());
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        Archive.PatchType patch = archive.getPatch(local.getVersion());
        assert (patch != null);
        this.myPatchFile = this.downloadPatchFile(patch, tempDir, progress);
        if (this.myPatchFile == null) {
            progress.logWarning("Patch failed to download.");
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.myExisting;
    }

    @Override
    @Nullable
    public LocalPackage getPatcher(@NotNull ProgressIndicator progress) {
        LocalPackage dependantPatcher = PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
        if (dependantPatcher == null) {
            dependantPatcher = this.tryToCompletePatcherInstall(progress);
        }
        if (dependantPatcher == null) {
            progress.logWarning("Failed to find SDK Patch Applier!");
        }
        return dependantPatcher;
    }

    @Nullable
    private LocalPackage tryToCompletePatcherInstall(@NotNull ProgressIndicator progress) {
        PackageOperation op = PatchInstallerUtil.getInProgressDependantPatcherInstall(this.getPackage(), this.getRepoManager());
        if (op != null && op.getInstallStatus() == PackageOperation.InstallStatus.PREPARED) {
            op.complete(progress.createSubProgress(0.9));
            progress.setFraction(0.9);
        }
        this.getRepoManager().reloadLocalIfNeeded(progress.createSubProgress(1.0));
        progress.setFraction(1.0);
        return PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
    }

    @Override
    @NotNull
    public File getNewFilesRoot() {
        throw new UnsupportedOperationException("PatchInstaller can't generate patches");
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        return this.getPackage().getDisplayName() + " Version " + this.getPackage().getVersion();
    }

    @Nullable
    private File downloadPatchFile(@NotNull Archive.PatchType patch, @NotNull File tempDir, @NotNull ProgressIndicator progress) {
        URL url = InstallerUtil.resolveUrl((String)patch.getUrl(), (RemotePackage)this.getPackage(), (ProgressIndicator)progress);
        if (url == null) {
            progress.logWarning("Failed to resolve URL: " + patch.getUrl());
            return null;
        }
        try {
            File patchFile = new File(tempDir, PATCH_JAR_FN);
            this.getDownloader().downloadFullyWithCaching(url, patchFile, patch.getChecksum(), progress);
            return patchFile;
        }
        catch (IOException e) {
            progress.logWarning("Error during downloading", (Throwable)e);
            return null;
        }
    }
}

