/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DeployTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(DeployTask.class);
    private static final String ID = "DEPLOY";
    private static final ImmutableSet<String> ANDROIDX_TEST_SERVICE_PACKAGES = ImmutableSet.of((Object)"androidx.test.orchestrator", (Object)"androidx.test.services", (Object)"android.support.test.orchestrator", (Object)"android.support.test.services");
    private final String[] userInstallOptions;
    private final boolean installOnAllUsers;

    private static boolean isAndroidXTestServicePackage(String applicationId2) {
        return ANDROIDX_TEST_SERVICE_PACKAGES.stream().anyMatch(applicationId2::startsWith);
    }

    public DeployTask(@NotNull Project project, @NotNull Map<String, List<File>> packages, String userInstallOptions, boolean installOnAllUsers, boolean alwaysInstallWithPm) {
        super(project, packages, false, alwaysInstallWithPm);
        if (userInstallOptions != null && !userInstallOptions.isEmpty()) {
            userInstallOptions = userInstallOptions.trim();
            this.userInstallOptions = userInstallOptions.split("\\s");
        } else {
            this.userInstallOptions = new String[0];
        }
        this.installOnAllUsers = installOnAllUsers;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    protected boolean shouldTaskLaunchApp() {
        return true;
    }

    @Override
    protected Deployer.Result perform(IDevice device, Deployer deployer, String applicationId2, List<File> files2) throws DeployerException {
        boolean isDontKillSupported;
        InstallOptions.Builder options2 = InstallOptions.builder().setAllowDebuggable();
        if (!this.installOnAllUsers && device.getVersion().isGreaterOrEqualThan(24)) {
            options2.setInstallOnCurrentUser();
        }
        if (device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            options2.setGrantAllPermissions();
        }
        if (device.getVersion().getApiLevel() >= 30 && DeployTask.isAndroidXTestServicePackage(applicationId2)) {
            options2.setForceQueryable();
        }
        if (device.getVersion().isGreaterOrEqualThan(28)) {
            options2.setInstallFullApk();
        }
        if (isDontKillSupported = device.getVersion().isGreaterOrEqualThan(24)) {
            options2.setDontKill();
        }
        if (this.userInstallOptions != null) {
            options2.setUserInstallOptions(this.userInstallOptions);
        }
        options2.setSkipVerification(device, applicationId2);
        LOG.info("Installing application: " + applicationId2);
        Deployer.InstallMode installMode = Deployer.InstallMode.DELTA;
        if (!((Boolean)StudioFlags.DELTA_INSTALL.get()).booleanValue()) {
            installMode = Deployer.InstallMode.FULL;
        }
        Deployer.Result result2 = deployer.install(applicationId2, DeployTask.getPathsToInstall(files2), options2.build(), installMode);
        if (!result2.skippedInstall && isDontKillSupported) {
            device.forceStop(applicationId2);
        }
        return result2;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Install";
    }

    @Override
    @NotNull
    public String getFailureTitle() {
        return "Installation did not succeed.";
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "App restart successful without requiring a re-install.";
        }
        return "App restart successful without re-installing the following APK(s): " + skippedApkList.stream().collect(Collectors.joining(", "));
    }
}

