/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.SpecificActivityLocator;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.editor.LaunchOption;
import com.android.tools.idea.run.editor.LaunchOptionConfigurable;
import com.android.tools.idea.run.editor.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.editor.LaunchOptionState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.editor.SpecificActivityConfigurable;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.SpecificActivityLaunchTask;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecificActivityLaunch
extends LaunchOption<State> {
    public static final SpecificActivityLaunch INSTANCE = new SpecificActivityLaunch();

    @Override
    @NotNull
    public String getId() {
        return "specific_activity";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Specified Activity";
    }

    @Override
    @NotNull
    public State createState() {
        return new State();
    }

    @Override
    @NotNull
    public LaunchOptionConfigurable<State> createConfigurable(@NotNull Project project, @NotNull LaunchOptionConfigurableContext context) {
        return new SpecificActivityConfigurable(project, context);
    }

    public static class State
    extends LaunchOptionState {
        public String ACTIVITY_CLASS = "";
        public boolean SEARCH_ACTIVITY_IN_GLOBAL_SCOPE = false;
        public boolean SKIP_ACTIVITY_VALIDATION = false;

        @Override
        @Nullable
        public AppLaunchTask getLaunchTask(@NotNull String applicationId2, @NotNull AndroidFacet facet2, @NotNull StartActivityFlagsProvider startActivityFlagsProvider, @NotNull ProfilerState profilerState, @NotNull ApkProvider apkProvider) {
            return new SpecificActivityLaunchTask(applicationId2, this.ACTIVITY_CLASS, startActivityFlagsProvider);
        }

        @Override
        @NotNull
        public List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet2) {
            try {
                if (!this.SKIP_ACTIVITY_VALIDATION) {
                    this.getActivityLocator(facet2).validate();
                }
                return ImmutableList.of();
            }
            catch (ActivityLocator.ActivityLocatorException e) {
                return ImmutableList.of((Object)ValidationError.warning(e.getMessage()));
            }
        }

        @VisibleForTesting
        @NotNull
        protected SpecificActivityLocator getActivityLocator(@NotNull AndroidFacet facet2) {
            Project project = facet2.getModule().getProject();
            GlobalSearchScope scope2 = this.SEARCH_ACTIVITY_IN_GLOBAL_SCOPE ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
            return new SpecificActivityLocator(facet2, this.ACTIVITY_CLASS, scope2);
        }
    }
}

