/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.Client;
import com.android.ide.common.gradle.model.IdeTestOptions;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerImplBase;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.tasks.ConnectJavaDebuggerTask;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.testartifacts.instrumented.orchestrator.OrchestratorUtilsKt;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.XDebugSession;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaDebugger
extends AndroidDebuggerImplBase<AndroidDebuggerState> {
    public static final String ID = "Java";
    private static final String RUN_CONFIGURATION_NAME_PATTERN = "Android Debugger (%s)";

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Java Only";
    }

    @Override
    @NotNull
    public AndroidDebuggerState createState() {
        return new AndroidDebuggerState();
    }

    @Override
    @NotNull
    public AndroidDebuggerConfigurable<AndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        return new AndroidDebuggerConfigurable<AndroidDebuggerState>();
    }

    @Override
    @NotNull
    public DebugConnectorTask getConnectDebuggerTask(@NotNull ExecutionEnvironment env, @Nullable AndroidVersion version2, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet2, @NotNull AndroidDebuggerState state, @NotNull String runConfigTypeId, @Nullable String packageNameOverride) {
        ConnectJavaDebuggerTask baseConnector = new ConnectJavaDebuggerTask(applicationIds, this, env.getProject(), ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 4);
        IdeTestOptions.Execution executionType = Optional.ofNullable(AndroidModuleModel.get(facet2)).map(AndroidModuleModel::getTestExecutionStrategy).orElse(IdeTestOptions.Execution.HOST);
        switch (executionType) {
            case ANDROID_TEST_ORCHESTRATOR: 
            case ANDROIDX_TEST_ORCHESTRATOR: {
                return OrchestratorUtilsKt.createReattachingDebugConnectorTask(baseConnector, executionType);
            }
        }
        return baseConnector;
    }

    @Override
    public boolean supportsProject(@NotNull Project project) {
        return true;
    }

    @Override
    @Slow
    public void attachToClient(@NotNull Project project, final @NotNull Client client, @Nullable RunConfiguration config) {
        ExecutionEnvironment executionEnvironment;
        String debugPort = AndroidJavaDebugger.getClientDebugPort(client);
        String runConfigName = AndroidJavaDebugger.getRunConfigurationName(debugPort);
        Ref existingSession = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> existingSession.set((Object)AndroidJavaDebugger.hasExistingDebugSession(project, debugPort, runConfigName)));
        if (((Boolean)existingSession.get()).booleanValue()) {
            return;
        }
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createConfiguration(runConfigName, RemoteConfigurationType.class);
        RemoteConfiguration configuration = (RemoteConfiguration)runSettings.getConfiguration();
        configuration.HOST = "localhost";
        configuration.PORT = debugPort;
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = false;
        ProgramRunner.Callback callback2 = new ProgramRunner.Callback(){

            public void processStarted(RunContentDescriptor descriptor2) {
                final ProcessHandler handler2 = descriptor2.getProcessHandler();
                if (handler2 == null) {
                    return;
                }
                final VMExitedNotifier notifier = new VMExitedNotifier(client);
                ProcessAdapter processAdapter = new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        handler2.removeProcessListener((ProcessListener)this);
                        notifier.notifyClient();
                    }
                };
                handler2.addProcessListener((ProcessListener)processAdapter);
                if (handler2.isProcessTerminated()) {
                    handler2.removeProcessListener((ProcessListener)processAdapter);
                    notifier.notifyClient();
                }
            }
        };
        try {
            executionEnvironment = ExecutionEnvironmentBuilder.create((Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunnerAndConfigurationSettings)runSettings).contentToReuse(null).dataContext(null).activeTarget().build();
        }
        catch (ExecutionException e) {
            Logger.getInstance(AndroidJavaDebugger.class).error((Throwable)e);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> ProgramRunnerUtil.executeConfigurationAsync((ExecutionEnvironment)executionEnvironment, (boolean)true, (boolean)true, (ProgramRunner.Callback)callback2));
    }

    public DebuggerSession getDebuggerSession(@NotNull Client client) {
        String debugPort = AndroidJavaDebugger.getClientDebugPort(client);
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            DebuggerSession debuggerSession = AndroidJavaDebugger.findJdwpDebuggerSession(openProject, debugPort);
            if (debuggerSession == null) continue;
            return debuggerSession;
        }
        return null;
    }

    @NotNull
    public static String getRunConfigurationName(@NotNull String debugPort) {
        return String.format(RUN_CONFIGURATION_NAME_PATTERN, debugPort);
    }

    public static boolean hasExistingDebugSession(@NotNull Project project, @NotNull String debugPort, final @NotNull String runConfigName) {
        Project[] openProjects;
        Collection<Object> descriptors = null;
        for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            DebuggerSession debuggerSession;
            Project targetProject = openProject;
            descriptors = ExecutionHelper.findRunningConsoleByTitle((Project)targetProject, (NotNullFunction)new NotNullFunction<String, Boolean>(){

                @NotNull
                public Boolean fun(String title) {
                    return runConfigName.equals(title);
                }
            });
            if (descriptors.isEmpty() && (debuggerSession = AndroidJavaDebugger.findJdwpDebuggerSession(targetProject, debugPort)) != null) {
                XDebugSession session = debuggerSession.getXDebugSession();
                if (session != null) {
                    descriptors = Collections.singletonList(session.getRunContentDescriptor());
                } else {
                    debuggerSession.getProcess().stop(false);
                }
            }
            if (!descriptors.isEmpty()) break;
        }
        if (descriptors != null && !descriptors.isEmpty()) {
            return AndroidJavaDebugger.activateDebugSessionWindow(project, (RunContentDescriptor)descriptors.iterator().next());
        }
        return false;
    }

    private static class VMExitedNotifier {
        @NotNull
        private final Client myClient;
        @NotNull
        private final AtomicBoolean myNeedsToNotify = new AtomicBoolean(true);

        private VMExitedNotifier(@NotNull Client client) {
            this.myClient = client;
        }

        private void notifyClient() {
            if (this.myNeedsToNotify.getAndSet(false)) {
                this.myClient.notifyVmMirrorExited();
            }
        }
    }
}

