/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Snapshot
implements Comparable<Snapshot> {
    @NotNull
    private final Path myDirectory;
    @NotNull
    private final String myName;

    Snapshot(@NotNull Path directory, @NotNull FileSystem fileSystem) {
        this(directory, directory.equals(Snapshot.defaultBoot(fileSystem)) ? "Quickboot" : directory.toString());
    }

    Snapshot(@NotNull Path directory, @NotNull String name) {
        this.myDirectory = directory;
        this.myName = name;
    }

    @NotNull
    static Snapshot quickboot(@NotNull FileSystem fileSystem) {
        return new Snapshot(Snapshot.defaultBoot(fileSystem), "Quickboot");
    }

    @NotNull
    @VisibleForTesting
    static Path defaultBoot(@NotNull FileSystem fileSystem) {
        return fileSystem.getPath("default_boot", new String[0]);
    }

    @NotNull
    Path getDirectory() {
        return this.myDirectory;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Snapshot)) {
            return false;
        }
        Snapshot snapshot = (Snapshot)object;
        return this.myDirectory.equals(snapshot.myDirectory) && this.myName.equals(snapshot.myName);
    }

    public int hashCode() {
        return Objects.hash(this.myDirectory, this.myName);
    }

    @NotNull
    public String toString() {
        return this.myName;
    }

    @Override
    public int compareTo(@NotNull Snapshot snapshot) {
        return this.myName.compareTo(snapshot.myName);
    }
}

