/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.BooleanTableCellEditor;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialogTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

final class SelectMultipleDevicesDialogTable
extends JBTable {
    SelectMultipleDevicesDialogTable() {
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        this.setDefaultEditor(Boolean.class, new BooleanTableCellEditor());
        this.setRowHeight(JBUI.scale((int)40));
        this.setRowSelectionAllowed(false);
    }

    @NotNull
    List<Device> getSelectedDevices() {
        return IntStream.range(0, this.getRowCount()).filter(this::isSelected).mapToObj(this::getDeviceAt).collect(Collectors.toList());
    }

    void setSelectedDevices(@NotNull Collection<Key> keys) {
        IntStream.range(0, this.getRowCount()).filter(viewRowIndex -> this.getDeviceAt(viewRowIndex).hasKeyContainedBy(keys)).forEach(viewRowIndex -> this.setSelected(true, viewRowIndex));
    }

    boolean isSelected(int viewRowIndex) {
        int modelRowIndex = this.convertRowIndexToModel(viewRowIndex);
        return (Boolean)this.dataModel.getValueAt(modelRowIndex, 0);
    }

    @VisibleForTesting
    void setSelected(boolean selected, int viewRowIndex) {
        this.dataModel.setValueAt(selected, this.convertRowIndexToModel(viewRowIndex), 0);
    }

    @NotNull
    private Device getDeviceAt(int viewRowIndex) {
        return ((SelectMultipleDevicesDialogTableModel)this.dataModel).getDeviceAt(this.convertRowIndexToModel(viewRowIndex));
    }

    @NotNull
    @VisibleForTesting
    List<List<Object>> getData() {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>(1 + this.getRowCount());
        List columnNames = IntStream.range(0, this.getColumnCount()).mapToObj(arg_0 -> this.getColumnName(arg_0)).collect(Collectors.toList());
        data.add(columnNames);
        IntStream.range(0, this.getRowCount()).mapToObj(this::getRowAt).forEach(data::add);
        return data;
    }

    @NotNull
    private List<Object> getRowAt(int viewRowIndex) {
        return IntStream.range(0, this.getColumnCount()).mapToObj(viewColumnIndex -> this.getValueAt(viewRowIndex, viewColumnIndex)).collect(Collectors.toList());
    }

    public void setModel(@NotNull TableModel model2) {
        super.setModel(model2);
        if (this.tableHeader == null) {
            return;
        }
        if (this.getColumnCount() == 0) {
            return;
        }
        this.setSelectedAndIconColumnMaxWidthsToFit();
    }

    private void setSelectedAndIconColumnMaxWidthsToFit() {
        this.setMaxWidthToFit(this.convertColumnIndexToView(0));
        this.setMaxWidthToFit(this.convertColumnIndexToView(1));
    }

    private void setMaxWidthToFit(int viewColumnIndex) {
        OptionalInt maxPreferredWidth = IntStream.range(-1, this.getRowCount()).map(viewRowIndex -> this.getPreferredWidth(viewRowIndex, viewColumnIndex)).max();
        maxPreferredWidth.ifPresent(this.getColumnModel().getColumn(viewColumnIndex)::setMaxWidth);
    }

    private int getPreferredWidth(int viewRowIndex, int viewColumnIndex) {
        Component component;
        if (viewRowIndex == -1) {
            String name = this.getColumnName(viewColumnIndex);
            component = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)((Object)this), name, false, false, -1, viewColumnIndex);
        } else {
            component = this.prepareRenderer(this.getCellRenderer(viewRowIndex, viewColumnIndex), viewRowIndex, viewColumnIndex);
        }
        return component.getPreferredSize().width + JBUI.scale((int)8);
    }

    public void createDefaultColumnsFromModel() {
        while (this.columnModel.getColumnCount() != 0) {
            this.columnModel.removeColumn(this.columnModel.getColumn(0));
        }
        IntStream.range(0, this.dataModel.getColumnCount()).filter(this::notAllValuesEqualEmptyString).mapToObj(TableColumn::new).forEach(arg_0 -> this.addColumn(arg_0));
    }

    private boolean notAllValuesEqualEmptyString(int modelColumnIndex) {
        return !IntStream.range(0, this.dataModel.getRowCount()).mapToObj(modelRowIndex -> this.dataModel.getValueAt(modelRowIndex, modelColumnIndex)).allMatch(Predicate.isEqual(""));
    }
}

