/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.run.deployment.AndroidDebugBridge;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

final class DdmlibAndroidDebugBridge
implements AndroidDebugBridge {
    @NotNull
    private final File myAdb;
    @NotNull
    private final ListeningExecutorService myListeningExecutorService;

    DdmlibAndroidDebugBridge(@NotNull File adb) {
        this.myAdb = adb;
        this.myListeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService());
    }

    @Override
    public boolean isConnected() {
        ListenableFuture<com.android.ddmlib.AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(this.myAdb);
        if (future2.isCancelled()) {
            return false;
        }
        if (!future2.isDone()) {
            return false;
        }
        try {
            return ((com.android.ddmlib.AndroidDebugBridge)future2.get()).isConnected();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException exception) {
            Logger.getInstance(DdmlibAndroidDebugBridge.class).warn((Throwable)exception);
            return false;
        }
    }

    @Override
    @NotNull
    public ListenableFuture<Collection<IDevice>> getConnectedDevices() {
        return FluentFuture.from(AdbService.getInstance().getDebugBridge(this.myAdb)).transform(com.android.ddmlib.AndroidDebugBridge::getDevices, (Executor)this.myListeningExecutorService).transform(Arrays::asList, (Executor)this.myListeningExecutorService);
    }

    @Override
    @NotNull
    public ListenableFuture<String> getVirtualDeviceId(@NotNull IDevice virtualDevice) {
        return com.android.ddmlib.AndroidDebugBridge.getVirtualDeviceId((ListeningExecutorService)this.myListeningExecutorService, (File)this.myAdb, (IDevice)virtualDevice);
    }
}

