/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity.manifest;

import com.android.tools.idea.run.activity.manifest.XmlNode;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlEndElementChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class BinaryXmlParser {
    @NotNull
    public static XmlNode parse(@NotNull InputStream inputStream) throws IOException {
        BinaryResourceFile file2 = BinaryResourceFile.fromInputStream((InputStream)inputStream);
        List chunks = file2.getChunks();
        Stack<XmlNode> nodes = new Stack<XmlNode>();
        if (chunks.isEmpty()) {
            throw new IllegalArgumentException("Invalid Binary XML, no chunks found");
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            throw new IllegalArgumentException("Invalid Binary XML, chunk[0] != XmlChunk");
        }
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        XmlNode node2 = new XmlNode();
        nodes.push(node2);
        for (Chunk chunk : xmlChunk.getChunks().values()) {
            if (chunk instanceof XmlStartElementChunk) {
                XmlStartElementChunk c = (XmlStartElementChunk)chunk;
                XmlNode child = new XmlNode(c, c.getName());
                node2.childs().add(child);
                nodes.push(node2);
                node2 = child;
                continue;
            }
            if (!(chunk instanceof XmlEndElementChunk)) continue;
            node2 = (XmlNode)nodes.pop();
        }
        if (node2.childs().isEmpty()) {
            throw new IllegalStateException("Cannot parse binary XML without root node");
        }
        return node2.childs().get(0);
    }
}

