/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.InstallResult;
import com.android.tools.idea.run.RetryingInstallerResult;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class RetryingInstaller {
    private final IDevice myDevice;
    private final Installer myInstaller;
    private final String myApplicationId;
    private final ConsolePrinter myPrinter;
    private final LaunchStatus myLaunchStatus;
    private final Prompter myPrompter;

    public RetryingInstaller(@NotNull Project project, @NotNull IDevice device, @NotNull Installer installer, @NotNull String applicationId2, @NotNull ConsolePrinter printer, @NotNull LaunchStatus launchStatus) {
        this(device, installer, applicationId2, new UserPrompter(project), printer, launchStatus);
    }

    @VisibleForTesting
    public RetryingInstaller(@NotNull IDevice device, @NotNull Installer installer, @NotNull String applicationId2, @NotNull Prompter prompter, @NotNull ConsolePrinter printer, @NotNull LaunchStatus launchStatus) {
        this.myDevice = device;
        this.myInstaller = installer;
        this.myApplicationId = applicationId2;
        this.myPrompter = prompter;
        this.myPrinter = printer;
        this.myLaunchStatus = launchStatus;
    }

    @NotNull
    public RetryingInstallerResult install() {
        InstallResult result2 = null;
        boolean retry = true;
        int retryCount = 0;
        StopWatch totalDuration = new StopWatch();
        StopWatch lastInstallDuration = new StopWatch();
        block12: while (!this.myLaunchStatus.isLaunchTerminated() && retry) {
            ++retryCount;
            lastInstallDuration.restart();
            result2 = this.myInstaller.installApp(this.myDevice, this.myLaunchStatus);
            lastInstallDuration.stop();
            if (result2.installOutput != null) {
                if (result2.failureCode == InstallResult.FailureCode.NO_ERROR) {
                    this.myPrinter.stdout(result2.installOutput);
                } else {
                    this.myPrinter.stderr(result2.installOutput);
                }
            }
            switch (result2.failureCode) {
                case DEVICE_NOT_RESPONDING: {
                    int waitTime = 2;
                    this.myPrinter.stdout("Device is not ready. Waiting for " + waitTime + " seconds.");
                    try {
                        TimeUnit.SECONDS.sleep(waitTime);
                    }
                    catch (InterruptedException e) {
                        Logger.getInstance(RetryingInstaller.class).info((Throwable)e);
                    }
                    retry = true;
                    continue block12;
                }
                case INSTALL_FAILED_VERSION_DOWNGRADE: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.version.downgrade", new Object[0]));
                    retry = this.myPrompter.showQuestionPrompt(reason) && this.uninstallPackage(this.myDevice, this.myApplicationId);
                    continue block12;
                }
                case INSTALL_FAILED_UPDATE_INCOMPATIBLE: 
                case INCONSISTENT_CERTIFICATES: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.different.signature", new Object[0]));
                    retry = this.myPrompter.showQuestionPrompt(reason) && this.uninstallPackage(this.myDevice, this.myApplicationId);
                    continue block12;
                }
                case INSTALL_FAILED_DEXOPT: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.dexopt", new Object[0]));
                    retry = this.myPrompter.showQuestionPrompt(reason) && this.uninstallPackage(this.myDevice, this.myApplicationId);
                    continue block12;
                }
                case NO_CERTIFICATE: {
                    this.myPrinter.stderr(AndroidBundle.message("deployment.failed.no.certificates.explanation", new Object[0]));
                    this.myPrompter.showErrorMessage(AndroidBundle.message("deployment.failed.no.certificates.explanation", new Object[0]));
                    retry = false;
                    continue block12;
                }
                case INSTALL_FAILED_OLDER_SDK: {
                    String message2 = AndroidBundle.message("deployment.failed.reason.oldersdk", this.myDevice.getVersion().toString());
                    this.myPrinter.stderr(message2);
                    retry = false;
                    continue block12;
                }
                case DEVICE_NOT_FOUND: {
                    String reason = AndroidBundle.message("deployment.failed.reason.devicedisconnected", this.myDevice.getName());
                    this.myPrompter.showErrorMessage(reason);
                    retry = false;
                    continue block12;
                }
                case UNTYPED_ERROR: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.generic.text", result2.failureMessage);
                    retry = this.myPrompter.showQuestionPrompt(reason) && this.uninstallPackage(this.myDevice, this.myApplicationId);
                    continue block12;
                }
            }
            retry = false;
        }
        totalDuration.stop();
        return new RetryingInstallerResult(result2 != null && result2.failureCode == InstallResult.FailureCode.NO_ERROR, retryCount, totalDuration.getDuration(), lastInstallDuration.getDuration());
    }

    private boolean uninstallPackage(@NotNull IDevice device, @NotNull String packageName) {
        String output;
        this.myPrinter.stdout("$ adb shell pm uninstall " + packageName);
        try {
            output = device.uninstallPackage(packageName);
        }
        catch (InstallException e) {
            return false;
        }
        if (output != null) {
            this.myPrinter.stderr(output);
            return false;
        }
        return true;
    }

    public static class UserPrompter
    implements Prompter {
        private final Project myProject;

        public UserPrompter(@NotNull Project project) {
            this.myProject = project;
        }

        @Override
        public boolean showQuestionPrompt(@NotNull String message2) {
            return (Boolean)UIUtil.invokeAndWaitIfNeeded(() -> {
                int result2 = Messages.showOkCancelDialog((Project)this.myProject, (String)message2, (String)AndroidBundle.message("deployment.failed.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                return result2 == 0;
            });
        }

        @Override
        public void showErrorMessage(@NotNull String message2) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)message2, (String)AndroidBundle.message("deployment.failed.title", new Object[0])));
        }
    }

    public static interface Prompter {
        public boolean showQuestionPrompt(@NotNull String var1);

        public void showErrorMessage(@NotNull String var1);
    }

    public static interface Installer {
        @NotNull
        public InstallResult installApp(@NotNull IDevice var1, @NotNull LaunchStatus var2);
    }
}

