/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.AndroidDevice;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibility {
    @NonNls
    private static final String GOOGLE_APIS_TARGET_NAME = "Google APIs";
    private final ThreeState myCompatible;
    private final String myReason;
    public static final LaunchCompatibility YES = new LaunchCompatibility(ThreeState.YES, null);

    public LaunchCompatibility(ThreeState compatible, @Nullable String reason) {
        this.myCompatible = compatible;
        this.myReason = reason;
    }

    public LaunchCompatibility combine(@NotNull LaunchCompatibility other) {
        if (this.myCompatible == ThreeState.NO) {
            return this;
        }
        if (other.myCompatible == ThreeState.NO) {
            return other;
        }
        if (this.myCompatible == ThreeState.UNSURE) {
            return this;
        }
        return other;
    }

    public ThreeState isCompatible() {
        return this.myCompatible;
    }

    @Nullable
    public String getReason() {
        return this.myReason;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("compatible", (Object)this.myCompatible).add("reason", (Object)this.myReason).toString();
    }

    public boolean equals(Object o) {
        return o instanceof LaunchCompatibility && this.myCompatible == ((LaunchCompatibility)o).myCompatible && Objects.equal((Object)this.myReason, (Object)((LaunchCompatibility)o).myReason);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myCompatible, this.myReason});
    }

    @NotNull
    public static LaunchCompatibility canRunOnDevice(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget projectTarget, @NotNull AndroidFacet facet2, Function<AndroidFacet, EnumSet<IDevice.HardwareFeature>> getRequiredHardwareFeatures, @NotNull Set<String> supportedAbis, @NotNull AndroidDevice device) {
        EnumSet requiredFeatures;
        AndroidVersion deviceVersion = device.getVersion();
        if (!deviceVersion.equals((Object)AndroidVersion.DEFAULT) && !deviceVersion.canRun(minSdkVersion2)) {
            String reason = String.format("minSdk(%1$s) %3$s deviceSdk(%2$s)", minSdkVersion2, deviceVersion, minSdkVersion2.getCodename() == null ? ">" : "!=");
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        try {
            requiredFeatures = (EnumSet)getRequiredHardwareFeatures.fun((Object)facet2);
        }
        catch (IndexNotReadyException e) {
            return new LaunchCompatibility(ThreeState.UNSURE, "Required features are unsure because indices are not ready.");
        }
        for (Object feature : requiredFeatures) {
            if (device.supportsFeature((IDevice.HardwareFeature)feature)) continue;
            return new LaunchCompatibility(ThreeState.NO, "missing feature: " + feature);
        }
        if (device.supportsFeature(IDevice.HardwareFeature.WATCH) && !requiredFeatures.contains(IDevice.HardwareFeature.WATCH)) {
            return new LaunchCompatibility(ThreeState.NO, "missing uses-feature watch, non-watch apks cannot be launched on a watch");
        }
        if (!supportedAbis.isEmpty()) {
            LinkedHashSet deviceAbis = Sets.newLinkedHashSet();
            for (Abi abi : device.getAbis()) {
                deviceAbis.add(abi.toString());
            }
            if (Sets.intersection(supportedAbis, (Set)deviceAbis).isEmpty()) {
                return new LaunchCompatibility(ThreeState.NO, "Device supports " + Joiner.on((String)", ").join((Iterable)deviceAbis) + ", but APK only supports " + Joiner.on((String)", ").join(supportedAbis));
            }
        }
        if (projectTarget.isPlatform()) {
            return YES;
        }
        List additionalLibs = projectTarget.getAdditionalLibraries();
        if (additionalLibs.isEmpty()) {
            return YES;
        }
        String targetName = projectTarget.getName();
        if (GOOGLE_APIS_TARGET_NAME.equals(targetName)) {
            return YES;
        }
        return new LaunchCompatibility(ThreeState.UNSURE, "unsure if device supports addon: " + targetName);
    }

    private static LaunchCompatibility isCompatibleAddonAvd(IAndroidTarget projectTarget, ISystemImage image) {
        if (!StringUtil.equals((CharSequence)projectTarget.getVendor(), (CharSequence)image.getAddonVendor().getDisplay())) {
            String reason = String.format("AVD vendor (%1$s) != AVD target (%2$s)", image.getAddonVendor().getDisplay(), projectTarget.getVendor());
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        if (!StringUtil.equals((CharSequence)projectTarget.getName(), (CharSequence)image.getTag().getDisplay())) {
            String reason = String.format("AVD target name (%1$s) != Project target name (%2$s)", image.getTag().getDisplay(), projectTarget.getName());
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        return YES;
    }

    @NotNull
    public static LaunchCompatibility canRunOnAvd(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget projectTarget, @NotNull ISystemImage image) {
        AndroidVersion avdVersion = image.getAndroidVersion();
        if (!avdVersion.canRun(minSdkVersion2)) {
            String reason = String.format("minSdk(%1$s) %3$s deviceSdk(%2$s)", minSdkVersion2, avdVersion, minSdkVersion2.getCodename() == null ? ">" : "!=");
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        return projectTarget.isPlatform() ? YES : LaunchCompatibility.isCompatibleAddonAvd(projectTarget, image);
    }
}

