/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatUtils;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationLogListener
implements AndroidLogcatService.LogcatListener {
    @Nullable
    private LogCatHeader myActiveHeader;
    @NotNull
    private final String myPackageName;
    private final int myPid;

    public ApplicationLogListener(@NotNull String packageName, int pid) {
        this.myPackageName = packageName;
        this.myPid = pid;
    }

    @Override
    public void onLogLineReceived(@NotNull LogCatMessage line2) {
        String message2;
        if (!this.myPackageName.equals(line2.getHeader().getAppName()) || this.myPid != line2.getHeader().getPid()) {
            this.myActiveHeader = null;
            return;
        }
        if (!line2.getHeader().equals((Object)this.myActiveHeader)) {
            this.myActiveHeader = line2.getHeader();
            message2 = this.formatLogLine(line2);
        } else {
            message2 = AndroidLogcatFormatter.CONTINUATION_INDENT + line2.getMessage();
        }
        Key key = AndroidLogcatUtils.getProcessOutputType(this.myActiveHeader.getLogLevel());
        this.notifyTextAvailable(message2 + "\n", key);
    }

    protected abstract String formatLogLine(@NotNull LogCatMessage var1);

    protected abstract void notifyTextAvailable(@NotNull String var1, @NotNull Key var2);
}

