/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.output.LogcatOutputSettings;
import com.android.tools.idea.run.ApplicationLogListener;
import com.android.tools.idea.run.TextEmitter;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class AndroidLogcatOutputCapture
implements AutoCloseable {
    private static final String SIMPLE_FORMAT = AndroidLogcatFormatter.createCustomFormat(false, false, false, true);
    private static final Logger LOG = Logger.getInstance(AndroidLogcatOutputCapture.class);
    @NotNull
    private final Map<IDevice, AndroidLogcatService.LogcatListener> myLogListeners = new HashMap<IDevice, AndroidLogcatService.LogcatListener>();
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final TextEmitter myTextEmitter;

    public AndroidLogcatOutputCapture(@NotNull TextEmitter textEmitter) {
        this.myTextEmitter = textEmitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCapture(@NotNull IDevice device, int pid, @NotNull String applicationId2) {
        AndroidLogcatService.LogcatListener previousListener;
        if (!((Boolean)StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!LogcatOutputSettings.getInstance().isRunOutputEnabled()) {
            return;
        }
        LOG.info(String.format("startCapture(\"%s\")", device.getName()));
        MyLogcatListener logListener = new MyLogcatListener(applicationId2, pid, device, this.myTextEmitter);
        AndroidLogcatService.getInstance().addListener(device, logListener, true);
        Object object = this.myLock;
        synchronized (object) {
            previousListener = this.myLogListeners.put(device, logListener);
            MyLogcatListener.setShowDeviceName(this.myLogListeners.size() > 1);
        }
        if (previousListener != null) {
            LOG.warn(String.format("The device \"%s\" already has a registered logcat listener for application \"%s\". Removing it", device.getName(), applicationId2));
            AndroidLogcatService.getInstance().removeListener(device, previousListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCapture(@NotNull IDevice device) {
        AndroidLogcatService.LogcatListener previousListener;
        LOG.info(String.format("stopCapture(\"%s\")", device.getName()));
        Object object = this.myLock;
        synchronized (object) {
            previousListener = this.myLogListeners.remove(device);
            MyLogcatListener.setShowDeviceName(this.myLogListeners.size() > 1);
        }
        if (previousListener != null) {
            AndroidLogcatService.getInstance().removeListener(device, previousListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>> listeners;
        LOG.info("stopAll()");
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            listeners = new ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>>(this.myLogListeners.entrySet());
            this.myLogListeners.clear();
            MyLogcatListener.setShowDeviceName(false);
        }
        for (Map.Entry entry : listeners) {
            AndroidLogcatService.getInstance().removeListener((IDevice)entry.getKey(), (AndroidLogcatService.LogcatListener)entry.getValue());
        }
    }

    @Override
    public void close() {
        this.stopAll();
    }

    private static final class MyLogcatListener
    extends ApplicationLogListener {
        private static AtomicBoolean ourShowDeviceName = new AtomicBoolean(false);
        private final AndroidLogcatFormatter myFormatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), new AndroidLogcatPreferences());
        private final IShellEnabledDevice myDevice;
        private final AtomicBoolean myIsFirstMessage;
        private final TextEmitter myTextEmitter;

        private MyLogcatListener(@NotNull String packageName, int pid, @NotNull IDevice device, @NotNull TextEmitter emitter) {
            super(packageName, pid);
            this.myDevice = device;
            this.myIsFirstMessage = new AtomicBoolean(true);
            this.myTextEmitter = emitter;
        }

        public static void setShowDeviceName(boolean showDeviceName) {
            ourShowDeviceName.set(showDeviceName);
        }

        @Override
        protected String formatLogLine(@NotNull LogCatMessage line2) {
            String message2 = this.myFormatter.formatMessage(SIMPLE_FORMAT, line2.getHeader(), line2.getMessage());
            if (ourShowDeviceName.get()) {
                return '[' + this.myDevice.getName() + "]: " + message2;
            }
            return message2;
        }

        @Override
        protected void notifyTextAvailable(@NotNull String message2, @NotNull Key key) {
            if (this.myIsFirstMessage.compareAndSet(true, false)) {
                this.myTextEmitter.emit("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.\n", ProcessOutputTypes.STDOUT);
            }
            this.myTextEmitter.emit(message2, key);
        }
    }
}

