/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.projectmodel.ExternalLibrary;
import com.android.tools.idea.AndroidProjectModelUtils;
import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.AarResourceRepositoryCache;
import com.android.tools.idea.res.AllResourceRepository;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.res.TestAppResourceRepository;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceRepositoryManager
implements Disposable {
    private static final Key<ResourceRepositoryManager> KEY = Key.create((String)ResourceRepositoryManager.class.getName());
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private static final Object TEST_RESOURCES_LOCK = new Object();
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final Namespacing myNamespacing;
    @Nullable
    private ResourceNamespace mySharedNamespaceInstance;
    @Nullable
    private ResourceNamespace mySharedTestNamespaceInstance;
    private AppResourceRepository myAppResources;
    private ProjectResourceRepository myProjectResources;
    private LocalResourceRepository myModuleResources;
    private LocalResourceRepository myTestAppResources;
    private LocalResourceRepository myTestModuleResources;
    private CachedValue<LocalesAndLanguages> myLocalesAndLanguages;
    private Map<ExternalLibrary, AarResourceRepository> myLibraryResourceMap;
    @Nullable
    private ResourceVisibilityLookup.Provider myResourceVisibilityProvider;
    private final Object myLibraryLock = new Object();

    @NotNull
    public static ResourceRepositoryManager getInstance(@NotNull AndroidFacet facet2) {
        ResourceRepositoryManager manager;
        Namespacing namespacing = AndroidProjectModelUtils.getNamespacing(facet2);
        ResourceRepositoryManager instance = (ResourceRepositoryManager)facet2.getUserData(KEY);
        if (instance != null && instance.myNamespacing != namespacing) {
            if (facet2.replace(KEY, (Object)instance, null)) {
                Disposer.dispose((Disposable)instance);
            }
            instance = null;
        }
        if (instance == null && (instance = (ResourceRepositoryManager)facet2.putUserDataIfAbsent(KEY, (Object)(manager = new ResourceRepositoryManager(facet2, namespacing)))) == manager) {
            Disposer.register((Disposable)facet2, (Disposable)instance);
            AndroidProjectRootListener.ensureSubscribed(manager.getProject());
        }
        return instance;
    }

    @Nullable
    public static ResourceRepositoryManager getInstance(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 == null ? null : ResourceRepositoryManager.getInstance(facet2);
    }

    @Nullable
    public static ResourceRepositoryManager getInstance(@NotNull PsiElement element2) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
        if (module2 == null) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return null;
        }
        return ResourceRepositoryManager.getInstance(facet2);
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getAppResources(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null ? ResourceRepositoryManager.getAppResources(facet2) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getAppResources(@NotNull AndroidFacet facet2) {
        return ResourceRepositoryManager.getInstance(facet2).getAppResources();
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getProjectResources(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null ? ResourceRepositoryManager.getProjectResources(facet2) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getProjectResources(@NotNull AndroidFacet facet2) {
        return ResourceRepositoryManager.getInstance(facet2).getProjectResources();
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null ? ResourceRepositoryManager.getModuleResources(facet2) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getModuleResources(@NotNull AndroidFacet facet2) {
        return ResourceRepositoryManager.getInstance(facet2).getModuleResources();
    }

    private ResourceRepositoryManager(@NotNull AndroidFacet facet2, @NotNull Namespacing namespacing) {
        this.myFacet = facet2;
        this.myNamespacing = namespacing;
    }

    public static boolean testAndClearTempResourceCached(@NotNull Project project) {
        if (project.getUserData(AppResourceRepository.TEMPORARY_RESOURCE_CACHE) != Boolean.TRUE) {
            return false;
        }
        project.putUserData(AppResourceRepository.TEMPORARY_RESOURCE_CACHE, null);
        return true;
    }

    @NotNull
    public static Collection<IdeLibrary> findAarLibraries(@NotNull AndroidFacet facet2) {
        AndroidModuleModel androidModel;
        ArrayList<IdeLibrary> libraries = new ArrayList<IdeLibrary>();
        if (AndroidModel.isRequired(facet2) && (androidModel = AndroidModuleModel.get(facet2)) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet2.getModule(), true);
            ResourceRepositoryManager.addGradleLibraries(libraries, androidModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                ResourceRepositoryManager.addGradleLibraries(libraries, dependentGradleModel);
            }
        }
        return libraries;
    }

    private static void addGradleLibraries(@NotNull List<IdeLibrary> list, @NotNull AndroidModuleModel androidModuleModel) {
        list.addAll(androidModuleModel.getSelectedMainCompileLevel2Dependencies().getAndroidLibraries());
    }

    @Nullable
    public ResourceRepository getAllResources() {
        ResourceRepository frameworkResources = this.getFrameworkResources(Collections.emptySet());
        return frameworkResources == null ? null : new AllResourceRepository((ResourceRepository)this.getAppResources(), frameworkResources);
    }

    @Slow
    @NotNull
    public LocalResourceRepository getAppResources() {
        LocalResourceRepository appResources = this.getExistingAppResources();
        if (appResources != null) {
            return appResources;
        }
        this.getLibraryResources();
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = APP_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myAppResources = AppResourceRepository.create(this.myFacet, this.getLibraryResources());
                    Disposer.register((Disposable)this, (Disposable)this.myAppResources);
                }
                return this.myAppResources;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getExistingAppResources() {
        Object object = APP_RESOURCES_LOCK;
        synchronized (object) {
            return this.myAppResources;
        }
    }

    @Slow
    @NotNull
    public LocalResourceRepository getProjectResources() {
        LocalResourceRepository projectResources = this.getExistingProjectResources();
        if (projectResources != null) {
            return projectResources;
        }
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = PROJECT_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myProjectResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myProjectResources = ProjectResourceRepository.create(this.myFacet);
                    Disposer.register((Disposable)this, (Disposable)this.myProjectResources);
                }
                return this.myProjectResources;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getExistingProjectResources() {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            return this.myProjectResources;
        }
    }

    @Slow
    @NotNull
    public LocalResourceRepository getModuleResources() {
        LocalResourceRepository moduleResources = this.getExistingModuleResources();
        if (moduleResources != null) {
            return moduleResources;
        }
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = MODULE_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myModuleResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myModuleResources = ModuleResourceRepository.forMainResources(this.myFacet, this.getNamespace());
                    ResourceRepositoryManager.registerIfDisposable(this, (Object)this.myModuleResources);
                }
                return this.myModuleResources;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getExistingModuleResources() {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            return this.myModuleResources;
        }
    }

    @NotNull
    public LocalResourceRepository getTestAppResources() {
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getTestNamespace());
                    }
                    this.myTestAppResources = this.computeTestAppResources();
                    ResourceRepositoryManager.registerIfDisposable(this, (Object)this.myTestAppResources);
                }
                return this.myTestAppResources;
            }
        }));
    }

    @NotNull
    public LocalResourceRepository getTestModuleResources() {
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestModuleResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getTestNamespace());
                    }
                    this.myTestModuleResources = ModuleResourceRepository.forTestResources(this.myFacet, this.getTestNamespace());
                    ResourceRepositoryManager.registerIfDisposable(this, (Object)this.myTestModuleResources);
                }
                return this.myTestModuleResources;
            }
        }));
    }

    @NotNull
    private LocalResourceRepository computeTestAppResources() {
        LocalResourceRepository moduleTestResources = this.getTestModuleResources();
        AndroidModuleModel model2 = AndroidModuleModel.get(this.myFacet);
        if (model2 == null) {
            return moduleTestResources;
        }
        return TestAppResourceRepository.create(this.myFacet, moduleTestResources, model2);
    }

    @Slow
    @Nullable
    public ResourceRepository getFrameworkResources(@NotNull Set<String> languages2) {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(this.myFacet.getModule());
        if (androidPlatform == null) {
            return null;
        }
        return androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget()).getFrameworkResources(languages2);
    }

    @Slow
    @NotNull
    public List<ResourceRepository> getAppResourcesForNamespace(@NotNull ResourceNamespace namespace) {
        AppResourceRepository appRepository = (AppResourceRepository)this.getAppResources();
        if (this.myNamespacing == Namespacing.DISABLED) {
            return ImmutableList.of((Object)((Object)appRepository));
        }
        return ImmutableList.copyOf(appRepository.getRepositoriesForNamespace(namespace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResources() {
        this.resetVisibility();
        this.resetLibraries();
        SampleDataResourceRepository.SampleDataRepositoryManager.getInstance(this.myFacet).reset();
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources != null) {
                ResourceRepositoryManager.disposeIfDisposable((Object)this.myModuleResources);
                this.myModuleResources = null;
            }
        }
        object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources != null) {
                Disposer.dispose((Disposable)this.myProjectResources);
                this.myProjectResources = null;
                this.myLocalesAndLanguages = null;
            }
        }
        object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources != null) {
                Disposer.dispose((Disposable)this.myAppResources);
                this.myAppResources = null;
            }
        }
        object = TEST_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myTestAppResources != null) {
                ResourceRepositoryManager.disposeIfDisposable((Object)this.myTestAppResources);
                this.myTestAppResources = null;
            }
            if (this.myTestModuleResources != null) {
                ResourceRepositoryManager.disposeIfDisposable((Object)this.myTestModuleResources);
                this.myTestModuleResources = null;
            }
        }
    }

    private static void disposeIfDisposable(@NotNull Object object) {
        if (object instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)object));
        }
    }

    private static void registerIfDisposable(@NotNull Disposable parent, @NotNull Object object) {
        if (object instanceof Disposable) {
            Disposer.register((Disposable)parent, (Disposable)((Disposable)object));
        }
    }

    public void dispose() {
    }

    public void resetAllCaches() {
        this.resetResources();
        ConfigurationManager.getOrCreateInstance(this.myFacet.getModule()).getResolverCache().reset();
        ResourceFolderRegistry.getInstance(this.getProject()).reset();
        AarResourceRepositoryCache.getInstance().clear();
    }

    @NotNull
    private Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetVisibility() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            this.myResourceVisibilityProvider = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLibraries() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            this.myLibraryResourceMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRootsAndLibraries() {
        block8: {
            try {
                Map<ExternalLibrary, AarResourceRepository> oldLibraryResourceMap;
                this.resetVisibility();
                ProjectResourceRepository projectResources = (ProjectResourceRepository)this.getExistingProjectResources();
                AppResourceRepository appResources = (AppResourceRepository)this.getExistingAppResources();
                if (projectResources != null) {
                    projectResources.updateRoots();
                }
                Object object = this.myLibraryLock;
                synchronized (object) {
                    oldLibraryResourceMap = this.myLibraryResourceMap;
                    this.myLibraryResourceMap = null;
                }
                if (appResources != null) {
                    appResources.updateRoots(this.getLibraryResources());
                }
                if (oldLibraryResourceMap != null) {
                    oldLibraryResourceMap.size();
                }
            }
            catch (IllegalStateException e) {
                if (this.myFacet.isDisposed()) break block8;
                throw e;
            }
        }
    }

    @NotNull
    public Namespacing getNamespacing() {
        return this.myNamespacing;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        if (this.myNamespacing == Namespacing.DISABLED) {
            return ResourceNamespace.RES_AUTO;
        }
        String packageName = AndroidManifestUtils.getPackageName(this.myFacet);
        if (packageName == null) {
            return ResourceNamespace.RES_AUTO;
        }
        if (this.mySharedNamespaceInstance == null || !packageName.equals(this.mySharedNamespaceInstance.getPackageName())) {
            this.mySharedNamespaceInstance = ResourceNamespace.fromPackageName((String)packageName);
        }
        return this.mySharedNamespaceInstance;
    }

    @NotNull
    public ResourceNamespace getTestNamespace() {
        if (this.myNamespacing == Namespacing.DISABLED) {
            return ResourceNamespace.RES_AUTO;
        }
        String testPackageName = AndroidManifestUtils.getTestPackageName(this.myFacet);
        if (testPackageName == null) {
            return ResourceNamespace.RES_AUTO;
        }
        if (this.mySharedTestNamespaceInstance == null || !testPackageName.equals(this.mySharedTestNamespaceInstance.getPackageName())) {
            this.mySharedTestNamespaceInstance = ResourceNamespace.fromPackageName((String)testPackageName);
        }
        return this.mySharedTestNamespaceInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            if (this.myResourceVisibilityProvider == null) {
                if (!AndroidModel.isRequired(this.myFacet) || AndroidModel.get(this.myFacet) == null) {
                    return null;
                }
                this.myResourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
            }
            return this.myResourceVisibilityProvider;
        }
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility() {
        ResourceVisibilityLookup.Provider provider2;
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel != null && (provider2 = this.getResourceVisibilityProvider()) != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            IdeVariant variant2 = androidModel.getSelectedVariant();
            return provider2.get(androidProject, variant2);
        }
        return ResourceVisibilityLookup.NONE;
    }

    @Slow
    @NotNull
    public Collection<VirtualFile> getAllResourceDirs() {
        return ((AppResourceRepository)this.getAppResources()).getAllResourceDirs();
    }

    @Nullable
    public AarResourceRepository findLibraryResources(@NotNull ExternalLibrary library) {
        return this.getLibraryResourceMap().get(library);
    }

    @Slow
    @NotNull
    public Collection<AarResourceRepository> getLibraryResources() {
        return this.getLibraryResourceMap().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<ExternalLibrary, AarResourceRepository> getLibraryResourceMap() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            if (this.myLibraryResourceMap == null) {
                this.myLibraryResourceMap = this.computeLibraryResourceMap();
            }
            return this.myLibraryResourceMap;
        }
    }

    @NotNull
    private Map<ExternalLibrary, AarResourceRepository> computeLibraryResourceMap() {
        Collection<ExternalLibrary> libraries = AndroidProjectModelUtils.findDependenciesWithResources(this.myFacet.getModule()).values();
        AarResourceRepositoryCache aarResourceRepositoryCache = AarResourceRepositoryCache.getInstance();
        Function<ExternalLibrary, AarResourceRepository> factory2 = this.myNamespacing == Namespacing.DISABLED ? aarResourceRepositoryCache::getSourceRepository : aarResourceRepositoryCache::getProtoRepository;
        ExecutorService executor = AndroidIoManager.getInstance().getBackgroundDiskIoExecutor();
        HashMap futures2 = Maps.newHashMapWithExpectedSize((int)libraries.size());
        for (ExternalLibrary library : libraries) {
            futures2.put(library, executor.submit(() -> (AarResourceRepository)factory2.apply(library)));
        }
        ImmutableMap.Builder map2 = ImmutableMap.builder();
        for (Map.Entry entry : futures2.entrySet()) {
            try {
                map2.put(entry.getKey(), ((Future)entry.getValue()).get());
            }
            catch (ExecutionException e) {
                ResourceRepositoryManager.cancelPendingTasks(futures2.values());
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new UncheckedExecutionException(e.getCause());
            }
            catch (InterruptedException e) {
                ResourceRepositoryManager.cancelPendingTasks(futures2.values());
                throw new ProcessCanceledException((Throwable)e);
            }
        }
        return map2.build();
    }

    private static void cancelPendingTasks(Collection<Future<AarResourceRepository>> futures2) {
        futures2.forEach(f -> f.cancel(true));
    }

    @NotNull
    public ImmutableList<Locale> getLocalesInProject() {
        return this.getLocalesAndLanguages().locales;
    }

    @NotNull
    public ImmutableSortedSet<String> getLanguagesInProject() {
        return this.getLocalesAndLanguages().languages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private LocalesAndLanguages getLocalesAndLanguages() {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myLocalesAndLanguages == null) {
                this.myLocalesAndLanguages = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                    LocalResourceRepository projectResources = ResourceRepositoryManager.getProjectResources(this.myFacet);
                    SortedSet localeQualifiers = ResourceRepositoryUtil.getLocales((ResourceRepository)projectResources);
                    ImmutableList.Builder localesBuilder = ImmutableList.builderWithExpectedSize((int)localeQualifiers.size());
                    ImmutableSortedSet.Builder languagesBuilder = ImmutableSortedSet.naturalOrder();
                    for (LocaleQualifier localeQualifier : localeQualifiers) {
                        localesBuilder.add((Object)Locale.create(localeQualifier));
                        String language = localeQualifier.getLanguage();
                        if (language == null) continue;
                        languagesBuilder.add((Object)language);
                    }
                    return CachedValueProvider.Result.create((Object)new LocalesAndLanguages((ImmutableList<Locale>)localesBuilder.build(), (ImmutableSortedSet<String>)languagesBuilder.build()), (Object[])new Object[]{projectResources});
                });
            }
            return (LocalesAndLanguages)this.myLocalesAndLanguages.getValue();
        }
    }

    private static class LocalesAndLanguages {
        @NotNull
        final ImmutableList<Locale> locales;
        @NotNull
        final ImmutableSortedSet<String> languages;

        LocalesAndLanguages(@NotNull ImmutableList<Locale> locales, @NotNull ImmutableSortedSet<String> languages2) {
            this.locales = locales;
            this.languages = languages2;
        }
    }
}

