/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.intellij.ProjectTopics;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFolderRegistry
implements Disposable {
    @NotNull
    private Project myProject;
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> myNamespacedCache = ResourceFolderRegistry.buildCache();
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> myNonNamespacedCache = ResourceFolderRegistry.buildCache();
    @NotNull
    private final ImmutableList<Cache<VirtualFile, ResourceFolderRepository>> myCaches = ImmutableList.of(this.myNamespacedCache, this.myNonNamespacedCache);

    public ResourceFolderRegistry(@NotNull Project project) {
        this.myProject = project;
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                ResourceFolderRegistry.this.removeStaleEntries();
            }
        });
    }

    @NotNull
    private static Cache<VirtualFile, ResourceFolderRepository> buildCache() {
        return CacheBuilder.newBuilder().build();
    }

    @NotNull
    public static ResourceFolderRegistry getInstance(@NotNull Project project) {
        return (ResourceFolderRegistry)ServiceManager.getService((Project)project, ResourceFolderRegistry.class);
    }

    @NotNull
    public ResourceFolderRepository get(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir) {
        return (ResourceFolderRepository)ReadAction.compute(() -> this.get(facet2, dir, ResourceRepositoryManager.getInstance(facet2).getNamespace()));
    }

    @VisibleForTesting
    @NotNull
    ResourceFolderRepository get(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        Cache<VirtualFile, ResourceFolderRepository> cache = namespace == ResourceNamespace.RES_AUTO ? this.myNonNamespacedCache : this.myNamespacedCache;
        ResourceFolderRepository repository = (ResourceFolderRepository)CacheUtils.getAndUnwrap(cache, (Object)dir, () -> ResourceFolderRegistry.createRepository(facet2, dir, namespace));
        assert (repository.getNamespace().equals((Object)namespace));
        return repository;
    }

    @NotNull
    private static ResourceFolderRepository createRepository(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        ResourceFolderRepositoryCachingData cachingData = ResourceFolderRepositoryFileCacheService.get().getCachingData(facet2.getModule().getProject(), dir, AndroidIoManager.getInstance().getBackgroundDiskIoExecutor());
        return ResourceFolderRepository.create(facet2, dir, namespace, cachingData);
    }

    @Nullable
    public CachedRepositories getCached(@NotNull VirtualFile directory) {
        ResourceFolderRepository namespaced = (ResourceFolderRepository)this.myNamespacedCache.getIfPresent((Object)directory);
        ResourceFolderRepository nonNamespaced = (ResourceFolderRepository)this.myNonNamespacedCache.getIfPresent((Object)directory);
        return namespaced == null && nonNamespaced == null ? null : new CachedRepositories(namespaced, nonNamespaced);
    }

    public void reset() {
        this.myNamespacedCache.invalidateAll();
        this.myNonNamespacedCache.invalidateAll();
    }

    private void removeStaleEntries() {
        this.myNamespacedCache.asMap().keySet().removeIf(dir -> this.isStale((VirtualFile)dir));
        this.myNonNamespacedCache.asMap().keySet().removeIf(dir -> this.isStale((VirtualFile)dir));
    }

    private boolean isStale(@NotNull VirtualFile dir) {
        AndroidFacet facet2 = AndroidFacet.getInstance((VirtualFile)dir, (Project)this.myProject);
        if (facet2 == null) {
            return true;
        }
        ResourceFolderManager folderManager = ResourceFolderManager.getInstance(facet2);
        return !folderManager.getFolders().contains(dir) && !folderManager.getTestFolders().contains(dir);
    }

    public void dispose() {
        this.reset();
    }

    void dispatchToRepositories(@NotNull VirtualFile file2, @NotNull BiConsumer<ResourceFolderRepository, VirtualFile> handler2) {
        VirtualFile dir;
        VirtualFile virtualFile = dir = file2.isDirectory() ? file2 : file2.getParent();
        while (dir != null) {
            for (Cache cache : this.myCaches) {
                ResourceFolderRepository repository = (ResourceFolderRepository)cache.getIfPresent((Object)dir);
                if (repository == null) continue;
                handler2.accept(repository, file2);
            }
            dir = dir.getParent();
        }
    }

    public static class CachedRepositories {
        @Nullable
        public final ResourceFolderRepository namespaced;
        @Nullable
        public final ResourceFolderRepository nonNamespaced;

        public CachedRepositories(@Nullable ResourceFolderRepository namespaced, @Nullable ResourceFolderRepository nonNamespaced) {
            this.namespaced = namespaced;
            this.nonNamespaced = nonNamespaced;
        }
    }

    public static class PopulateCachesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        public PopulateCachesTask(@NotNull Project project) {
            super((Object)project);
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (facets.isEmpty()) {
                return;
            }
            indicator.setText("Indexing resources");
            indicator.setIndeterminate(false);
            Map<VirtualFile, AndroidFacet> resDirectories = IdeResourcesUtil.getResourceDirectoriesForFacets(facets);
            if (resDirectories.isEmpty()) {
                return;
            }
            try {
                ResourceFolderRepositoryFileCacheService.get().createDirForProject(this.myProject);
            }
            catch (IOException e) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            assert (!application.isWriteAccessAllowed());
            int numDone = 0;
            ExecutorService parallelExecutor = AndroidIoManager.getInstance().getBackgroundDiskIoExecutor();
            ArrayList<Future<ResourceFolderRepository>> repositoryJobs = new ArrayList<Future<ResourceFolderRepository>>();
            for (Map.Entry<VirtualFile, AndroidFacet> entry : resDirectories.entrySet()) {
                AndroidFacet facet2 = entry.getValue();
                VirtualFile dir = entry.getKey();
                ResourceFolderRegistry registry = ResourceFolderRegistry.getInstance(this.myProject);
                repositoryJobs.add(parallelExecutor.submit(() -> registry.get(facet2, dir)));
            }
            for (Future future2 : repositoryJobs) {
                if (indicator.isCanceled()) break;
                indicator.setFraction((double)numDone / (double)resDirectories.size());
                try {
                    future2.get();
                }
                catch (ExecutionException facet2) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++numDone;
            }
        }
    }
}

