/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AbstractResourceRepositoryWithLocking;
import com.android.tools.idea.res.MultiResourceRepository;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalResourceRepository
extends AbstractResourceRepositoryWithLocking
implements ModificationTracker {
    protected static final AtomicLong ourModificationCounter = new AtomicLong();
    private final String myDisplayName;
    @Nullable
    private List<MultiResourceRepository> myParents;
    private volatile long myGeneration;
    private final Object RESOURCE_DIRS_LOCK = new Object();
    @Nullable
    private Set<VirtualFile> myResourceDirs;

    protected LocalResourceRepository(@NotNull String displayName) {
        this.myDisplayName = displayName;
        this.setModificationCount(ourModificationCounter.incrementAndGet());
    }

    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParent(@NotNull MultiResourceRepository parent) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents == null) {
                this.myParents = new ArrayList<MultiResourceRepository>(2);
            }
            this.myParents.add(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParent(@NotNull MultiResourceRepository parent) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                this.myParents.remove((Object)parent);
            }
        }
    }

    protected void invalidateParentCaches() {
        if (this.myParents != null) {
            for (MultiResourceRepository parent : this.myParents) {
                parent.invalidateCache();
            }
        }
    }

    protected void invalidateParentCaches(@NotNull SingleNamespaceResourceRepository repository, ResourceType ... types2) {
        if (this.myParents != null) {
            for (MultiResourceRepository parent : this.myParents) {
                parent.invalidateCache(repository, types2);
            }
        }
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    protected void setModificationCount(long count) {
        this.myGeneration = count;
    }

    boolean isScanPending(@NotNull PsiFile psiFile2) {
        return false;
    }

    public void sync() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<VirtualFile> getResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        synchronized (object) {
            if (this.myResourceDirs != null) {
                return this.myResourceDirs;
            }
            this.myResourceDirs = this.computeResourceDirs();
            return this.myResourceDirs;
        }
    }

    @NotNull
    protected abstract Set<VirtualFile> computeResourceDirs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        synchronized (object) {
            this.myResourceDirs = null;
        }
        object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                for (LocalResourceRepository localResourceRepository : this.myParents) {
                    localResourceRepository.invalidateResourceDirs();
                }
            }
        }
    }

    @NotNull
    public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nullable
    ListMultimap<String, ResourceItem> getMapPackageAccessible(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        return this.getMap(namespace, type);
    }

    public static final class EmptyRepository
    extends LocalResourceRepository
    implements SingleNamespaceResourceRepository {
        @NotNull
        private final ResourceNamespace myNamespace;

        public EmptyRepository(@NotNull ResourceNamespace namespace) {
            super("");
            this.myNamespace = namespace;
        }

        @Override
        @NotNull
        protected Set<VirtualFile> computeResourceDirs() {
            return Collections.emptySet();
        }

        @Override
        @Nullable
        protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
            return null;
        }

        @NotNull
        public ResourceNamespace getNamespace() {
            return this.myNamespace;
        }

        @Nullable
        public String getPackageName() {
            return this.myNamespace.getPackageName();
        }

        public ResourceVisitor.VisitResult accept(ResourceVisitor visitor2) {
            return ResourceVisitor.VisitResult.CONTINUE;
        }
    }
}

