/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.Gravity;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.CharSequences;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableSet;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawableTransformer {
    private static final ImmutableSet<String> NAMES_OF_HANDLED_ATTRIBUTES = ImmutableSet.of((Object)"width", (Object)"height", (Object)"viewportWidth", (Object)"viewportHeight", (Object)"tint", (Object)"alpha", (Object[])new String[0]);
    private static final String INDENT = "  ";
    private static final String DOUBLE_INDENT = "    ";

    private VectorDrawableTransformer() {
    }

    @NotNull
    public static String transform(@NotNull String originalDrawable, @NotNull Dimension targetSize) {
        return VectorDrawableTransformer.transform(originalDrawable, targetSize, Gravity.CENTER, 1.0, null, null, null, 1.0);
    }

    @NotNull
    public static String transform(@NotNull String originalDrawable, @NotNull Dimension targetSize, @NotNull Gravity gravity, double scaleFactor, @Nullable Rectangle2D clipRectangle, @Nullable Point2D shift, @Nullable Color tint, double opacity) {
        KXmlParser parser = new KXmlParser();
        try {
            int endColumnNumber;
            String prefix;
            int i2;
            double alignmentScale;
            double ratio;
            String alphaValue;
            int token;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)originalDrawable, (boolean)true));
            int startLine = 1;
            int startColumn = 1;
            while ((token = parser.nextToken()) != 1 && token != 2) {
                startLine = parser.getLineNumber();
                startColumn = parser.getColumnNumber();
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return originalDrawable;
            }
            String originalTintValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "tint");
            String tintValue = tint == null ? originalTintValue : IdeResourcesUtil.colorToString(tint);
            String originalAlphaValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "alpha");
            if (originalAlphaValue != null) {
                opacity *= VectorDrawableTransformer.parseDoubleValue(originalAlphaValue, "");
            }
            if ((alphaValue = XmlUtils.formatFloatValue((double)opacity)).equals("1")) {
                alphaValue = null;
            }
            double targetWidth = targetSize.getWidth();
            double targetHeight = targetSize.getHeight();
            double width = targetWidth;
            double height = targetHeight;
            double originalViewportWidth = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportWidth", "");
            double originalViewportHeight = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportHeight", "");
            String widthValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "width");
            if (widthValue != null) {
                String suffix = VectorDrawableTransformer.getSuffix(widthValue);
                width = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "width", suffix);
                height = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "height", suffix);
                if (suffix.equals("dp") && width == targetWidth && height == targetHeight && originalViewportWidth == targetWidth && originalViewportHeight == targetHeight && scaleFactor == 1.0 && clipRectangle == null && Objects.equals(tintValue, originalTintValue) && Objects.equals(alphaValue, originalAlphaValue)) {
                    return originalDrawable;
                }
                if (Double.isNaN(width) || width == 0.0 || Double.isNaN(height) || height == 0.0) {
                    width = targetWidth;
                    height = targetHeight;
                }
            }
            double x = 0.0;
            double y = 0.0;
            if (clipRectangle != null) {
                x += (0.5 - clipRectangle.getCenterX()) * targetWidth * (scaleFactor /= Math.max(clipRectangle.getWidth(), clipRectangle.getHeight()));
                y += (0.5 - clipRectangle.getCenterY()) * targetHeight * scaleFactor;
            }
            if (Double.isNaN(originalViewportWidth) || originalViewportWidth == 0.0 || Double.isNaN(originalViewportHeight) || originalViewportHeight == 0.0) {
                originalViewportWidth = width;
                originalViewportHeight = height;
            }
            if ((ratio = width * originalViewportHeight / (height * originalViewportWidth)) > 1.0) {
                y += 0.5 * targetWidth * ratio;
            } else if (ratio < 1.0) {
                x += 0.5 * targetHeight / ratio;
            }
            x += 0.5 * targetWidth * (1.0 - scaleFactor);
            y += 0.5 * targetHeight * (1.0 - scaleFactor);
            ratio = targetWidth * originalViewportHeight / (targetHeight * originalViewportWidth);
            if (ratio > 1.0) {
                alignmentScale = (double)(gravity.getHorizontalAlignment() + 1) / 2.0;
                x += alignmentScale * targetWidth * (1.0 - 1.0 / ratio) * scaleFactor;
            } else if (ratio < 1.0) {
                alignmentScale = (double)(gravity.getVerticalAlignment() + 1) / 2.0;
                y += alignmentScale * targetHeight * (1.0 - ratio) * scaleFactor;
            }
            scaleFactor *= Math.min(targetWidth / originalViewportWidth, targetHeight / originalViewportHeight);
            if (shift != null) {
                x += targetWidth * shift.getX();
                y += targetHeight * shift.getY();
            }
            StringBuilder result2 = new StringBuilder(originalDrawable.length() + originalDrawable.length() / 8);
            Indenter indenter = new Indenter(originalDrawable);
            indenter.copy(1, 1, startLine, startColumn, "", result2);
            String lineSeparator = VectorDrawableTransformer.detectLineSeparator(originalDrawable);
            result2.append(String.format("<vector %s:%s=\"%s\"", "xmlns", "android", "http://schemas.android.com/apk/res/android"));
            for (i2 = 0; i2 < parser.getNamespaceCount(1); ++i2) {
                prefix = parser.getNamespacePrefix(i2);
                String uri = parser.getNamespaceUri(i2);
                if ("android".equals(prefix) && "http://schemas.android.com/apk/res/android".equals(uri)) continue;
                result2.append(String.format("%s%s%s:%s=\"%s\"", lineSeparator, DOUBLE_INDENT, "xmlns", prefix, uri));
            }
            result2.append(String.format("%s%sandroid:width=\"%sdp\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatValue((double)targetWidth)));
            result2.append(String.format("%s%sandroid:height=\"%sdp\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatValue((double)targetHeight)));
            result2.append(String.format("%s%sandroid:viewportWidth=\"%s\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatValue((double)targetWidth)));
            result2.append(String.format("%s%sandroid:viewportHeight=\"%s\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatValue((double)targetHeight)));
            if (tintValue != null) {
                result2.append(String.format("%s%sandroid:tint=\"%s\"", lineSeparator, DOUBLE_INDENT, tintValue));
            }
            if (alphaValue != null) {
                result2.append(String.format("%s%sandroid:alpha=\"%s\"", lineSeparator, DOUBLE_INDENT, alphaValue));
            }
            for (i2 = 0; i2 < parser.getAttributeCount(); ++i2) {
                prefix = parser.getAttributePrefix(i2);
                String name = parser.getAttributeName(i2);
                if ("android".equals(prefix) && NAMES_OF_HANDLED_ATTRIBUTES.contains((Object)name)) continue;
                if (prefix != null) {
                    name = prefix + ':' + name;
                }
                result2.append(String.format("%s%s%s=\"%s\"", lineSeparator, DOUBLE_INDENT, name, parser.getAttributeValue(i2)));
            }
            result2.append('>');
            String indent = "";
            int copyDepth = 2;
            startLine = parser.getLineNumber();
            startColumn = parser.getColumnNumber();
            String translateX = VectorDrawableTransformer.isSignificantlyDifferentFromZero(x / targetWidth) ? XmlUtils.formatFloatValue((double)x) : null;
            String translateY = VectorDrawableTransformer.isSignificantlyDifferentFromZero(y / targetHeight) ? XmlUtils.formatFloatValue((double)y) : null;
            String scale = XmlUtils.formatFloatValue((double)scaleFactor);
            if (!scale.equals("1") || translateX != null || translateY != null) {
                result2.append(lineSeparator).append(INDENT);
                result2.append("<group");
                String delimiter = " ";
                if (!scale.equals("1")) {
                    result2.append(String.format("%sandroid:scaleX=\"%s\"", delimiter, scale));
                    delimiter = lineSeparator + INDENT + DOUBLE_INDENT;
                    result2.append(String.format("%sandroid:scaleY=\"%s\"", delimiter, scale));
                }
                if (translateX != null) {
                    result2.append(String.format("%sandroid:translateX=\"%s\"", delimiter, translateX));
                    delimiter = lineSeparator + INDENT + DOUBLE_INDENT;
                }
                if (translateY != null) {
                    result2.append(String.format("%sandroid:translateY=\"%s\"", delimiter, translateY));
                }
                result2.append('>');
                indent = INDENT;
            }
            while ((token = parser.nextToken()) != 1 && token != 3 || parser.getDepth() >= copyDepth) {
                int endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, token == 5 ? "" : indent, result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            if (startColumn > INDENT.length() + 1) {
                result2.append(lineSeparator);
                startColumn = 1;
            }
            if (!scale.equals("1") || translateX != null || translateY != null) {
                if (startColumn == 1) {
                    result2.append(INDENT);
                }
                result2.append(String.format("</group>%s", lineSeparator));
            }
            while (token != 1) {
                int endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
                token = parser.nextToken();
            }
            return result2.toString();
        }
        catch (IOException | XmlPullParserException e) {
            return originalDrawable;
        }
    }

    public static String merge(@NotNull String drawable1, @NotNull String drawable2) {
        KXmlParser parser = new KXmlParser();
        try {
            int endColumnNumber;
            int endLineNumber;
            int token;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)drawable1, (boolean)true));
            while ((token = parser.nextToken()) != 1 && token != 2) {
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return drawable1;
            }
            StringBuilder result2 = new StringBuilder(drawable1.length() + drawable2.length());
            Indenter indenter = new Indenter(drawable1);
            int startLine = 1;
            int startColumn = 1;
            while ((token = parser.nextToken()) != 1 && token != 3 || parser.getDepth() > 1) {
                endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            parser.setInput((Reader)CharSequences.getReader((CharSequence)drawable2, (boolean)true));
            while ((token = parser.nextToken()) != 1 && token != 2) {
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return drawable1;
            }
            startLine = parser.getLineNumber();
            startColumn = parser.getColumnNumber();
            indenter = new Indenter(drawable2);
            while (parser.nextToken() != 1) {
                endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            return result2.toString();
        }
        catch (IOException | XmlPullParserException e) {
            return drawable1;
        }
    }

    @Nullable
    public static Point2D getViewportSize(@NotNull String drawable) {
        KXmlParser parser = new KXmlParser();
        try {
            int token;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)drawable, (boolean)true));
            while ((token = parser.nextToken()) != 1 && token != 2) {
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return null;
            }
            double viewportWidth = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportWidth", "");
            double viewportHeight = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportHeight", "");
            return new Point2D.Double(viewportWidth, viewportHeight);
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    @Nullable
    public static Dimension getSizeDp(@NotNull String drawable) {
        KXmlParser parser = new KXmlParser();
        try {
            String suffix;
            int token;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)drawable, (boolean)true));
            while ((token = parser.nextToken()) != 1 && token != 2) {
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return null;
            }
            String widthValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "width");
            if (widthValue != null && (suffix = VectorDrawableTransformer.getSuffix(widthValue)).equals("dp")) {
                double width = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "width", suffix);
                double height = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "height", suffix);
                return new Dimension(Math.round((float)width), Math.round((float)height));
            }
            return null;
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    private static String detectLineSeparator(@NotNull CharSequence str) {
        LineSeparator separator = StringUtil.detectSeparators((CharSequence)str);
        if (separator != null) {
            return separator.getSeparatorString();
        }
        return CodeStyle.getDefaultSettings().getLineSeparator();
    }

    private static double getDoubleAttributeValue(@NotNull KXmlParser parser, @NotNull String namespaceUri, @NotNull String attributeName, @NotNull String expectedSuffix) {
        String value2 = parser.getAttributeValue(namespaceUri, attributeName);
        return VectorDrawableTransformer.parseDoubleValue(value2, expectedSuffix);
    }

    private static double parseDoubleValue(String value2, @NotNull String expectedSuffix) {
        if (value2 == null || !value2.endsWith(expectedSuffix)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(value2.substring(0, value2.length() - expectedSuffix.length()));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @NotNull
    private static String getSuffix(@NotNull String value2) {
        int i2 = value2.length();
        while (--i2 >= 0 && !Character.isDigit(value2.charAt(i2))) {
        }
        return value2.substring(++i2);
    }

    private static boolean isSignificantlyDifferentFromZero(double value2) {
        return Math.abs(value2) >= 1.0E-6;
    }

    private static class Indenter {
        private int myLine;
        private int myColumn;
        private int myOffset;
        @NotNull
        private final CharSequence myText;

        Indenter(@NotNull CharSequence text2) {
            this.myText = text2;
            this.myLine = 1;
            this.myColumn = 1;
        }

        void copy(int fromLine, int fromColumn, int toLine, int toColumn, @NotNull String indent, @NotNull StringBuilder out) {
            char c;
            if (this.myLine != fromLine) {
                if (this.myLine > fromLine) {
                    this.myLine = 1;
                    this.myColumn = 1;
                    this.myOffset = 0;
                }
                while (this.myLine < fromLine) {
                    c = this.myText.charAt(this.myOffset);
                    if (c == '\n') {
                        ++this.myLine;
                        this.myColumn = 1;
                    } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                        ++this.myColumn;
                    }
                    ++this.myOffset;
                }
            }
            this.myOffset += fromColumn - this.myColumn;
            this.myColumn = fromColumn;
            while (this.myLine < toLine || this.myLine == toLine && this.myColumn < toColumn) {
                c = this.myText.charAt(this.myOffset);
                if (c == '\n') {
                    ++this.myLine;
                    this.myColumn = 1;
                } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                    if (this.myColumn == 1 && (c != '\r' || this.myOffset >= this.myText.length() || this.myText.charAt(this.myOffset + 1) != '\n')) {
                        out.append(indent);
                    }
                    ++this.myColumn;
                }
                ++this.myOffset;
                out.append(c);
            }
        }
    }
}

