/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.LegacyCpuProfilingHandler;
import com.android.tools.idea.profilers.LegacyCpuTraceProfiler;
import com.android.tools.idea.profilers.LegacyCpuTraceRecord;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class StudioLegacyCpuTraceProfiler
implements LegacyCpuTraceProfiler {
    @NotNull
    private IDevice myDevice;
    @NotNull
    private final Object myLegacyProfilingLock = new Object();
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myServiceStub;
    @NotNull
    private TransportServiceGrpc.TransportServiceBlockingStub myTransportServiceStub;
    @NotNull
    private final Map<Integer, LegacyCpuTraceRecord> myLegacyProfilingRecord = new HashMap<Integer, LegacyCpuTraceRecord>();
    @NotNull
    private final Map<Integer, List<Cpu.CpuTraceInfo.Builder>> myTraceInfoMap = new HashMap<Integer, List<Cpu.CpuTraceInfo.Builder>>();

    private static Logger getLogger() {
        return Logger.getInstance(StudioLegacyCpuTraceProfiler.class);
    }

    public StudioLegacyCpuTraceProfiler(@NotNull IDevice device, @NotNull CpuServiceGrpc.CpuServiceBlockingStub cpuStub, @NotNull TransportServiceGrpc.TransportServiceBlockingStub transportStub, @NotNull Map<String, ByteString> proxyBytesCache) {
        this.myDevice = device;
        this.myServiceStub = cpuStub;
        this.myTransportServiceStub = transportStub;
        LegacyCpuProfilingHandler profilingHandler = new LegacyCpuProfilingHandler(this.myLegacyProfilingRecord, proxyBytesCache);
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)profilingHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuProfiler.CpuProfilingAppStartResponse startProfilingApp(CpuProfiler.CpuProfilingAppStartRequest request) {
        Client client;
        Cpu.CpuTraceConfiguration.UserOptions userOptions = request.getConfiguration().getUserOptions();
        if (userOptions.getTraceType() == Cpu.CpuTraceType.ATRACE) {
            return this.myServiceStub.startProfilingApp(request);
        }
        assert (userOptions.getTraceType() == Cpu.CpuTraceType.ART);
        int pid = request.getSession().getPid();
        CpuProfiler.CpuProfilingAppStartResponse.Builder responseBuilder = CpuProfiler.CpuProfilingAppStartResponse.newBuilder();
        String appPkgName = this.myDevice.getClientName(pid);
        Client client2 = client = appPkgName != null ? this.myDevice.getClient(appPkgName) : null;
        if (client == null) {
            Cpu.TraceStartStatus status = Cpu.TraceStartStatus.newBuilder().setStatus(Cpu.TraceStartStatus.Status.FAILURE).setErrorMessage("App is not running").build();
            return responseBuilder.setStatus(status).build();
        }
        Object object = this.myLegacyProfilingLock;
        synchronized (object) {
            LegacyCpuTraceRecord record = this.myLegacyProfilingRecord.get(pid);
            if (record != null && client.getClientData().getMethodProfilingStatus() != ClientData.MethodProfilingStatus.OFF) {
                Cpu.TraceStartStatus status = Cpu.TraceStartStatus.newBuilder().setStatus(Cpu.TraceStartStatus.Status.FAILURE).setErrorMessage("Start request ignored. The app has an on-going profiling session.").build();
                return responseBuilder.setStatus(status).build();
            }
            DdmPreferences.setProfilerBufferSizeMb((int)userOptions.getBufferSizeInMb());
            long requestTimeNs = this.myTransportServiceStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance()).getTimestampNs();
            record = new LegacyCpuTraceRecord();
            this.myLegacyProfilingRecord.put(pid, record);
            try {
                if (userOptions.getTraceMode() == Cpu.CpuTraceMode.SAMPLED) {
                    client.startSamplingProfiler(userOptions.getSamplingIntervalUs(), TimeUnit.MICROSECONDS);
                } else {
                    client.startMethodTracer();
                }
                record.getStartLatch().await(100L, TimeUnit.MILLISECONDS);
                record.getStartLatch().countDown();
                if (record.isStartFailed()) {
                    Cpu.TraceStartStatus status = Cpu.TraceStartStatus.newBuilder().setStatus(Cpu.TraceStartStatus.Status.FAILURE).setErrorMessage("Failed to start profiling: " + record.getStartFailureMessage()).build();
                    responseBuilder.setStatus(status).build();
                    this.myLegacyProfilingRecord.remove(pid);
                } else {
                    Cpu.TraceStartStatus status = Cpu.TraceStartStatus.newBuilder().setStatus(Cpu.TraceStartStatus.Status.SUCCESS).build();
                    responseBuilder.setStatus(status);
                    Cpu.CpuTraceInfo.Builder infoBuilder = Cpu.CpuTraceInfo.newBuilder().setTraceId(requestTimeNs).setConfiguration(request.getConfiguration()).setFromTimestamp(requestTimeNs).setStartStatus(status).setToTimestamp(-1L);
                    record.setTraceInfo(infoBuilder);
                    List builders2 = this.myTraceInfoMap.computeIfAbsent(pid, ArrayList::new);
                    builders2.add(infoBuilder);
                }
            }
            catch (IOException | InterruptedException e) {
                Cpu.TraceStartStatus status = Cpu.TraceStartStatus.newBuilder().setStatus(Cpu.TraceStartStatus.Status.FAILURE).setErrorMessage("Failed: " + e).build();
                responseBuilder.setStatus(status);
                StudioLegacyCpuTraceProfiler.getLogger().error("Exception while CpuServiceProxy startProfilingAppDdms: " + e);
            }
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuProfiler.CpuProfilingAppStopResponse stopProfilingApp(CpuProfiler.CpuProfilingAppStopRequest request) {
        if (request.getTraceType() == Cpu.CpuTraceType.ATRACE) {
            return this.myServiceStub.stopProfilingApp(request);
        }
        assert (request.getTraceType() == Cpu.CpuTraceType.ART);
        int pid = request.getSession().getPid();
        CpuProfiler.CpuProfilingAppStopResponse.Builder responseBuilder = CpuProfiler.CpuProfilingAppStopResponse.newBuilder();
        String appPkgName = this.myDevice.getClientName(pid);
        Client client = appPkgName != null ? this.myDevice.getClient(appPkgName) : null;
        Object object = this.myLegacyProfilingLock;
        synchronized (object) {
            Cpu.CpuTraceInfo.Builder builder2;
            if (client == null) {
                this.myLegacyProfilingRecord.remove(pid);
                Cpu.TraceStopStatus status = Cpu.TraceStopStatus.newBuilder().setStatus(Cpu.TraceStopStatus.Status.APP_PROCESS_DIED).setErrorMessage("App is not running.").build();
                responseBuilder.setStatus(status).build();
            } else {
                LegacyCpuTraceRecord record = this.myLegacyProfilingRecord.get(pid);
                if (LegacyCpuTraceRecord.Companion.isMethodProfilingStatusOff(record, client)) {
                    Cpu.TraceStopStatus status = Cpu.TraceStopStatus.newBuilder().setStatus(Cpu.TraceStopStatus.Status.NO_ONGOING_PROFILING).setErrorMessage("The app is not being profiled.").build();
                    responseBuilder.setStatus(status);
                } else {
                    assert (record.getTraceInfo() != null);
                    Cpu.CpuTraceConfiguration.UserOptions userOptions = record.getTraceInfo().getConfiguration().getUserOptions();
                    try {
                        if (userOptions.getTraceMode() == Cpu.CpuTraceMode.SAMPLED) {
                            client.stopSamplingProfiler();
                        } else {
                            client.stopMethodTracer();
                        }
                        record.getStopLatch().await();
                        responseBuilder.setStatus(record.getTraceInfo().getStopStatus());
                        responseBuilder.setTraceId(record.getTraceInfo().getTraceId());
                    }
                    catch (IOException | InterruptedException e) {
                        Cpu.TraceStopStatus status = Cpu.TraceStopStatus.newBuilder().setStatus(Cpu.TraceStopStatus.Status.STOP_COMMAND_FAILED).setErrorMessage("Failed: " + e).build();
                        responseBuilder.setStatus(status);
                        StudioLegacyCpuTraceProfiler.getLogger().error("Exception while CpuServiceProxy stopProfilingApp: " + e);
                    }
                }
                this.myLegacyProfilingRecord.remove(pid);
            }
            List<Cpu.CpuTraceInfo.Builder> builders2 = this.myTraceInfoMap.get(pid);
            if (builders2 != null && !builders2.isEmpty() && (builder2 = builders2.get(builders2.size() - 1)).getToTimestamp() == -1L) {
                Transport.TimeResponse timeResponse = this.myTransportServiceStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance());
                builder2.setToTimestamp(timeResponse.getTimestampNs());
            }
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Cpu.CpuTraceInfo> getTraceInfo(CpuProfiler.GetTraceInfoRequest request) {
        ArrayList<Cpu.CpuTraceInfo> matchedInfoList = new ArrayList<Cpu.CpuTraceInfo>(this.myServiceStub.getTraceInfo(request).getTraceInfoList());
        Object object = this.myLegacyProfilingLock;
        synchronized (object) {
            if (this.myTraceInfoMap.containsKey(request.getSession().getPid())) {
                for (Cpu.CpuTraceInfo.Builder builder2 : this.myTraceInfoMap.get(request.getSession().getPid())) {
                    if (builder2.getFromTimestamp() > request.getToTimestamp() || builder2.getToTimestamp() <= request.getFromTimestamp() && builder2.getToTimestamp() != -1L) continue;
                    matchedInfoList.add(builder2.build());
                }
            }
        }
        return matchedInfoList;
    }
}

