/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ResizableImage
extends JComponent {
    private static final int SQUARE_SIZE = 15;
    private static final int[] SHADOW_ALPHAS = new int[]{5, 15, 25, 35, 40};
    private static final JBColor CHECKERBOARD_COLOR_MAIN = new JBColor(new Color(201, 201, 201), new Color(51, 54, 55));
    private static final JBColor CHECKERBOARD_COLOR_ALT = new JBColor(new Color(236, 236, 236), new Color(60, 63, 65));
    @NotNull
    private BufferedImage myImage;

    public ResizableImage(@NotNull BufferedImage image) {
        this.myImage = image;
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle bounds2 = this.getBounds();
        if (bounds2.width == 0 && bounds2.height == 0) {
            return this.getMaximumSize();
        }
        Insets padding = this.getPadding();
        Dimension preferredImageSize = this.calculatedScaledImageSize(new Dimension(bounds2.width - padding.left - padding.right, bounds2.height - padding.top - padding.bottom));
        if (preferredImageSize.width == 0 && preferredImageSize.height == 0) {
            return new Dimension();
        }
        return new Dimension(preferredImageSize.width + padding.left + padding.right, preferredImageSize.height + padding.top + padding.bottom);
    }

    @Override
    public boolean isPreferredSizeSet() {
        return true;
    }

    @Override
    public Dimension getMaximumSize() {
        Insets padding = this.getPadding();
        return new Dimension(this.myImage.getWidth() + padding.left + padding.right, this.myImage.getHeight() + padding.top + padding.bottom);
    }

    @Override
    public boolean isMaximumSizeSet() {
        return true;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    @NotNull
    private Insets getPadding() {
        Insets insets = this.getInsets();
        insets.left += SHADOW_ALPHAS.length;
        insets.top += SHADOW_ALPHAS.length;
        insets.right = SHADOW_ALPHAS.length;
        insets.bottom = SHADOW_ALPHAS.length;
        return insets;
    }

    @NotNull
    private Dimension calculatedScaledImageSize(@NotNull Dimension availableImageSpace) {
        if (availableImageSpace.width <= 0 || availableImageSpace.height <= 0) {
            return new Dimension();
        }
        int availableWidth = availableImageSpace.width;
        int availableHeight = availableImageSpace.height;
        int imageWidth = this.myImage.getWidth();
        int imageHeight = this.myImage.getHeight();
        float sourceRatio = (float)imageWidth / (float)imageHeight;
        float scaledWidth = imageWidth;
        float scaledHeight = imageHeight;
        if ((float)availableWidth < scaledWidth) {
            scaledWidth = availableWidth;
            scaledHeight = scaledWidth / sourceRatio;
        }
        if ((float)availableHeight < scaledHeight) {
            scaledHeight = availableHeight;
            scaledWidth = scaledHeight * sourceRatio;
        }
        return new Dimension((int)Math.ceil(scaledWidth), (int)Math.ceil(scaledHeight));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Insets padding = this.getPadding();
        Dimension scaledSize = this.calculatedScaledImageSize(new Dimension(this.getWidth() - padding.left - padding.right, this.getHeight() - padding.top - padding.bottom));
        if (scaledSize.width > 0 && scaledSize.height > 0) {
            this.paintShadow(g, scaledSize);
            ResizableImage.paintCheckerboard(g, padding, scaledSize);
            this.paintImage(g, padding, scaledSize);
        }
        super.paintComponent(g);
    }

    private void paintImage(@NotNull Graphics g, @NotNull Insets padding, @NotNull Dimension scaledSize) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(this.myImage, padding.left, padding.top, scaledSize.width + padding.left, scaledSize.height + padding.top, 0, 0, this.myImage.getWidth(), this.myImage.getHeight(), null);
    }

    private static void fillRect(@NotNull Graphics g, int x, int y, int w, int h, int i2, int j) {
        g.fillRect(x + i2 * 15, y + j * 15, Math.min(15, w - (i2 + 1) * 15), Math.min(15, h - (j + 1) * 15));
    }

    private static void paintCheckerboard(@NotNull Graphics g, @NotNull Insets padding, @NotNull Dimension scaledSize) {
        int squareX = (int)Math.ceil((float)scaledSize.width / 15.0f);
        int squareY = (int)Math.ceil((float)scaledSize.height / 15.0f);
        for (int i2 = 0; i2 < squareX; ++i2) {
            int j;
            g.setColor((Color)CHECKERBOARD_COLOR_MAIN);
            for (j = i2 % 2; j < squareY; j += 2) {
                ResizableImage.fillRect(g, padding.left, padding.top, scaledSize.width, scaledSize.height, i2, j);
            }
            g.setColor((Color)CHECKERBOARD_COLOR_ALT);
            for (j = 1 - i2 % 2; j < squareY; j += 2) {
                ResizableImage.fillRect(g, padding.left, padding.top, scaledSize.width, scaledSize.height, i2, j);
            }
        }
    }

    private void paintShadow(@NotNull Graphics g, @NotNull Dimension scaledSize) {
        Insets insets = this.getInsets();
        int width = scaledSize.width + SHADOW_ALPHAS.length * 2;
        int height = scaledSize.height + SHADOW_ALPHAS.length * 2;
        for (int i2 = 0; i2 < SHADOW_ALPHAS.length; ++i2) {
            g.setColor(new Color(0, 0, 0, SHADOW_ALPHAS[i2]));
            g.drawRoundRect(insets.left + i2, insets.top + i2, width - i2 * 2, height - i2 * 2, i2 * 2, i2 * 2);
        }
    }
}

