/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.run.ExecutorIconProvider;
import com.android.tools.idea.run.LaunchOptionsProvider;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.collect.ImmutableMap;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileRunExecutor
extends DefaultRunExecutor
implements ExecutorIconProvider,
LaunchOptionsProvider {
    public static final String PROFILER_LAUNCH_OPTION_KEY = "isProfiling";
    @NonNls
    public static final String EXECUTOR_ID = "Android Profiler";

    @NotNull
    public Icon getIcon() {
        return StudioIcons.Shell.Toolbar.PROFILER;
    }

    public Icon getDisabledIcon() {
        return StudioIcons.Shell.ToolWindows.ANDROID_PROFILER;
    }

    public String getDescription() {
        return "Profile selected configuration";
    }

    @NotNull
    public String getActionName() {
        return "Profile";
    }

    @NotNull
    public String getId() {
        return EXECUTOR_ID;
    }

    @NotNull
    public String getStartActionText() {
        return "Profile";
    }

    public String getContextActionId() {
        return "ProfileRunClass";
    }

    public String getHelpId() {
        return null;
    }

    public static Executor getProfileExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }

    @Override
    @Nullable
    public Icon getExecutorIcon(@NotNull Project project, @NotNull Executor executor) {
        Common.Session profilingSession;
        StudioProfilers profilers;
        AndroidProfilerToolWindow profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project);
        if (profilerToolWindow != null && (profilers = profilerToolWindow.getProfilers()) != null && SessionsManager.isSessionAlive((Common.Session)(profilingSession = profilers.getSessionsManager().getProfilingSession()))) {
            return ExecutionUtil.getLiveIndicator((Icon)this.getIcon());
        }
        return this.getIcon();
    }

    @Override
    @NotNull
    public Map<String, Object> getLaunchOptions() {
        return ImmutableMap.of((Object)PROFILER_LAUNCH_OPTION_KEY, (Object)true);
    }

    public boolean isApplicable(@NotNull Project project) {
        return AndroidUtils.hasAndroidFacets(project);
    }
}

