/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.tools.idea.rendering.Gravity;
import com.android.tools.idea.rendering.VectorDrawableTransformer;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TvBannerGenerator
extends IconGenerator {
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(0xFFFFFF);
    private static final Rectangle IMAGE_SIZE_ADAPTIVE_DP = new Rectangle(0, 0, 320, 180);
    private static final Dimension SIZE_ADAPTIVE_DP = IMAGE_SIZE_ADAPTIVE_DP.getSize();
    private static final double ADAPTIVE_ICON_SCALE_FACTOR = 0.6666666666666666;
    private static final Density LEGACY_DENSITY = Density.XHIGH;
    private static final double IMAGE_TEXT_RATIO = 0.4;
    private static final double DEFAULT_TEXT_SCALE = 0.82;
    private static final double IMAGE_MARGIN = 0.03;
    private static final double PREVIEW_SCALE = 0.31;
    private final ObjectProperty<Color> myBackgroundColor = new ObjectValueProperty<Color>(DEFAULT_BACKGROUND_COLOR);
    private final BoolProperty myGenerateLegacyIcon = new BoolValueProperty(true);
    private final OptionalProperty<TextAsset> myTextAsset = new OptionalValueProperty<TextAsset>();
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>();
    private final StringProperty myForegroundLayerName = new StringValueProperty();
    private final StringProperty myBackgroundLayerName = new StringValueProperty();

    public TvBannerGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        return this.myBackgroundColor;
    }

    @NotNull
    public BoolProperty generateLegacyIcon() {
        return this.myGenerateLegacyIcon;
    }

    @NotNull
    public OptionalProperty<TextAsset> textAsset() {
        return this.myTextAsset;
    }

    @NotNull
    public OptionalProperty<ImageAsset> backgroundImageAsset() {
        return this.myBackgroundImageAsset;
    }

    @NotNull
    public StringProperty foregroundLayerName() {
        return this.myForegroundLayerName;
    }

    @NotNull
    public StringProperty backgroundLayerName() {
        return this.myBackgroundLayerName;
    }

    @Override
    @NotNull
    public TvBannerOptions createOptions(boolean forPreview) {
        TextAsset textAsset;
        TvBannerOptions options2 = new TvBannerOptions(forPreview);
        ImageAsset foregroundAsset = (ImageAsset)this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null && foregroundAsset.imagePath().getValueOrNull() != null) {
            double scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            options2.foregroundImage = new TransformedImageAsset(foregroundAsset, SIZE_ADAPTIVE_DP, scaleFactor, null, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        if ((textAsset = this.myTextAsset.getValueOrNull()) != null && !StringUtil.trimTrailing((String)((String)textAsset.text().get())).isEmpty()) {
            double scaleFactor = (double)((Integer)textAsset.scalingPercent().get()).intValue() / 100.0;
            options2.foregroundText = new TransformedImageAsset(textAsset, SIZE_ADAPTIVE_DP, scaleFactor, null, this.getGraphicGeneratorContext(), this.myLineSeparator);
            Color color = (Color)textAsset.color().getValueOrNull();
            options2.foregroundTextColor = color == null ? 0 : color.getRGB();
        }
        TvBannerGenerator.shiftImageAndText(options2);
        ImageAsset backgroundAsset = this.myBackgroundImageAsset.getValueOrNull();
        if (backgroundAsset != null) {
            double scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options2.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_ADAPTIVE_DP, scaleFactor, null, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        options2.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options2.foregroundLayerName = (String)this.myForegroundLayerName.get();
        options2.backgroundLayerName = (String)this.myBackgroundLayerName.get();
        options2.generateLegacyIcon = (Boolean)this.myGenerateLegacyIcon.get();
        return options2;
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        TvBannerOptions tvBannerOptions = (TvBannerOptions)options2;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name, tvBannerOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, tvBannerOptions, tasks);
        TvBannerGenerator.createPreviewImagesTasks(context, tvBannerOptions, tasks);
        return tasks;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull TvBannerOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options2.generateOutputIcons) {
            return;
        }
        TvBannerOptions localOptions = options2.clone();
        localOptions.density = LEGACY_DENSITY;
        this.createOutputIconsForSingleDensityTasks(context, name, localOptions, tasks);
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull TvBannerOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (options2.foregroundImage != null && options2.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvBannerOptions foregroundOptions = options2.clone();
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                AnnotatedImage foregroundImage = TvBannerGenerator.generateIconForegroundLayer(foregroundOptions, false);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options2.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, options2.density, foregroundImage);
            });
        }
        if (options2.backgroundImage != null && options2.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvBannerOptions backgroundOptions = options2.clone();
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                AnnotatedImage backgroundImage = TvBannerGenerator.generateIconBackgroundLayer(context, backgroundOptions, false);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options2.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, options2.density, backgroundImage);
            });
        }
        if (options2.generateLegacyIcon) {
            tasks.add(() -> {
                TvBannerOptions legacyOptions = options2.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                AnnotatedImage legacy = TvBannerGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(legacyOptions, name)), IconCategory.LEGACY, options2.density, legacy);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull TvBannerOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options2.generateOutputIcons) {
            return;
        }
        TvBannerOptions iconOptions = options2.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        TransformedImageAsset image = options2.foregroundImage;
        TransformedImageAsset text2 = options2.foregroundText;
        if (image == null ? text2 != null : image.isDrawable()) {
            tasks.add(() -> {
                TvBannerOptions iconOptions = options2.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                String imageDrawable = null;
                String textDrawable = null;
                if (image != null && (imageDrawable = image.getTransformedDrawable()) == null) {
                    TvBannerGenerator.getLog().error("Transformed foreground drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    imageDrawable = "<vector/>";
                }
                if (text2 != null && (textDrawable = text2.getTransformedDrawable()) == null) {
                    TvBannerGenerator.getLog().error("Transformed foreground text is null", new Throwable());
                    textDrawable = "<vector/>";
                }
                String xmlDrawableText = imageDrawable == null ? textDrawable : (textDrawable == null ? imageDrawable : VectorDrawableTransformer.merge(imageDrawable, textDrawable));
                xmlDrawableText = TvBannerGenerator.applyAdaptiveIconScaleFactor(xmlDrawableText);
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawableText);
            });
        }
        if (options2.backgroundImage != null && options2.backgroundImage.isDrawable()) {
            TransformedImageAsset backgroundImage = options2.backgroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                TvBannerOptions iconOptions = options2.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!backgroundImage.isDrawable()) {
                    TvBannerGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = backgroundImage.getTransformedDrawable()) == null) {
                    TvBannerGenerator.getLog().error("Transformed background drawable is null" + (backgroundImage.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                xmlDrawableText = TvBannerGenerator.applyAdaptiveIconScaleFactor(xmlDrawableText);
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawableText);
            });
        } else if (options2.backgroundImage == null) {
            tasks.add(() -> {
                TvBannerOptions iconOptions = options2.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format2, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    @NotNull
    private static String applyAdaptiveIconScaleFactor(@NotNull String xmlDrawableText) {
        return VectorDrawableTransformer.transform(xmlDrawableText, SIZE_ADAPTIVE_DP, Gravity.CENTER, 0.6666666666666666, null, null, null, 1.0);
    }

    private static void shiftImageAndText(@NotNull TvBannerOptions options2) {
        TransformedImageAsset image = options2.foregroundImage;
        TransformedImageAsset text2 = options2.foregroundText;
        if (text2 != null) {
            if (image != null) {
                image.setShift(new Point2D.Double(-0.27, 0.0));
                double scaleFactor = text2.getScaleFactor();
                double shift = 0.2 + 0.3 * (scaleFactor * 0.82 - 1.0);
                text2.setShift(new Point2D.Double(shift, 0.0));
                text2.setGravity(Gravity.WEST);
                text2.applyAdditionalScaleFactor(0.49199999999999994);
            } else {
                text2.applyAdditionalScaleFactor(0.82);
            }
        }
    }

    private static BufferedImage mergeImages(@NotNull BufferedImage image1, @NotNull BufferedImage image2) {
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)image1.getWidth(), (int)image1.getHeight());
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        gOut.drawImage((Image)image1, 0, 0, null);
        gOut.drawImage((Image)image2, 0, 0, null);
        gOut.dispose();
        return outImage;
    }

    @NotNull
    private String getAdaptiveIconXml(@NotNull TvBannerOptions options2) {
        String backgroundType = options2.backgroundImage == null ? "color" : (options2.backgroundImage.isDrawable() ? "drawable" : "mipmap");
        String foregroundType = options2.foregroundImage != null && options2.foregroundImage.isDrawable() ? "drawable" : "mipmap";
        String format2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">%1$s    <background android:drawable=\"@%2$s/%3$s\"/>%1$s    <foreground android:drawable=\"@%4$s/%5$s\"/>%1$s</adaptive-icon>";
        return String.format(format2, this.myLineSeparator, backgroundType, options2.backgroundLayerName, foregroundType, options2.foregroundLayerName);
    }

    private static void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options2.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.ADAPTIVE);
        if (options2.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AnnotatedImage image;
                TvBannerOptions localOptions = options2.clone();
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                try {
                    image = TvBannerGenerator.generatePreviewImage(context, localOptions);
                }
                catch (Throwable e) {
                    TvBannerGenerator.getLog().error(e);
                    image = TvBannerGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        TvBannerOptions tvBannerOptions = (TvBannerOptions)options2;
        TvBannerOptions localOptions = tvBannerOptions.clone();
        Collection<GeneratedIcon> icons = this.generateIcons(context, options2, name);
        icons.stream().filter(icon2 -> icon2 instanceof GeneratedImageIcon).map(icon2 -> (GeneratedImageIcon)icon2).filter(icon2 -> icon2.getOutputPath() != null).forEach(icon2 -> {
            assert (icon2.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(icon2.getCategory().toString(), k -> new LinkedHashMap());
            TvBannerOptions iconOptions = localOptions.clone();
            iconOptions.density = icon2.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            imageMap.put(icon2.getOutputPath().toString(), new AnnotatedImage(icon2.getImage(), icon2.getErrorMessage()));
        });
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2) {
        if (options2.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        return TvBannerGenerator.generatePreviewImage(context, (TvBannerOptions)options2);
    }

    @NotNull
    private static AnnotatedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options2) {
        switch (options2.previewShape) {
            case ADAPTIVE: 
            case LEGACY: {
                Layers layers = TvBannerGenerator.generateIconLayers(context, options2, true);
                AnnotatedImage mergedImage = TvBannerGenerator.mergeLayers(layers);
                BufferedImage image = mergedImage.getImage();
                return new AnnotatedImage(image, mergedImage.getErrorMessage());
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private static AnnotatedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options2) {
        Layers layers = TvBannerGenerator.generateIconLayers(context, options2, false);
        AnnotatedImage mergedImage = TvBannerGenerator.mergeLayers(layers);
        BufferedImage image = mergedImage.getImage();
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    @NotNull
    private static AnnotatedImage mergeLayers(@NotNull Layers layers) {
        BufferedImage backgroundImage = layers.background.getImage();
        BufferedImage foregroundImage = layers.foreground.getImage();
        int width = Math.max(backgroundImage.getWidth(), foregroundImage.getWidth());
        int height = Math.max(backgroundImage.getHeight(), foregroundImage.getHeight());
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        gOut.drawImage((Image)backgroundImage, 0, 0, null);
        gOut.drawImage((Image)foregroundImage, 0, 0, null);
        gOut.dispose();
        String errorMessage = layers.foreground.getErrorMessage();
        if (errorMessage == null) {
            errorMessage = layers.background.getErrorMessage();
        }
        return new AnnotatedImage(outImage, errorMessage);
    }

    @NotNull
    private static Layers generateIconLayers(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options2, boolean forPreview) {
        AnnotatedImage backgroundImage = TvBannerGenerator.generateIconBackgroundLayer(context, options2, forPreview);
        AnnotatedImage foregroundImage = TvBannerGenerator.generateIconForegroundLayer(options2, forPreview);
        return new Layers(backgroundImage, foregroundImage);
    }

    @NotNull
    private static AnnotatedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options2, boolean forPreview) {
        BufferedImage image;
        TransformedImageAsset imageAsset;
        if (options2.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        String errorMessage = null;
        Rectangle imageRect = IMAGE_SIZE_ADAPTIVE_DP;
        if (forPreview) {
            Density density = options2.previewShape == PreviewShape.LEGACY ? LEGACY_DENSITY : Density.XXXHIGH;
            double scale = TvBannerGenerator.getMdpiScaleFactor(density) * 0.31;
            imageRect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scale);
        }
        if ((imageAsset = options2.backgroundImage) == null) {
            image = TvBannerGenerator.generateFlatColorRectangle(new Color(options2.backgroundColor), imageRect);
        } else {
            try {
                image = TvBannerGenerator.generateIconBackgroundLayer(context, imageAsset, imageRect);
            }
            catch (RuntimeException e) {
                errorMessage = TvBannerGenerator.composeErrorMessage(e, "background", imageAsset);
                image = imageAsset.createErrorImage(imageRect.getSize());
            }
        }
        return new AnnotatedImage(image, errorMessage);
    }

    @NotNull
    private static String composeErrorMessage(@NotNull Exception e, @NotNull String role, @Nullable TransformedImageAsset imageAsset) {
        String errorMessage = imageAsset != null && imageAsset.isDrawable() ? String.format("Unable to generate image, possibly invalid %s drawable", role) : String.format("Failed to transform %s image", role);
        String exceptionMessage = e.getMessage();
        return exceptionMessage == null ? errorMessage : errorMessage + ": " + exceptionMessage;
    }

    @NotNull
    private static AnnotatedImage generateIconForegroundLayer(@NotNull TvBannerOptions options2, boolean forPreview) {
        BufferedImage image;
        if (options2.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        String errorMessage = null;
        Rectangle imageRect = IMAGE_SIZE_ADAPTIVE_DP;
        if (forPreview) {
            Density density = options2.previewShape == PreviewShape.LEGACY ? LEGACY_DENSITY : Density.XXXHIGH;
            double scale = TvBannerGenerator.getMdpiScaleFactor(density) * 0.31;
            imageRect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scale);
        }
        TransformedImageAsset foregroundImage = options2.foregroundImage;
        TransformedImageAsset foregroundText = options2.foregroundText;
        try {
            image = TvBannerGenerator.generateIconForegroundLayer(imageRect, foregroundImage, foregroundText);
        }
        catch (RuntimeException e) {
            errorMessage = TvBannerGenerator.composeErrorMessage(e, "foreground", foregroundImage);
            image = foregroundImage == null ? AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height) : foregroundImage.createErrorImage(imageRect.getSize());
        }
        return new AnnotatedImage(image, errorMessage);
    }

    @NotNull
    private static BufferedImage generateFlatColorRectangle(@NotNull Color color, @NotNull Rectangle imageRect) {
        BufferedImage result2 = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)result2.getGraphics();
        gTemp.setPaint(color);
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        gTemp.dispose();
        return result2;
    }

    @NotNull
    private static BufferedImage generateIconForegroundLayer(@NotNull Rectangle imageRect, @Nullable TransformedImageAsset image, @Nullable TransformedImageAsset text2) {
        BufferedImage foregroundImage;
        BufferedImage bufferedImage = foregroundImage = image == null ? null : image.getTransformedImage(imageRect.getSize());
        if (text2 == null) {
            if (foregroundImage != null) {
                return foregroundImage;
            }
        } else {
            BufferedImage textImage = text2.getTransformedImage(imageRect.getSize());
            if (foregroundImage != null) {
                return TvBannerGenerator.mergeImages(foregroundImage, textImage);
            }
            return textImage;
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull TransformedImageAsset sourceImage, @NotNull Rectangle imageRect) {
        String scaledDrawable = sourceImage.getTransformedDrawable();
        if (scaledDrawable != null) {
            return TvBannerGenerator.generateIconLayer(context, scaledDrawable, imageRect);
        }
        BufferedImage trimmedImage = sourceImage.getTrimmedImage();
        if (trimmedImage != null) {
            return TvBannerGenerator.generateIconBackgroundLayer(context, trimmedImage, imageRect, sourceImage.getScaleFactor());
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull String xmlDrawable, @NotNull Rectangle imageRect) {
        Future<BufferedImage> imageFuture = context.renderDrawable(xmlDrawable, imageRect.getSize());
        try {
            BufferedImage image = imageFuture.get();
            if (image != null) {
                return image;
            }
        }
        catch (ExecutionException e) {
            ExceptionUtil.rethrow((Throwable)e.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor) {
        Callable<Future> generator2 = () -> FutureUtils.executeOnPooledThread(() -> {
            BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
            Rectangle rect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scaleFactor);
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)rect);
            gIcon.dispose();
            return iconImage;
        });
        class CacheKey {
            @NotNull
            private final Object mySource;
            @NotNull
            private final Rectangle myImageRect;
            private final int myScaleFactorTimes1000;
            private final boolean myUseFillColor;
            private final int myFillColor;

            CacheKey(@NotNull Object source, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor) {
                this.mySource = source;
                this.myImageRect = imageRect;
                this.myScaleFactorTimes1000 = AssetStudioUtils.roundToInt(scaleFactor * 1000.0);
                this.myUseFillColor = useFillColor;
                this.myFillColor = fillColor;
            }

            public int hashCode() {
                return Objects.hash(this.mySource, this.myImageRect, this.myScaleFactorTimes1000, this.myUseFillColor, this.myFillColor);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.mySource, other.mySource) && Objects.equals(this.myImageRect, other.myImageRect) && this.myScaleFactorTimes1000 == other.myScaleFactorTimes1000 && this.myUseFillColor == other.myUseFillColor && this.myFillColor == other.myFillColor;
            }
        }
        CacheKey cacheKey = new CacheKey(sourceImage, imageRect, scaleFactor, false, 0);
        Future<BufferedImage> imageFuture = context.getFromCacheOrCreate(cacheKey, generator2);
        return (BufferedImage)Futures.getUnchecked(imageFuture);
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        return density == Density.XHIGH;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(TvBannerGenerator.class);
    }

    private static class Layers {
        @NotNull
        public AnnotatedImage background;
        @NotNull
        public AnnotatedImage foreground;

        Layers(@NotNull AnnotatedImage background, @NotNull AnnotatedImage foreground) {
            this.background = background;
            this.foreground = foreground;
        }
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        ADAPTIVE("adaptive", "Adaptive (anydpi)"),
        LEGACY("legacy", "Legacy (xhdpi)");

        public final String id;
        public final String displayName;

        private PreviewShape(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }
    }

    public static class TvBannerOptions
    extends IconGenerator.IconOptions
    implements Cloneable {
        public String foregroundLayerName;
        public String backgroundLayerName;
        @Nullable
        public TransformedImageAsset foregroundImage;
        @Nullable
        public TransformedImageAsset foregroundText;
        public int foregroundTextColor = 0;
        public int backgroundColor = 0;
        @Nullable
        public TransformedImageAsset backgroundImage;
        public boolean generateLegacyIcon = true;
        public PreviewShape previewShape = PreviewShape.NONE;

        public TvBannerOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public TvBannerOptions clone() {
            return (TvBannerOptions)super.clone();
        }
    }
}

