/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.PsiIncludeDirectoryView;
import com.android.tools.idea.util.VirtualFiles;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class IncludeViewNodes {
    @NotNull
    public static Collection<AbstractTreeNode<?>> getIncludeFolderNodesWithShadowing(@NotNull Collection<File> includes, @NotNull ImmutableList<VirtualFile> excludesVirtualFiles, boolean folderParentIsObvious, @NotNull Project project, @NotNull ViewSettings settings) {
        ArrayList result2 = new ArrayList();
        HashSet baseNameSeenAlready = new HashSet();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File include : includes) {
            PsiDirectory psiDirectory;
            VirtualFile folder = fileSystem.findFileByIoFile(include);
            if (folder == null || (psiDirectory = psiManager.findDirectory(folder)) == null) continue;
            psiDirectory.processChildren(element2 -> {
                if (VirtualFiles.isElementAncestorOfExclude(element2, excludesVirtualFiles)) {
                    return true;
                }
                if (baseNameSeenAlready.contains(element2.getName())) {
                    return true;
                }
                baseNameSeenAlready.add(element2.getName());
                if (element2 instanceof PsiDirectory) {
                    PsiDirectory concrete = (PsiDirectory)element2;
                    PsiIncludeDirectoryView node2 = new PsiIncludeDirectoryView(project, excludesVirtualFiles, folderParentIsObvious, concrete, settings);
                    if (!node2.getChildren().isEmpty()) {
                        result2.add((AbstractTreeNode<?>)node2);
                    }
                    return true;
                }
                if (element2 instanceof PsiFile) {
                    PsiFile concrete = (PsiFile)element2;
                    if (!LexicalIncludePaths.hasHeaderExtension(concrete.getName())) {
                        return true;
                    }
                    result2.add((AbstractTreeNode<?>)new PsiFileNode(project, concrete, settings));
                    return true;
                }
                return true;
            });
        }
        return result2;
    }
}

