/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.V2NdkModel;
import com.android.tools.idea.navigator.nodes.ndk.ExternalBuildFileNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalBuildFilesGroupNode
extends ProjectViewNode<Project> {
    public ExternalBuildFilesGroupNode(@NotNull Project project, @NotNull ViewSettings settings) {
        super(project, (Object)project, settings);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return this.getBuildFilesWithModuleNames().containsKey(file2);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        Map<VirtualFile, String> buildFiles = this.getBuildFilesWithModuleNames();
        ArrayList<PsiFileNode> children = new ArrayList<PsiFileNode>(buildFiles.size());
        for (Map.Entry<VirtualFile, String> buildFileWithModuleName : buildFiles.entrySet()) {
            this.addPsiFile(children, buildFileWithModuleName.getKey(), buildFileWithModuleName.getValue());
        }
        return children;
    }

    @NotNull
    private Map<VirtualFile, String> getBuildFilesWithModuleNames() {
        HashMap<VirtualFile, String> buildFiles = new HashMap<VirtualFile, String>();
        assert (this.myProject != null);
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(module2);
            if (ndkModuleModel == null || ndkModuleModel.getNdkModel() instanceof V2NdkModel) continue;
            for (File file2 : ndkModuleModel.getBuildFiles()) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
                if (virtualFile == null) continue;
                buildFiles.put(virtualFile, module2.getName());
            }
        }
        return buildFiles;
    }

    private void addPsiFile(@NotNull List<PsiFileNode> psiFileNodes, @NotNull VirtualFile file2, @NotNull String moduleName2) {
        assert (this.myProject != null);
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile2 != null) {
            psiFileNodes.add(new ExternalBuildFileNode(this.myProject, psiFile2, this.getSettings(), moduleName2));
        }
    }

    public int getWeight() {
        return 200;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setPresentableText("External Build Files");
        presentation.setIcon(AllIcons.General.ExternalTools);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "External Build Files";
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

