/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkPackage;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.navigator.nodes.apk.java.DexFileStructure;
import com.android.tools.idea.navigator.nodes.apk.java.PackageNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexGroupNode
extends ProjectViewNode<VirtualFile> {
    @NotNull
    private final DexSourceFiles myDexSourceFiles;
    @Nullable
    private final DexFileStructure myDexFileStructure;
    private Collection<ApkPackage> myPackages = Collections.emptyList();
    private static final VirtualFile NULL_DEX = new StubVirtualFile();

    public DexGroupNode(@NotNull Project project, @NotNull ViewSettings settings, @Nullable VirtualFile dexFile) {
        this(project, settings, DexSourceFiles.getInstance(project), dexFile);
    }

    DexGroupNode(@NotNull Project project, @NotNull ViewSettings settings, @NotNull DexSourceFiles dexSourceFiles, @Nullable VirtualFile dexFile) {
        super(project, ObjectUtils.notNull((Object)dexFile, (Object)NULL_DEX), settings);
        this.myDexSourceFiles = dexSourceFiles;
        this.myDexFileStructure = dexFile != null ? new DexFileStructure(dexFile) : null;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        if (this.myDexFileStructure != null) {
            try {
                this.myPackages = this.myDexFileStructure.getPackages();
                return this.getChildren(this.myPackages);
            }
            catch (Throwable e) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn("Failed to parse dex file", e);
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private Collection<? extends AbstractTreeNode<?>> getChildren(@NotNull Collection<ApkPackage> packages) {
        assert (this.myProject != null);
        ArrayList children = new ArrayList();
        ViewSettings settings = this.getSettings();
        if (settings.isFlattenPackages()) {
            this.addPackagesAsFlatList(packages, children);
        } else {
            this.addPackagesAsTree(packages, children);
        }
        return children;
    }

    private void addPackagesAsFlatList(@NotNull Collection<ApkPackage> packages, @NotNull List<AbstractTreeNode<?>> children) {
        for (ApkPackage apkPackage : packages) {
            boolean hideEmptyMiddlePackages = this.getSettings().isHideEmptyMiddlePackages();
            if (!hideEmptyMiddlePackages || !apkPackage.getClasses().isEmpty()) {
                children.add((AbstractTreeNode<?>)this.createNode(apkPackage));
            }
            this.addPackagesAsFlatList(apkPackage.getSubpackages(), children);
        }
    }

    private void addPackagesAsTree(@NotNull Collection<ApkPackage> packages, @NotNull List<AbstractTreeNode<?>> children) {
        if (this.getSettings().isHideEmptyMiddlePackages()) {
            for (ApkPackage apkPackage : packages) {
                if (!apkPackage.getClasses().isEmpty() || apkPackage.doSubpackagesHaveClasses()) {
                    children.add((AbstractTreeNode<?>)this.createNode(apkPackage));
                    continue;
                }
                this.addPackagesAsTree(apkPackage.getSubpackages(), children);
            }
        } else {
            for (ApkPackage apkPackage : packages) {
                children.add((AbstractTreeNode<?>)this.createNode(apkPackage));
            }
        }
    }

    @NotNull
    private PackageNode createNode(ApkPackage apkPackage) {
        assert (this.myProject != null);
        return new PackageNode(this.myProject, apkPackage, this.getSettings(), this.myDexSourceFiles);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        block3: {
            block4: {
                if (this.myDexFileStructure == null) break block3;
                if (!this.myDexSourceFiles.isJavaFile(file2)) break block4;
                assert (this.myProject != null);
                String foundPackage = this.myDexSourceFiles.findJavaPackageNameIn(file2);
                for (ApkPackage apkPackage : this.myPackages) {
                    if (foundPackage == null || !foundPackage.contains(apkPackage.getFqn())) continue;
                    return true;
                }
                break block3;
            }
            if (!this.myDexSourceFiles.isSmaliFile(file2)) break block3;
            File filePath = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
            for (ApkPackage apkPackage : this.myPackages) {
                File packageFilePath = this.myDexSourceFiles.findSmaliFilePathForPackage(apkPackage.getFqn());
                if (!FileUtil.isAncestor((File)packageFilePath, (File)filePath, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setIcon(AllIcons.Modules.SourceRoot);
        presentation.addText(DexGroupNode.getSourceType().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        VirtualFile dexFile = (VirtualFile)this.getValue();
        if (dexFile != NULL_DEX) {
            presentation.addText(" (" + dexFile.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getTypeSortKey();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return DexGroupNode.getSourceType();
    }

    @NotNull
    private static AndroidSourceType getSourceType() {
        return AndroidSourceType.JAVA;
    }

    public boolean isAlwaysExpand() {
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        String text2 = DexGroupNode.getSourceType().getName();
        VirtualFile dexFile = (VirtualFile)this.getValue();
        if (dexFile != NULL_DEX) {
            text2 = text2 + " (" + dexFile.getName() + ")";
        }
        return text2;
    }
}

