/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.gradle.model.IdeBuildTypeContainer;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.module.Module;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestPlaceholderResolver {
    public static Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");
    private final ImmutableMap<String, Object> myPlaceholders;

    public ManifestPlaceholderResolver(@NotNull Module module2) {
        AndroidModuleModel model2 = AndroidModuleModel.get(module2);
        if (model2 != null) {
            ImmutableMap.Builder placeholdersBuilder = ImmutableMap.builder();
            IdeVariant selectedVariant = model2.getSelectedVariant();
            IdeBuildTypeContainer buildType = model2.findBuildType(selectedVariant.getBuildType());
            if (buildType != null) {
                placeholdersBuilder.putAll(buildType.getBuildType().getManifestPlaceholders());
            }
            placeholdersBuilder.putAll(selectedVariant.getMergedFlavor().getManifestPlaceholders());
            this.myPlaceholders = placeholdersBuilder.build();
        } else {
            this.myPlaceholders = ImmutableMap.of();
        }
    }

    @NotNull
    public ImmutableMap<String, Object> getPlaceholders() {
        return this.myPlaceholders;
    }

    @Nullable
    public String resolve(@Nullable String value2) {
        if (value2 == null) {
            return null;
        }
        if (this.myPlaceholders.isEmpty() || !value2.contains("${")) {
            return value2;
        }
        StringBuffer output = new StringBuffer();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(value2);
        while (matcher.find()) {
            Object placeholderValue = this.myPlaceholders.get((Object)matcher.group(1));
            matcher.appendReplacement(output, placeholderValue != null ? Matcher.quoteReplacement(placeholderValue.toString()) : "$0");
        }
        matcher.appendTail(output);
        return output.toString();
    }
}

