/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.mlkit.MlModelFileIndex;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class ProjectMlModelFileTracker
extends SimpleModificationTracker {
    @Nullable
    private GradleVersion myGradleVersion;

    public ProjectMlModelFileTracker(final @NotNull Project project) {
        this.myGradleVersion = ProjectMlModelFileTracker.getGradleVersionFromProject(project);
        project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                boolean hasModelFile = false;
                boolean needRebuildIndex = false;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 == null || !"tflite".equalsIgnoreCase(file2.getExtension())) continue;
                    hasModelFile = true;
                    if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                    needRebuildIndex = true;
                    break;
                }
                if (hasModelFile) {
                    ProjectMlModelFileTracker.this.incModificationCount();
                }
                if (needRebuildIndex) {
                    FileBasedIndex.getInstance().requestRebuild(MlModelFileIndex.INDEX_ID);
                }
            }
        });
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)new ProjectSystemSyncManager.SyncResultListener(){

            @Override
            public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result2) {
                if (result2.isSuccessful()) {
                    GradleVersion gradleVersion2 = ProjectMlModelFileTracker.getGradleVersionFromProject(project);
                    if (!Objects.equals(ProjectMlModelFileTracker.this.myGradleVersion, gradleVersion2)) {
                        Logger.getInstance(ProjectMlModelFileTracker.class).info("AGP version changed, refresh all light classes cache.");
                        ProjectMlModelFileTracker.this.myGradleVersion = gradleVersion2;
                        ProjectMlModelFileTracker.this.incModificationCount();
                    }
                }
            }
        });
    }

    @Nullable
    private static GradleVersion getGradleVersionFromProject(@NotNull Project project) {
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromModel(project);
        if (androidPluginInfo != null) {
            return androidPluginInfo.getPluginVersion();
        }
        return null;
    }

    @NotNull
    public static ProjectMlModelFileTracker getInstance(@NotNull Project project) {
        return (ProjectMlModelFileTracker)((Object)ServiceManager.getService((Project)project, ProjectMlModelFileTracker.class));
    }

    @VisibleForTesting
    void setGradleVersion(@Nullable GradleVersion gradleVersion2) {
        this.myGradleVersion = gradleVersion2;
    }
}

