/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.mlkit.MlModelMetadata;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileType;
import com.android.tools.mlkit.ModelInfo;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MlModelFileIndex
extends FileBasedIndexExtension<String, MlModelMetadata> {
    public static final ID<String, MlModelMetadata> INDEX_ID = ID.create((String)"MlModelFileIndex");

    @NotNull
    public DataIndexer<String, MlModelMetadata, FileContent> getIndexer() {
        return new DataIndexer<String, MlModelMetadata, FileContent>(){

            @NotNull
            public Map<String, MlModelMetadata> map(@NotNull FileContent inputData) {
                VirtualFile modelFile = inputData.getFile();
                try {
                    byte[] bytes = Files.readAllBytes(VfsUtilCore.virtualToIoFile((VirtualFile)modelFile).toPath());
                    ModelInfo modelInfo = ModelInfo.buildFrom((ByteBuffer)ByteBuffer.wrap(bytes));
                    return ImmutableMap.of((Object)modelFile.getUrl(), (Object)new MlModelMetadata(modelFile.getUrl(), modelInfo));
                }
                catch (Exception e) {
                    Logger.getInstance(MlModelFileIndex.class).warn("Failed to index " + modelFile.getUrl(), (Throwable)e);
                    return Collections.emptyMap();
                }
            }
        };
    }

    @NotNull
    public DataExternalizer<MlModelMetadata> getValueExternalizer() {
        return new DataExternalizer<MlModelMetadata>(){

            public void save(@NotNull DataOutput out, @NotNull MlModelMetadata value2) throws IOException {
                out.writeUTF(value2.myModelFileUrl);
                value2.myModelInfo.save(out);
            }

            public MlModelMetadata read(@NotNull DataInput in) throws IOException {
                String fileUrl = in.readUTF();
                ModelInfo modelInfo = new ModelInfo(in);
                return new MlModelMetadata(fileUrl, modelInfo);
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    public int getVersion() {
        return 6;
    }

    @NotNull
    public ID<String, MlModelMetadata> getName() {
        return INDEX_ID;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return file2 -> (Boolean)StudioFlags.ML_MODEL_BINDING.get() != false && file2.getFileType() == TfliteModelFileType.INSTANCE && file2.getLength() > 0L && file2.getLength() <= 0xC800000L;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    @NotNull
    public Collection<FileType> getFileTypesWithSizeLimitNotApplicable() {
        return Collections.singletonList(TfliteModelFileType.INSTANCE);
    }
}

