/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.checks.ObjectAnimatorDetector;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/lint/AddKeepAnnotationFix;", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "()V", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "applyJava", "element", "applyKotlin", "getName", "", "isApplicable", "", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "intellij.android.core"})
public final class AddKeepAnnotationFix
implements LintIdeQuickFix {
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        block1: {
            Language language;
            block0: {
                language = startElement.getLanguage();
                if (!Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) break block0;
                this.applyJava(startElement);
                break block1;
            }
            if (!Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) break block1;
            this.applyKotlin(startElement);
        }
    }

    private final void applyJava(PsiElement element2) {
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiModifierListOwner.class);
        if (psiModifierListOwner == null) {
            return;
        }
        PsiModifierListOwner container = psiModifierListOwner;
        Project project = element2.getProject();
        String annotationName = DependencyManagementUtil.mapAndroidxName(ModuleUtilCore.findModuleForPsiElement((PsiElement)element2), ObjectAnimatorDetector.Companion.getKEEP_ANNOTATION());
        new AddAnnotationFix(annotationName, container, new String[0]).invoke(project, null, container.getContainingFile());
    }

    private final void applyKotlin(PsiElement element2) {
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, KtNamedFunction.class);
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction method2 = ktNamedFunction;
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)method2)) {
            return;
        }
        FqName annotationName = new FqName(DependencyManagementUtil.mapAndroidxName(ModuleUtilCore.findModuleForPsiElement((PsiElement)element2), ObjectAnimatorDetector.Companion.getKEEP_ANNOTATION()));
        ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)((KtModifierListOwner)method2), (FqName)annotationName, null, (String)" ", null, (int)8, null);
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    @NotNull
    public String getName() {
        return "Annotate with @Keep";
    }
}

