/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.ui.DeviceViewPanelModel;
import com.android.tools.idea.layoutinspector.ui.DeviceViewPanelModelKt;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import icons.StudioIcons;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/Toggle3dAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.layout-inspector"})
public final class Toggle3dAction
extends AnAction {
    public static final Toggle3dAction INSTANCE;

    public void actionPerformed(@NotNull AnActionEvent event) {
        DeviceViewPanelModel deviceViewPanelModel = (DeviceViewPanelModel)event.getData(DeviceViewPanelModelKt.getDEVICE_VIEW_MODEL_KEY());
        if (deviceViewPanelModel == null) {
            return;
        }
        DeviceViewPanelModel model2 = deviceViewPanelModel;
        if (model2.isRotated()) {
            model2.resetRotation();
        } else {
            model2.rotate(0.45, 0.06);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(@NotNull AnActionEvent event) {
        String string;
        super.update(event);
        DeviceViewPanelModel model2 = (DeviceViewPanelModel)event.getData(DeviceViewPanelModelKt.getDEVICE_VIEW_MODEL_KEY());
        DeviceViewPanelModel deviceViewPanelModel = model2;
        event.getPresentation().setIcon(deviceViewPanelModel != null && deviceViewPanelModel.isRotated() ? StudioIcons.LayoutInspector.RESET_VIEW : StudioIcons.LayoutInspector.MODE_3D);
        DeviceViewPanelModel deviceViewPanelModel2 = model2;
        if (deviceViewPanelModel2 != null && deviceViewPanelModel2.getRotatable()) {
            event.getPresentation().setEnabled(true);
            event.getPresentation().setText(model2.isRotated() ? "Reset View" : "Rotate View");
            return;
        }
        event.getPresentation().setEnabled(false);
        Presentation presentation = event.getPresentation();
        DeviceViewPanelModel deviceViewPanelModel3 = model2;
        if ((deviceViewPanelModel3 != null ? deviceViewPanelModel3.getOverlay() : null) != null) {
            string = "Rotation not available when overlay is active";
        } else {
            DeviceViewPanelModel deviceViewPanelModel4 = model2;
            if ((deviceViewPanelModel4 != null ? deviceViewPanelModel4.getPictureType() : null) == LayoutInspectorProto.ComponentTreeEvent.PayloadType.PNG_SKP_TOO_LARGE) {
                string = "Device image too large, rotation not available";
            } else {
                DeviceViewPanelModel deviceViewPanelModel5 = model2;
                string = (deviceViewPanelModel5 != null ? deviceViewPanelModel5.getPictureType() : null) == LayoutInspectorProto.ComponentTreeEvent.PayloadType.PNG_AS_REQUESTED ? "No compatible renderer found for device image, rotation not available" : "Rotation not available for devices below API 29";
            }
        }
        presentation.setText(string);
    }

    private Toggle3dAction() {
        super(StudioIcons.LayoutInspector.MODE_3D);
    }

    static {
        Toggle3dAction toggle3dAction;
        INSTANCE = toggle3dAction = new Toggle3dAction();
    }
}

