/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.android.tools.idea.layoutinspector.ui.SelectProcessAction;
import com.android.tools.idea.layoutinspector.ui.SelectProcessAction$updateActions$2;
import com.android.tools.idea.layoutinspector.ui.SelectProcessActionKt;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.profiler.proto.Common;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/SelectProcessAction;", "Lcom/android/tools/adtui/actions/DropDownAction;", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "(Lcom/android/tools/idea/layoutinspector/LayoutInspector;)V", "currentProcess", "Lcom/android/tools/profiler/proto/Common$Process;", "kotlin.jvm.PlatformType", "getLayoutInspector", "()Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "project", "Lcom/intellij/openapi/project/Project;", "displayTextInToolbar", "", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateActions", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "ConnectAction", "DeviceAction", "StopAction", "intellij.android.layout-inspector"})
public final class SelectProcessAction
extends DropDownAction {
    private Common.Process currentProcess;
    private Project project;
    @NotNull
    private final LayoutInspector layoutInspector;

    public void update(@NotNull AnActionEvent event) {
        this.project = event.getProject();
        if (Intrinsics.areEqual((Object)this.currentProcess, (Object)this.layoutInspector.getCurrentClient().getSelectedProcess()) ^ true) {
            String processName = StringsKt.substringAfterLast$default((String)this.layoutInspector.getCurrentClient().getSelectedProcess().getName(), (char)'.', null, (int)2, null);
            String actionName = Intrinsics.areEqual((Object)this.layoutInspector.getCurrentClient().getSelectedProcess(), (Object)Common.Process.getDefaultInstance()) ? "Select Process" : processName;
            this.currentProcess = this.layoutInspector.getCurrentClient().getSelectedProcess();
            event.getPresentation().setText(actionName);
            event.getPresentation().setIcon(SelectProcessActionKt.access$toIcon(this.layoutInspector.getCurrentClient().getSelectedStream().getDevice()));
        }
    }

    @VisibleForTesting
    public boolean updateActions(@NotNull DataContext context) {
        this.removeAll();
        boolean bl = false;
        Set serials = new LinkedHashSet();
        for (InspectorClient client : this.layoutInspector.getAllClients()) {
            for (Common.Stream stream : client.getStreams()) {
                String serial = stream.getDevice().getSerial();
                if (!serials.add(serial)) continue;
                String deviceName = SelectProcessActionKt.access$toDisplayName(stream.getDevice());
                if (stream.getDevice().getFeatureLevel() < 23) {
                    this.add(new AnAction(deviceName, deviceName + " (Unsupported for API < 23)"){
                        final /* synthetic */ String $deviceName;

                        public void update(@NotNull AnActionEvent event) {
                            event.getPresentation().setEnabled(false);
                        }

                        public void actionPerformed(@NotNull AnActionEvent e) {
                        }
                        {
                            this.$deviceName = $captured_local_variable$0;
                            super($super_call_param$1);
                        }
                    });
                    continue;
                }
                this.add((AnAction)new DeviceAction(deviceName, stream, client, this.layoutInspector.getLayoutInspectorModel().getProject()));
            }
        }
        if (this.getChildrenCount() == 0) {
            AnAction noDeviceAction2 = new AnAction("No devices detected"){

                public void update(@NotNull AnActionEvent event) {
                    event.getPresentation().setEnabled(false);
                }

                public void actionPerformed(@NotNull AnActionEvent event) {
                }
            };
            this.add(noDeviceAction2);
        } else {
            this.add(new StopAction((Function0<? extends InspectorClient>)((Function0)new SelectProcessAction$updateActions$2(this.layoutInspector))));
        }
        return true;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    @NotNull
    public final LayoutInspector getLayoutInspector() {
        return this.layoutInspector;
    }

    public SelectProcessAction(@NotNull LayoutInspector layoutInspector) {
        super("Select Process", "Select a process to connect to.", SelectProcessActionKt.access$getICON_PHONE$p());
        this.layoutInspector = layoutInspector;
        this.currentProcess = Common.Process.getDefaultInstance();
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0016H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/SelectProcessAction$ConnectAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "process", "Lcom/android/tools/profiler/proto/Common$Process;", "stream", "Lcom/android/tools/profiler/proto/Common$Stream;", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/profiler/proto/Common$Process;Lcom/android/tools/profiler/proto/Common$Stream;Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;Lcom/intellij/openapi/project/Project;)V", "getClient", "()Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "getProcess", "()Lcom/android/tools/profiler/proto/Common$Process;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getStream", "()Lcom/android/tools/profiler/proto/Common$Stream;", "connect", "Ljava/util/concurrent/Future;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.layout-inspector"})
    public static final class ConnectAction
    extends ToggleAction {
        @NotNull
        private final Common.Process process;
        @NotNull
        private final Common.Stream stream;
        @NotNull
        private final InspectorClient client;
        @NotNull
        private final Project project;

        public boolean isSelected(@NotNull AnActionEvent event) {
            return Intrinsics.areEqual((Object)this.process, (Object)this.client.getSelectedProcess()) && Intrinsics.areEqual((Object)this.stream, (Object)this.client.getSelectedStream());
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            if (state) {
                this.connect();
            }
        }

        @VisibleForTesting
        @NotNull
        public final Future<?> connect() {
            return ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
                final /* synthetic */ ConnectAction this$0;

                public final void run() {
                    try {
                        this.this$0.getClient().attach(this.this$0.getStream(), this.this$0.getProcess());
                    }
                    catch (StatusRuntimeException statusException) {
                        AndroidNotification.getInstance(this.this$0.getProject()).showBalloon("Connection Failed", "Connection failed: " + (statusException.getStatus().getDescription() == null ? statusException.getStatus().getCode().toString() : statusException.getStatus().getCode().toString() + ": " + statusException.getStatus().getDescription()), NotificationType.WARNING);
                    }
                }
                {
                    this.this$0 = connectAction;
                }
            });
        }

        @NotNull
        public final Common.Process getProcess() {
            return this.process;
        }

        @NotNull
        public final Common.Stream getStream() {
            return this.stream;
        }

        @NotNull
        public final InspectorClient getClient() {
            return this.client;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public ConnectAction(@NotNull Common.Process process, @NotNull Common.Stream stream, @NotNull InspectorClient client, @NotNull Project project) {
            super(process.getName() + " (" + process.getPid() + ')');
            this.process = process;
            this.stream = stream;
            this.client = client;
            this.project = project;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/SelectProcessAction$StopAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "client", "Lkotlin/Function0;", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "(Lkotlin/jvm/functions/Function0;)V", "getClient", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.layout-inspector"})
    private static final class StopAction
    extends AnAction {
        @NotNull
        private final Function0<InspectorClient> client;

        public void update(@NotNull AnActionEvent event) {
            event.getPresentation().setEnabled(((InspectorClient)this.client.invoke()).isConnected());
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            ((InspectorClient)this.client.invoke()).disconnect();
        }

        @NotNull
        public final Function0<InspectorClient> getClient() {
            return this.client;
        }

        public StopAction(@NotNull Function0<? extends InspectorClient> client) {
            super("Stop inspector");
            this.client = client;
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/SelectProcessAction$DeviceAction;", "Lcom/android/tools/adtui/actions/DropDownAction;", "deviceName", "", "stream", "Lcom/android/tools/profiler/proto/Common$Stream;", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/android/tools/profiler/proto/Common$Stream;Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;Lcom/intellij/openapi/project/Project;)V", "displayTextInToolbar", "", "intellij.android.layout-inspector"})
    public static final class DeviceAction
    extends DropDownAction {
        public boolean displayTextInToolbar() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public DeviceAction(@NotNull String deviceName, @NotNull Common.Stream stream, @NotNull InspectorClient client, @NotNull Project project) {
            super(deviceName, null, SelectProcessActionKt.access$toIcon(stream.getDevice()));
            Collection process2;
            void projectProcesses;
            Sequence processes2;
            void $this$flatMapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Sequence<Common.Process> allProcesses = client.getProcesses(stream);
            List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
            Iterable $this$mapNotNull$iv = facets;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AndroidModel androidModel;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                AndroidFacet it = (AndroidFacet)element$iv$iv;
                boolean bl2 = false;
                if (AndroidModel.get(it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                AndroidModel it$iv$iv = androidModel;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap22 = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                AndroidModel it = (AndroidModel)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getAllApplicationIds();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List applicationIds = (List)destination$iv$iv;
            Sequence $this$partition$iv = processes2 = SequencesKt.sortedWith(allProcesses, (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{processes.1.INSTANCE, processes.2.INSTANCE}));
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Common.Process it = (Common.Process)element$iv;
                boolean bl = false;
                if (applicationIds.contains(it.getName())) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            destination$iv$iv = new Pair(first$iv, second$iv);
            List $i$f$flatMap22 = (List)destination$iv$iv.component1();
            List otherProcesses = (List)destination$iv$iv.component2();
            for (Collection process2 : projectProcesses) {
                this.add((AnAction)new ConnectAction((Common.Process)process2, stream, client, project));
            }
            process2 = (Collection)projectProcesses;
            boolean bl = false;
            if (!process2.isEmpty()) {
                process2 = otherProcesses;
                bl = false;
                if (!process2.isEmpty()) {
                    this.add((AnAction)Separator.getInstance());
                }
            }
            for (Collection process2 : otherProcesses) {
                this.add((AnAction)new ConnectAction((Common.Process)process2, stream, client, project));
            }
            if (this.getChildrenCount() == 0) {
                this.add(SelectProcessActionKt.getNO_PROCESS_ACTION());
            }
        }
    }
}

