/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.completion;

import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.lang.databinding.DataBindingCompletionSupport;
import com.android.tools.idea.lang.databinding.completion.DataBindingCompletionSupportImpl;
import com.android.tools.idea.lang.databinding.config.DbFileType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.dom.layout.Layout;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0003\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/lang/databinding/completion/DataBindingCompletionSupportImpl;", "Lcom/android/tools/idea/lang/databinding/DataBindingCompletionSupport;", "()V", "addCompletions", "", "params", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "resultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillAliases", "packagePrefix", "", "originalPosition", "Lcom/intellij/psi/PsiElement;", "module", "Lcom/intellij/openapi/module/Module;", "originalParent", "fillClassNames", "getClassReferenceElement", "Lcom/intellij/codeInsight/completion/JavaPsiClassReferenceElement;", "alias", "referenceClass", "Lcom/intellij/psi/PsiClass;", "getRealContainingFile", "Lcom/intellij/psi/PsiFile;", "file", "Companion", "intellij.android.lang-databinding"})
public final class DataBindingCompletionSupportImpl
implements DataBindingCompletionSupport {
    public static final Companion Companion = new Companion(null);

    @Override
    public void addCompletions(@NotNull CompletionParameters params, @NotNull CompletionResultSet resultSet) {
        PsiElement originalPosition = params.getOriginalPosition();
        PsiElement psiElement = originalPosition;
        if (psiElement == null || (psiElement = psiElement.getParent()) == null) {
            return;
        }
        PsiElement originalParent = psiElement;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalParent);
        if (module2 == null) {
            return;
        }
        Module module3 = module2;
        if (this.getRealContainingFile(originalParent.getContainingFile()) == null) {
            return;
        }
        String packagePrefix = DataBindingCompletionSupportImpl.Companion.getPackagePrefix(originalParent, params.getOffset());
        this.fillAliases(resultSet, packagePrefix, originalPosition, module3, originalParent);
        this.fillClassNames(resultSet, packagePrefix, module3);
    }

    private final void fillAliases(CompletionResultSet resultSet, String packagePrefix, PsiElement originalPosition, Module module2, PsiElement originalParent) {
        XmlTag tag;
        PsiFile containingFile = this.getRealContainingFile(originalParent.getContainingFile());
        if (!(containingFile instanceof XmlFile)) {
            return;
        }
        Project project = module2.getProject();
        DomManager domManager = DomManager.getDomManager((Project)project);
        if (domManager.getDomElement(tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, XmlTag.class, (boolean)false, (Class[])new Class[]{PsiFile.class})) instanceof Import) {
            return;
        }
        DomFileElement domFileElement = domManager.getFileElement((XmlFile)containingFile, Layout.class);
        if (domFileElement == null) {
            return;
        }
        DomFileElement file2 = domFileElement;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope moduleScope = ProjectSystemUtil.getModuleSystem(module2).getResolveScope(ScopeType.MAIN);
        for (Data data : ((Layout)file2.getRootElement()).getDataElements()) {
            String type;
            String alias;
            String fqcn;
            Import import_;
            Object v1;
            PsiClass aClass;
            block15: {
                CharSequence charSequence = packagePrefix;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    for (Import import_2 : data.getImports()) {
                        String alias2;
                        XmlAttributeValue type2;
                        if (DataBindingUtil.getAlias(import_2) == null) {
                            continue;
                        }
                        if (import_2.getType().getXmlAttributeValue() == null) {
                            continue;
                        }
                        String typeValue = StringsKt.replace$default((String)type2.getValue(), (char)'$', (char)'.', (boolean)false, (int)4, null);
                        aClass = facade.findClass(typeValue, moduleScope);
                        if (aClass == null) continue;
                        resultSet.addElement((LookupElement)this.getClassReferenceElement(alias2, aClass));
                    }
                    continue;
                }
                String possibleAlias = StringsKt.substringBefore$default((String)packagePrefix, (char)'.', null, (int)2, null);
                Iterable $this$firstOrNull$iv = data.getImports();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Import import_3 = (Import)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DataBindingUtil.getAlias(import_3), (Object)possibleAlias)) continue;
                    v1 = element$iv;
                    break block15;
                }
                v1 = null;
            }
            if ((Import)v1 == null) {
                continue;
            }
            if (import_.getType().getStringValue() == null) {
                continue;
            }
            if (DataBindingUtil.getAlias(import_) == null) {
                Intrinsics.throwNpe();
            }
            if (facade.findClass(fqcn = StringsKt.replaceFirst$default((String)packagePrefix, (String)alias, (String)type, (boolean)false, (int)4, null), moduleScope) == null) {
                continue;
            }
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])aClass.getInnerClasses()), (Function1)fillAliases.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiClass innerClass = (PsiClass)element$iv;
                boolean bl = false;
                String string = innerClass.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                resultSet.addElement((LookupElement)this.getClassReferenceElement(string, innerClass));
            }
        }
    }

    private final void fillClassNames(CompletionResultSet resultSet, String packagePrefix, Module module2) {
        block7: {
            GlobalSearchScope moduleScope;
            PsiPackage rootPackage;
            Project project;
            block6: {
                project = module2.getProject();
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
                rootPackage = javaPsiFacade.findPackage(packagePrefix);
                moduleScope = ProjectSystemUtil.getModuleSystem(module2).getResolveScope(ScopeType.MAIN);
                if (rootPackage != null) break block6;
                PsiClass outerClass = javaPsiFacade.findClass(packagePrefix, moduleScope);
                if (outerClass == null) break block7;
                for (PsiClass innerClass : outerClass.getInnerClasses()) {
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(innerClass));
                }
                break block7;
            }
            Object $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])rootPackage.getSubPackages(moduleScope)), (Function1)((Function1)new Function1<PsiPackage, Boolean>(moduleScope){
                final /* synthetic */ GlobalSearchScope $moduleScope;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke(PsiPackage pkg) {
                    PsiPackage[] psiPackageArray = pkg.getSubPackages(this.$moduleScope);
                    boolean bl = false;
                    PsiPackage[] psiPackageArray2 = psiPackageArray;
                    boolean bl2 = false;
                    if (psiPackageArray2.length != 0) return true;
                    boolean bl3 = true;
                    if (!bl3) {
                        return true;
                    }
                    boolean bl4 = false;
                    if (bl4) return true;
                    psiPackageArray = pkg.getClasses(this.$moduleScope);
                    bl = false;
                    psiPackageArray2 = psiPackageArray;
                    bl2 = false;
                    if (psiPackageArray2.length != 0) return true;
                    return false;
                }
                {
                    this.$moduleScope = globalSearchScope;
                    super(1);
                }
            })), (Function1)fillClassNames.2.INSTANCE);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                PsiPackage pkg = (PsiPackage)element$iv;
                boolean bl = false;
                resultSet.addElement((LookupElement)new TailTypeDecorator<LookupElement>(pkg, (LookupElement)LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)pkg)), resultSet, project){
                    final /* synthetic */ PsiPackage $pkg;
                    final /* synthetic */ CompletionResultSet $resultSet$inlined;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$pkg = $captured_local_variable$1;
                        this.$resultSet$inlined = completionResultSet;
                        this.$project$inlined = project;
                        super($super_call_param$2);
                    }

                    protected TailType computeTailType(@NotNull InsertionContext context) {
                        return TailType.DOT;
                    }

                    public void handleInsert(@NotNull InsertionContext context) {
                        super.handleInsert(context);
                        AutoPopupController.getInstance((Project)this.$project$inlined).scheduleAutoPopup(context.getEditor());
                    }
                });
            }
            $this$forEach$iv = rootPackage.getName();
            $i$f$forEach = false;
            boolean bl = false;
            if ($this$forEach$iv == null || $this$forEach$iv.length() == 0) {
                Query query = AllClassesSearch.search((SearchScope)((SearchScope)moduleScope), (Project)project);
                Iterable $this$forEach$iv2 = (Iterable)query;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    PsiClass psiClass = (PsiClass)element$iv;
                    boolean bl2 = false;
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(psiClass));
                }
            } else {
                for (PsiClass psiClass : rootPackage.getClasses(moduleScope)) {
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(psiClass));
                }
            }
        }
    }

    @Contract(value="!null -> !null; null -> null")
    private final PsiFile getRealContainingFile(PsiFile file2) {
        PsiFile psiFile2 = file2;
        if (Intrinsics.areEqual((Object)(psiFile2 != null ? psiFile2.getFileElementType() : null), (Object)((Object)DbFileType.INSTANCE))) {
            PsiFile psiFile3 = file2;
            return psiFile3 != null && (psiFile3 = psiFile3.getContext()) != null ? psiFile3.getContainingFile() : null;
        }
        return file2;
    }

    private final JavaPsiClassReferenceElement getClassReferenceElement(String alias, PsiClass referenceClass) {
        JavaPsiClassReferenceElement element2 = new JavaPsiClassReferenceElement(referenceClass);
        element2.setForcedPresentableName(alias);
        element2.setInsertHandler((InsertHandler)getClassReferenceElement.1.INSTANCE);
        return element2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/lang/databinding/completion/DataBindingCompletionSupportImpl$Companion;", "", "()V", "getPackagePrefix", "", "context", "Lcom/intellij/psi/PsiElement;", "offset", "", "text", "", "intellij.android.lang-databinding"})
    public static final class Companion {
        private final String getPackagePrefix(PsiElement context, int offset2) {
            return this.getPackagePrefix(context.getContainingFile().getViewProvider().getContents(), offset2);
        }

        @VisibleForTesting
        @NotNull
        public final String getPackagePrefix(@NotNull CharSequence text2, int offset2) {
            String string;
            String startToOffset;
            int lastPeriodIndex;
            int startIndex;
            for (startIndex = offset2; startIndex > 0; --startIndex) {
                char c = text2.charAt(startIndex - 1);
                boolean bl = false;
                boolean bl2 = false;
                char c2 = c;
                boolean bl3 = false;
                if (!(Character.isJavaIdentifierPart(c2) || c2 == '.')) break;
            }
            if ((lastPeriodIndex = StringsKt.lastIndexOf$default((CharSequence)(startToOffset = ((Object)text2.subSequence(startIndex, offset2)).toString()), (char)'.', (int)0, (boolean)false, (int)6, null)) > 0) {
                String string2 = startToOffset;
                int n = 0;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, lastPeriodIndex);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = "";
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

