/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.idea.VariantSwitcher;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildVariantUpdater {
    @NotNull
    public static final Key<String> MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI = new Key("module.with.build.variant.switched.from.ui");
    @NotNull
    public static final Key<Boolean> USE_VARIANTS_FROM_PREVIOUS_GRADLE_SYNCS = new Key("use.variants.from.previous.gradle.syncs");
    @NotNull
    private final List<BuildVariantView.BuildVariantSelectionChangeListener> mySelectionChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public static BuildVariantUpdater getInstance(@NotNull Project project) {
        return (BuildVariantUpdater)ServiceManager.getService((Project)project, BuildVariantUpdater.class);
    }

    BuildVariantUpdater() {
    }

    void addSelectionChangeListener(@NotNull BuildVariantView.BuildVariantSelectionChangeListener listener2) {
        this.mySelectionChangeListeners.add(listener2);
    }

    public boolean updateSelectedBuildVariant(@NotNull Project project, @NotNull String moduleName2, @NotNull String selectedBuildVariant) {
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module '%1$s'.", moduleName2));
            return false;
        }
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfItHasNativeVariantAbis(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (ndkModuleModel == null || ndkFacet == null) {
            return this.updateSelectedVariant(project, moduleName2, selectedBuildVariant);
        }
        VariantAbi newVariantAbi = BuildVariantUpdater.resolveNewVariantAbi(ndkFacet, ndkModuleModel, selectedBuildVariant, null);
        if (newVariantAbi == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find suitable ABI for native module '%1$s'.", moduleName2));
            return false;
        }
        return this.updateSelectedVariant(project, moduleName2, newVariantAbi.getDisplayName());
    }

    boolean updateSelectedAbi(@NotNull Project project, @NotNull String moduleName2, @NotNull String selectedAbiName) {
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find module '%1$s'.", moduleName2));
            return false;
        }
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfItHasNativeVariantAbis(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (ndkModuleModel == null || ndkFacet == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find native module model '%1$s'.", moduleName2));
            return false;
        }
        VariantAbi currentSelectedVariantAbi = ndkFacet.getSelectedVariantAbi();
        VariantAbi newVariantAbi = currentSelectedVariantAbi == null ? null : BuildVariantUpdater.resolveNewVariantAbi(ndkFacet, ndkModuleModel, currentSelectedVariantAbi.getVariant(), selectedAbiName);
        if (newVariantAbi == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find suitable ABI for native module '%1$s'.", moduleName2));
            return false;
        }
        return this.updateSelectedVariant(project, moduleName2, newVariantAbi.getDisplayName());
    }

    private boolean updateSelectedVariant(@NotNull Project project, @NotNull String moduleName2, @NotNull String buildVariantName) {
        ArrayList<AndroidFacet> affectedAndroidFacets = new ArrayList<AndroidFacet>();
        ArrayList<NdkFacet> affectedNdkFacets = new ArrayList<NdkFacet>();
        boolean variantToUpdateExists = BuildVariantUpdater.findAndUpdateAffectedFacets(project, moduleName2, buildVariantName, affectedAndroidFacets, affectedNdkFacets);
        if (affectedAndroidFacets.isEmpty() && affectedNdkFacets.isEmpty()) {
            return false;
        }
        Runnable invokeVariantSelectionChangeListeners = () -> {
            for (BuildVariantView.BuildVariantSelectionChangeListener listener2 : this.mySelectionChangeListeners) {
                listener2.selectionChanged();
            }
        };
        if (BuildVariantUpdater.hasBuildFilesChanged(project)) {
            BuildVariantUpdater.setVariantSwitchedProperty(project, moduleName2);
            BuildVariantUpdater.requestFullGradleSync(project, invokeVariantSelectionChangeListeners);
        } else if (!variantToUpdateExists) {
            project.putUserData(USE_VARIANTS_FROM_PREVIOUS_GRADLE_SYNCS, (Object)true);
            BuildVariantUpdater.setVariantSwitchedProperty(project, moduleName2);
            BuildVariantUpdater.requestVariantOnlyGradleSync(project, moduleName2, invokeVariantSelectionChangeListeners);
        } else {
            ArrayList<AndroidFacet> allAndroidFacets = new ArrayList<AndroidFacet>();
            for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
                if (androidFacet == null) continue;
                allAndroidFacets.add(androidFacet);
            }
            BuildVariantUpdater.setupCachedVariant(project, allAndroidFacets, invokeVariantSelectionChangeListeners);
        }
        return true;
    }

    private static void setVariantSwitchedProperty(@NotNull Project project, @NotNull String moduleName2) {
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2);
        if (moduleToUpdate == null) {
            return;
        }
        String moduleId = BuildVariantUpdater.getModuleIdForModule(moduleToUpdate);
        if (moduleId != null) {
            project.putUserData(MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI, (Object)moduleId);
        }
    }

    @Nullable
    public static String getModuleIdForModule(@NotNull Module module2) {
        String gradlePath;
        ExternalSystemModulePropertyManager propertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module2);
        String rootProjectPath = propertyManager.getRootProjectPath();
        if (rootProjectPath != null && (gradlePath = propertyManager.getLinkedProjectId()) != null) {
            return Modules.createUniqueModuleId(rootProjectPath, gradlePath);
        }
        return null;
    }

    private static boolean findAndUpdateAffectedFacets(@NotNull Project project, @NotNull String moduleName2, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        AndroidModuleModel androidModel;
        NdkModuleModel ndkModuleModel;
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module '%1$s'.", moduleName2));
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && ndkFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowBuildVariantFailure(msg);
        }
        boolean ndkVariantExists = true;
        boolean androidVariantExists = true;
        String variantName = variantToSelect;
        String abiName = null;
        if (ndkFacet != null && (ndkModuleModel = BuildVariantUpdater.getNdkModelIfItHasNativeVariantAbis(ndkFacet)) != null) {
            VariantAbi variantAbiToSelect = VariantAbi.fromString(variantToSelect);
            if (variantAbiToSelect == null) {
                BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot parse variant and ABI '%s'.", variantToSelect));
                return false;
            }
            if (ndkModuleModel.getAllVariantAbis().contains(variantAbiToSelect)) {
                ndkVariantExists = BuildVariantUpdater.updateAffectedFacetsForNdkModule(ndkFacet, ndkModuleModel, variantAbiToSelect, affectedNdkFacets);
                variantName = variantAbiToSelect.getVariant();
                abiName = variantAbiToSelect.getAbi();
            }
        }
        if (androidFacet != null && (androidModel = BuildVariantUpdater.getAndroidModel(androidFacet)) != null) {
            androidVariantExists = BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, androidFacet, androidModel, variantName, abiName, affectedAndroidFacets, affectedNdkFacets);
        }
        return ndkVariantExists && androidVariantExists;
    }

    private static boolean updateAffectedFacetsForNdkModule(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModuleModel, @NotNull VariantAbi variantAbiToSelect, @NotNull List<NdkFacet> affectedNdkFacets) {
        if (variantAbiToSelect.equals(ndkFacet.getSelectedVariantAbi()) && ndkModuleModel.getSyncedVariantAbis().contains(variantAbiToSelect)) {
            return true;
        }
        affectedNdkFacets.add(ndkFacet);
        ndkFacet.setSelectedVariantAbi(variantAbiToSelect);
        return ndkModuleModel.getSyncedVariantAbis().contains(variantAbiToSelect);
    }

    private static boolean updateAffectedFacetsForAndroidModule(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull AndroidModuleModel androidModel, @NotNull String variantToSelect, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        boolean isAbiChanged;
        boolean isVariantChanged = !variantToSelect.equals(androidModel.getSelectedVariant().getName());
        boolean bl = isAbiChanged = abiToSelect != null;
        if (!isVariantChanged && !isAbiChanged) {
            return true;
        }
        if (isVariantChanged) {
            affectedAndroidFacets.add(androidFacet);
            androidFacet.getProperties().SELECTED_BUILD_VARIANT = variantToSelect;
        }
        if (!androidModel.variantExists(variantToSelect)) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        BuildVariantUpdater.updateSelectedVariantsForDependencyModules(project, androidModel, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        return true;
    }

    private static void updateSelectedVariantsForDependencyModules(@NotNull Project project, @NotNull AndroidModuleModel androidModel, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        Module dependencyModule;
        for (IdeLibrary library : androidModel.getSelectedMainCompileLevel2Dependencies().getModuleDependencies()) {
            if (!StringUtil.isNotEmpty((String)library.getVariant()) || !StringUtil.isNotEmpty((String)library.getProjectPath())) continue;
            dependencyModule = ProjectStructure.getInstance(project).getModuleFinder().findModuleFromLibrary(library);
            BuildVariantUpdater.updateDependencyModule(project, library.getProjectPath(), dependencyModule, library.getVariant(), abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
        for (String gradlePath : androidModel.getAndroidProject().getDynamicFeatures()) {
            if (!StringUtil.isNotEmpty((String)gradlePath) || (dependencyModule = GradleUtil.findModuleByGradlePath(project, gradlePath)) == null) continue;
            AndroidModuleModel depModuleModel = AndroidModuleModel.get(dependencyModule);
            String variantToSelect = androidModel.getSelectedVariant().getName();
            if (depModuleModel == null || !depModuleModel.getVariantNames().contains(variantToSelect)) continue;
            BuildVariantUpdater.updateDependencyModule(project, gradlePath, dependencyModule, variantToSelect, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
    }

    private static void updateDependencyModule(@NotNull Project project, @NotNull String gradlePath, @Nullable Module dependencyModule, @NotNull String projectVariant, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        if (dependencyModule == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module with Gradle path '%1$s'.", gradlePath));
            return;
        }
        AndroidFacet dependencyFacet = AndroidFacet.getInstance((Module)dependencyModule);
        if (dependencyFacet == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find 'Android' facet in module '%1$s'.", dependencyModule.getName()));
            return;
        }
        AndroidModuleModel dependencyModel = BuildVariantUpdater.getAndroidModel(dependencyFacet);
        if (dependencyModel != null) {
            VariantAbi projectVariantWithAbi;
            NdkModuleModel dependencyNdkModel;
            NdkFacet dependencyNdkFacet = NdkFacet.getInstance(dependencyModule);
            NdkModuleModel ndkModuleModel = dependencyNdkModel = dependencyNdkFacet == null ? null : BuildVariantUpdater.getNdkModelIfItHasNativeVariantAbis(dependencyNdkFacet);
            if (dependencyNdkModel != null && (projectVariantWithAbi = BuildVariantUpdater.resolveNewVariantAbi(dependencyNdkFacet, dependencyNdkModel, projectVariant, abiToSelect)) != null) {
                BuildVariantUpdater.updateAffectedFacetsForNdkModule(dependencyNdkFacet, dependencyNdkModel, projectVariantWithAbi, affectedNdkFacets);
            }
            BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, dependencyFacet, dependencyModel, projectVariant, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
    }

    @Nullable
    private static VariantAbi resolveNewVariantAbi(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModel, @NotNull String newVariant, @Nullable String userSelectedAbi) {
        VariantAbi selectedVariantAbi;
        if (userSelectedAbi != null) {
            VariantAbi newVariantAbi = new VariantAbi(newVariant, userSelectedAbi);
            if (ndkModel.getAllVariantAbis().contains(newVariantAbi)) {
                return newVariantAbi;
            }
        }
        if ((selectedVariantAbi = ndkFacet.getSelectedVariantAbi()) == null) {
            return null;
        }
        String existingAbi = selectedVariantAbi.getAbi();
        VariantAbi proposedVariantAbi = new VariantAbi(newVariant, existingAbi);
        if (ndkModel.getAllVariantAbis().contains(proposedVariantAbi)) {
            return proposedVariantAbi;
        }
        return ndkModel.getAllVariantAbis().stream().filter(variantAbi -> variantAbi.getVariant().equals(newVariant)).findFirst().orElse(null);
    }

    private static boolean hasBuildFilesChanged(@NotNull Project project) {
        return GradleSyncState.getInstance(project).isSyncNeeded().equals((Object)ThreeState.YES);
    }

    private static void requestFullGradleSync(@NotNull Project project, @NotNull Runnable variantSelectionChangeListeners) {
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_FULL_SYNC, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
    }

    @NotNull
    private static GradleSyncListener getSyncListener(final @NotNull Runnable variantSelectionChangeListeners) {
        return new GradleSyncListener(){

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                project.putUserData(USE_VARIANTS_FROM_PREVIOUS_GRADLE_SYNCS, null);
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                project.putUserData(USE_VARIANTS_FROM_PREVIOUS_GRADLE_SYNCS, null);
                variantSelectionChangeListeners.run();
            }
        };
    }

    private static void requestVariantOnlyGradleSync(@NotNull Project project, @NotNull String moduleName2, @NotNull Runnable variantSelectionChangeListeners) {
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2);
        if (moduleToUpdate == null) {
            return;
        }
        GradleFacet gradleFacet = GradleFacet.getInstance(moduleToUpdate);
        if (gradleFacet == null) {
            return;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(moduleToUpdate);
        GradleModuleModel gradleModel = gradleFacet.getGradleModuleModel();
        if (androidModel != null && gradleModel != null) {
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_CHANGED_BY_USER);
            GradleSyncInvoker.getInstance().requestProjectSync(project, request, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
        }
    }

    private static void setupCachedVariant(final @NotNull Project project, final @NotNull List<AndroidFacet> affectedAndroidFacets, final @NotNull Runnable variantSelectionChangeListeners) {
        final Application application = ApplicationManager.getApplication();
        Task.Backgroundable task2 = new Task.Backgroundable(project, "Setting up Project", false){

            public void run(@NotNull ProgressIndicator indicator) {
                BuildVariantUpdater.getLog().info("Starting setup of cached variant");
                VariantSwitcher.switchVariant(project, affectedAndroidFacets);
                GradleSyncState.getInstance(project).syncSkipped(null);
                if (application.isUnitTestMode()) {
                    variantSelectionChangeListeners.run();
                } else {
                    application.invokeLater(variantSelectionChangeListeners);
                }
                BuildVariantUpdater.getLog().info("Finished setup of cached variant");
            }
        };
        if (application.isUnitTestMode()) {
            task2.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        }
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName2) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName2);
    }

    @Nullable
    private static AndroidModuleModel getAndroidModel(@NotNull AndroidFacet facet2) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet2);
        if (androidModel == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find AndroidProject for module '%1$s'.", facet2.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModelIfItHasNativeVariantAbis(@NotNull NdkFacet facet2) {
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet2);
        if (ndkModuleModel == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet2.getModule().getName()));
            return null;
        }
        if (ndkModuleModel.getAllVariantAbis().isEmpty()) {
            return null;
        }
        return ndkModuleModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModelIfItHasNativeVariantAbis(@NotNull Module module2) {
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(module2);
        if (ndkModuleModel == null) {
            return null;
        }
        if (ndkModuleModel.getAllVariantAbis().isEmpty()) {
            return null;
        }
        return ndkModuleModel;
    }

    private static void logAndShowBuildVariantFailure(@NotNull String reason) {
        String prefix = "Unable to select build variant:\n";
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    private static void logAndShowAbiNameFailure(@NotNull String reason) {
        String prefix = "Unable to select ABI:\n";
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(BuildVariantUpdater.class);
    }
}

